/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.view;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import jdk.graal.compiler.graphio.parsing.model.ChangedEvent;
import jdk.graal.compiler.graphio.parsing.model.ChangedListener;
import jdk.graal.compiler.graphio.parsing.model.Folder;
import jdk.graal.compiler.graphio.parsing.model.GraphContainer;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import org.graalvm.visualizer.data.Source;
import org.graalvm.visualizer.difference.Difference;
import org.graalvm.visualizer.filter.DiagramFilters;
import org.graalvm.visualizer.filter.Filter;
import org.graalvm.visualizer.filter.FilterChain;
import org.graalvm.visualizer.filter.FilterSequence;
import org.graalvm.visualizer.graph.Diagram;
import org.graalvm.visualizer.graph.Figure;
import org.graalvm.visualizer.graph.Slot;
import org.graalvm.visualizer.script.ScriptEnvironment;
import org.graalvm.visualizer.settings.layout.LayoutSettings;
import org.graalvm.visualizer.util.RangeSliderModel;
import org.graalvm.visualizer.view.api.DiagramEvent;
import org.graalvm.visualizer.view.api.DiagramListener;
import org.graalvm.visualizer.view.api.DiagramModel;
import org.graalvm.visualizer.view.api.TimelineModel;
import org.graalvm.visualizer.view.impl.DiagramCache;
import org.graalvm.visualizer.view.impl.Filters;
import org.openide.util.Lookup;
import org.openide.util.Pair;
import org.openide.util.Utilities;

public class DiagramViewModel
implements ChangedListener<RangeSliderModel>,
DiagramModel,
DiagramFilters {
    private static final Logger LOG = Logger.getLogger(DiagramViewModel.class.getName());
    private Lookup lookup = Lookup.EMPTY;
    private GraphContainer graphContainer;
    private Set<Integer> hiddenNodes;
    private Set<InputNode> selectedNodes;
    private final Filters filters;
    private volatile Diagram diagram;
    private volatile Reference<Diagram> previousDiagram = new WeakReference<Object>(null);
    private InputGraph inputGraph;
    private LayoutSettings.LayoutSettingBean layoutSetting;
    private final ChangedEvent<DiagramViewModel> diagramChangedEvent;
    private final Object sync = new Object();
    private volatile boolean showNodeHull;
    private boolean hideDuplicates;
    private final RangeSliderModel graphPeerModel;
    private final PropertyChangeSupport propSupport = new PropertyChangeSupport(this);
    private final List<DiagramListener> listeners = new ArrayList<DiagramListener>();
    public static final String PROP_SHOW_BLOCKS = "showBlocks";
    public static final String PROP_SHOW_NODE_HULL = "showNodeHull";
    public static final String PROP_HIDE_DUPLICATES = "hideDuplicates";
    public static final String PROP_FILTERS = "filters";
    public static final String PROP_HIDDEN_NODES = "hiddenNodes";
    public static final String PROP_SELECTED_GRAPH = "selectedGraph";
    public static final String PROP_LAYOUT_SETTING = "layoutSetting";
    public static final String PROP_SELECTED_NODES = "selectedNodes";
    public static final String PROP_SCRIPTS_CLEARED = "scriptsCleared";
    public static final String PROP_CONTAINER_CHANGED = "graphContainerChanged";
    private List<W> tasks = new ArrayList<W>();
    private final ChangedEvent<DiagramViewModel> changedEvent = new ChangedEvent((Object)this);
    private final ChangedListener<Filters> filtersChanged = s -> {
        LOG.log(Level.FINE, "Filters changed.");
        this.propSupport.firePropertyChange(PROP_FILTERS, null, null);
        this.diagramChanged(true);
    };
    private final TimelineModel timeline;
    private Set<InputNode> hiddenCurrentGraphNodes;
    private InputGraph emptyGraph;
    private final Map<Pair<InputGraph, InputGraph>, Reference<InputGraph>> diffCache = new HashMap<Pair<InputGraph, InputGraph>, Reference<InputGraph>>();

    public DiagramViewModel copy() {
        DiagramViewModel result = new DiagramViewModel(this.graphContainer, (FilterSequence<FilterChain>)this.filters.getFilterChain(), this.layoutSetting);
        result.setDataInternal(this);
        return result;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propSupport.addPropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String p, PropertyChangeListener l) {
        this.propSupport.addPropertyChangeListener(p, l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propSupport.removePropertyChangeListener(l);
    }

    public void removePropertyChangeListener(String p, PropertyChangeListener l) {
        this.propSupport.removePropertyChangeListener(p, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDiagramListener(DiagramListener l) {
        DiagramViewModel diagramViewModel = this;
        synchronized (diagramViewModel) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDiagramListener(DiagramListener l) {
        DiagramViewModel diagramViewModel = this;
        synchronized (diagramViewModel) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDiagramEvent(Supplier<DiagramEvent> eventFactory, BiConsumer<DiagramListener, DiagramEvent> fn) {
        ArrayList<DiagramListener> ll;
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.fireDiagramEvent(eventFactory, fn));
            return;
        }
        DiagramViewModel diagramViewModel = this;
        synchronized (diagramViewModel) {
            if (this.listeners.isEmpty()) {
                return;
            }
            ll = new ArrayList<DiagramListener>(this.listeners);
        }
        DiagramEvent event = eventFactory.get();
        ll.stream().forEach(l -> {
            try {
                fn.accept((DiagramListener)l, event);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
    }

    public GraphContainer getContainer() {
        return this.graphContainer;
    }

    public RangeSliderModel getDiagramPeers() {
        return this.graphPeerModel;
    }

    public ChangedEvent<DiagramViewModel> getChangedEvent() {
        return this.changedEvent;
    }

    public ChangedEvent<RangeSliderModel> getColorChangedEvent() {
        return this.graphPeerModel.getColorChangedEvent();
    }

    private boolean getPositionsDiffer(RangeSliderModel rsm) {
        return this.graphPeerModel.getFirstPosition() != rsm.getFirstPosition() || this.graphPeerModel.getSecondPosition() != rsm.getSecondPosition();
    }

    private boolean getColorsDiffer(RangeSliderModel rsm) {
        return !this.graphPeerModel.getColors().equals(rsm.getColors());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(DiagramViewModel newModel) {
        RangeSliderModel newPeerModel = newModel.getDiagramPeers();
        boolean changed = this.getPositionsDiffer(newPeerModel);
        boolean colorChanged = this.getColorsDiffer(newPeerModel);
        boolean groupChanged = this.getGroupsDiffers(newModel);
        boolean diagramChanged = this.getDiagramsDiffers(newModel);
        InputGraph oldInputGraph = this.inputGraph;
        Set<Integer> oldHidden = this.hiddenNodes;
        Set<InputNode> oldSelected = this.selectedNodes;
        boolean oldShowBlocks = (Boolean)this.layoutSetting.get(Boolean.class, "SHOW_BLOCKS");
        boolean oldShowNodeHull = this.showNodeHull;
        boolean oldHideDuplicates = this.hideDuplicates;
        GraphContainer oldContainer = this.graphContainer;
        LayoutSettings.LayoutSettingBean oldLayoutSetting = this.layoutSetting;
        List<Filter> oldFilters = this.getFilters();
        LOG.log(Level.FINE, "Changed data to {0}, changed part = [ change:{1}, color:{2}, group:{3}, diagram:{4} ]", new Object[]{newModel, changed, colorChanged, groupChanged, diagramChanged});
        boolean[] alreadyFired = new boolean[1];
        ChangedListener cl = e -> {
            alreadyFired[0] = true;
        };
        this.getChangedEvent().addListener((Object)cl);
        try {
            this.setDataInternal(newModel);
        }
        finally {
            this.getChangedEvent().removeListener((Object)cl);
        }
        if (changed && !alreadyFired[0]) {
            this.getChangedEvent().fire();
        }
        if (this.timeline != null) {
            this.timeline.setHideDuplicates(newModel.hideDuplicates);
        }
        this.propSupport.firePropertyChange(PROP_CONTAINER_CHANGED, oldContainer, this.graphContainer);
        this.propSupport.firePropertyChange(PROP_FILTERS, oldFilters, this.getFilters());
        this.propSupport.firePropertyChange(PROP_HIDDEN_NODES, oldHidden, this.hiddenNodes);
        this.propSupport.firePropertyChange(PROP_SELECTED_GRAPH, oldInputGraph, this.inputGraph);
        this.propSupport.firePropertyChange(PROP_SHOW_BLOCKS, oldShowBlocks, (Boolean)this.layoutSetting.get(Boolean.class, "SHOW_BLOCKS"));
        this.propSupport.firePropertyChange(PROP_HIDE_DUPLICATES, oldHideDuplicates, this.hideDuplicates);
        this.propSupport.firePropertyChange(PROP_SELECTED_NODES, oldSelected, this.selectedNodes);
        this.propSupport.firePropertyChange(PROP_SHOW_NODE_HULL, oldShowNodeHull, this.showNodeHull);
        this.propSupport.firePropertyChange(PROP_LAYOUT_SETTING, oldLayoutSetting, this.layoutSetting);
        if (diagramChanged) {
            this.fireDiagramChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setDataInternal(DiagramViewModel newModel) {
        Object object = this.sync;
        synchronized (object) {
            this.graphContainer = newModel.graphContainer;
            this.inputGraph = newModel.inputGraph;
            this.filters.setDataInternal(newModel.filters);
            this.layoutSetting = newModel.layoutSetting.copy();
            this.diagram = null;
            this.setHiddenNodes0(newModel.hiddenNodes);
            this.selectedNodes = new HashSet<InputNode>(newModel.selectedNodes);
            this.showNodeHull = newModel.showNodeHull;
            this.hideDuplicates = newModel.hideDuplicates;
        }
        this.graphPeerModel.setData(newModel.getDiagramPeers());
    }

    protected boolean getGroupsDiffers(DiagramViewModel newModel) {
        return !this.graphContainer.equals(newModel.graphContainer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getDiagramsDiffers(DiagramViewModel newModel) {
        Diagram d2;
        Diagram d1;
        Object object = this.sync;
        synchronized (object) {
            d1 = this.diagram;
        }
        object = newModel.sync;
        synchronized (object) {
            d2 = newModel.diagram;
        }
        return d1 != d2;
    }

    public boolean getShowBlocks() {
        return (Boolean)this.layoutSetting.get(Boolean.class, "SHOW_BLOCKS");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShowBlocks(boolean b) {
        Object object = this.sync;
        synchronized (object) {
            if (this.getShowBlocks() == b) {
                return;
            }
            this.layoutSetting.set("SHOW_BLOCKS", (Object)b);
        }
        LOG.log(Level.OFF, "ShowBlocks changed: {0}", b);
        this.propSupport.firePropertyChange(PROP_SHOW_BLOCKS, !b, b);
        this.diagramChanged();
    }

    public boolean getShowNodeHull() {
        return this.showNodeHull;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShowNodeHull(boolean b) {
        Object object = this.sync;
        synchronized (object) {
            if (this.showNodeHull == b) {
                return;
            }
            this.showNodeHull = b;
        }
        LOG.log(Level.FINE, "Show node hull changed: {0}", b);
        this.propSupport.firePropertyChange(PROP_SHOW_NODE_HULL, !b, b);
        this.diagramChanged();
    }

    public String getNodeText() {
        return (String)this.layoutSetting.get(String.class, "NODE_TEXT");
    }

    public LayoutSettings.LayoutSettingBean getLayoutSetting() {
        return this.layoutSetting;
    }

    public void setLayoutSetting(LayoutSettings.LayoutSettingBean newLayoutSetting) {
        if (this.layoutSetting.equals((Object)newLayoutSetting)) {
            return;
        }
        LOG.log(Level.FINE, "LayoutSetting changed.");
        LayoutSettings.LayoutSettingBean oldLayoutSetting = this.layoutSetting;
        this.layoutSetting = newLayoutSetting;
        this.propSupport.firePropertyChange(PROP_LAYOUT_SETTING, oldLayoutSetting, newLayoutSetting);
        this.diagramChanged(true);
    }

    public boolean getHideDuplicates() {
        return this.timeline != null && this.timeline.isHideDuplicates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHideDuplicates(boolean b) {
        DiagramViewModel diagramViewModel = this;
        synchronized (diagramViewModel) {
            if (this.timeline != null) {
                this.hideDuplicates = this.timeline.isHideDuplicates();
            }
            if (b == this.hideDuplicates) {
                return;
            }
            LOG.log(Level.FINE, "Hide duplicates changed: {0}", b);
        }
        if (this.timeline != null) {
            this.timeline.setHideDuplicates(b);
        } else {
            InputGraph currentGraph = this.getFirstGraph();
            if (b) {
                int start;
                int index;
                List graphs = this.graphContainer.getGraphs();
                for (index = start = graphs.indexOf(currentGraph); index >= 0 && ((InputGraph)graphs.get(index)).getProperties().get("_isDuplicate") != null; --index) {
                }
                if (index < 0) {
                    while (index < graphs.size() && ((InputGraph)graphs.get(index)).getProperties().get("_isDuplicate") != null) {
                        ++index;
                    }
                }
                if (index >= 0 && index < graphs.size()) {
                    currentGraph = (InputGraph)graphs.get(index);
                }
                LOG.log(Level.FINE, "Hide duplicates graph selection: {0}", currentGraph.getName());
            }
            this.selectGraph(currentGraph);
        }
        this.propSupport.firePropertyChange(PROP_HIDE_DUPLICATES, !b, b);
    }

    public DiagramViewModel(TimelineModel timeline, FilterSequence<FilterChain> filterChain, LayoutSettings.LayoutSettingBean layoutSettingBean) {
        this(timeline, null, filterChain, layoutSettingBean);
    }

    public DiagramViewModel(GraphContainer g, FilterSequence<FilterChain> filterChain, LayoutSettings.LayoutSettingBean layoutSettingBean) {
        this(null, g, filterChain, layoutSettingBean);
    }

    private DiagramViewModel(TimelineModel time, GraphContainer g, FilterSequence<FilterChain> filterChain, LayoutSettings.LayoutSettingBean layoutSettingBean) {
        assert (layoutSettingBean != null);
        if (time != null) {
            g = time.getPrimaryPartition();
        }
        this.timeline = time;
        this.filters = new Filters(filterChain);
        this.filters.getFiltersChangedEvent().addListener(this.filtersChanged);
        this.layoutSetting = layoutSettingBean;
        this.showNodeHull = true;
        this.graphContainer = g;
        this.hiddenNodes = new HashSet<Integer>();
        this.selectedNodes = new HashSet<InputNode>();
        this.graphPeerModel = time == null ? this.initGraphs() : time.getPrimaryRange();
        this.graphPeerModel.getChangedEvent().addListener((Object)this);
        this.diagramChangedEvent = new ChangedEvent((Object)this);
        this.graphPeerModel.addPropertyChangeListener(PROP_SELECTED_GRAPH, evt -> {
            if (this.hasScriptFilter()) {
                LOG.log(Level.FINE, "Graph changed, clearing Scripts.");
                this.filters.setScriptFilter(null, null, false);
                this.propSupport.firePropertyChange(PROP_SCRIPTS_CLEARED, null, null);
            }
        });
        this.graphPeerModel.addPropertyChangeListener("positions", evt -> this.propSupport.firePropertyChange("positions", evt.getOldValue(), evt.getNewValue()));
    }

    public void setLookup(Lookup l) {
        this.lookup = l;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public ChangedEvent<DiagramViewModel> getDiagramChangedEvent() {
        return this.diagramChangedEvent;
    }

    public Collection<InputNode> getSelectedNodes() {
        return Collections.unmodifiableSet(this.selectedNodes);
    }

    public Set<Integer> getHiddenNodes() {
        return Collections.unmodifiableSet(this.hiddenNodes);
    }

    public Set<InputNode> getHiddenGraphNodes() {
        if (this.hiddenCurrentGraphNodes != null) {
            return Collections.unmodifiableSet(this.hiddenCurrentGraphNodes);
        }
        InputGraph currentGraph = this.getGraphToView();
        this.hiddenCurrentGraphNodes = this.hiddenNodes.stream().map(id -> currentGraph.getNode(id.intValue())).collect(Collectors.toSet());
        return this.hiddenCurrentGraphNodes;
    }

    public void setSelectedNodes(Collection<InputNode> nodes) {
        if (this.selectedNodes.equals(nodes)) {
            return;
        }
        Set<InputNode> oldNodes = this.selectedNodes;
        this.selectedNodes = new HashSet<InputNode>(nodes);
        this.propSupport.firePropertyChange(PROP_SELECTED_NODES, oldNodes, this.getSelectedNodes());
        this.fireDiagramEvent(() -> new DiagramEvent((DiagramModel)this), DiagramListener::stateChanged);
    }

    public void showNot(Collection<Integer> nodes) {
        this.setHiddenNodes(nodes);
    }

    public void showFigures(Collection<Figure> f) {
        HashSet<Integer> newHiddenNodes = new HashSet<Integer>(this.getHiddenNodes());
        HashSet existingNodes = new HashSet(f.size());
        for (Figure fig : f) {
            fig.getSource().collectIds(existingNodes);
        }
        newHiddenNodes.removeAll(existingNodes);
        this.setHiddenNodes(newHiddenNodes);
    }

    public Collection<Figure> getSelectedFigures() {
        HashSet<Figure> result = new HashSet<Figure>();
        Diagram dg = this.getDiagramToView();
        for (Figure f : dg.getFigures()) {
            for (InputNode node : f.getSource().getSourceNodes()) {
                if (!this.selectedNodes.contains(node)) continue;
                result.add(f);
            }
        }
        return result;
    }

    public void showAll(Collection<Figure> f) {
        this.showFigures(f);
    }

    void showOnlyNodes(Collection<InputNode> nodes) {
        this.showOnly(nodes.stream().map(n -> n.getId()).collect(Collectors.toList()));
    }

    public void showOnly(Collection<Integer> nodes) {
        HashSet<Integer> allNodes = new HashSet<Integer>(this.getGraphToView().getGroup().getChildNodeIds());
        allNodes.removeAll(nodes);
        Diagram d = this.getDiagramToView();
        Collection nonRepresentedNodes = nodes.stream().filter(n -> !d.getFigure(n.intValue()).isPresent()).collect(Collectors.toList());
        InputGraph g = this.getGraphToView();
        for (Integer id : nonRepresentedNodes) {
            InputNode in2 = g.getNode(id.intValue());
            Collection provs = d.forSource(id.intValue());
            for (Source.Provider p : provs) {
                if (!(p instanceof Slot)) continue;
                Slot s = (Slot)p;
                InputNode an = s.getAssociatedNode();
                allNodes.remove(an.getId());
            }
        }
        Set aggregatedNodes = nodes.stream().filter(n -> !d.getFigure(n.intValue()).isPresent()).flatMap(in -> d.forSource(in.intValue()).stream().filter(f -> f instanceof Slot).flatMap(s -> ((Slot)s).getFigure().getSource().getSourceNodes().stream().map(n -> n.getId()))).collect(Collectors.toSet());
        allNodes.removeAll(aggregatedNodes);
        this.setHiddenNodes(allNodes);
    }

    public void setHiddenNodes(Collection<Integer> nodes) {
        if (this.hiddenNodes.equals(nodes)) {
            LOG.log(Level.FINER, "Hidden nodes unchanged size: {0}, skipping.", this.hiddenNodes.size());
            return;
        }
        LOG.log(Level.FINER, "Hidden nodes changed, size: {0}.", nodes.size());
        Set<Integer> oldNodes = this.hiddenNodes;
        this.setHiddenNodes0(nodes);
        this.propSupport.firePropertyChange(PROP_HIDDEN_NODES, oldNodes, nodes);
        this.diagramChanged();
    }

    private void setHiddenNodes0(Collection<Integer> nodes) {
        this.hiddenNodes = new HashSet<Integer>(nodes);
        this.hiddenCurrentGraphNodes = null;
        this.fireDiagramEvent(() -> new DiagramEvent((DiagramModel)this), DiagramListener::stateChanged);
    }

    private void diagramChanged() {
        this.diagramChanged(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void diagramChanged(boolean force) {
        boolean relevant;
        Object object = this.sync;
        synchronized (object) {
            boolean bl = relevant = force || !this.isStubDiagram(this.diagram) || this.diagram != null && this.diagram.getGraph() != this.inputGraph;
            if (relevant) {
                LOG.log(Level.FINE, "DiagramChanged old Diagram: {0}.", this.diagram);
                this.diagram = null;
            }
        }
        if (relevant) {
            this.fireDiagramChanged();
        }
    }

    private void fireDiagramChanged() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.diagramChangedEvent.fire();
            this.fireDiagramEvent(() -> new DiagramEvent((DiagramModel)this, null), DiagramListener::diagramChanged);
        } else {
            SwingUtilities.invokeLater(this::fireDiagramChanged);
        }
    }

    public FilterSequence getFilterSequence() {
        return this.filters.getFilterChain();
    }

    public List<Filter> getFilters() {
        return this.filters.getFiltersSnapshot();
    }

    public List<Filter> getScriptFilters() {
        return this.filters.getScriptFilters();
    }

    public ScriptEnvironment getScriptEnvironment() {
        return this.filters.getScriptEnvironment();
    }

    public FilterSequence getFilterChain() {
        return this.filters.getFilterChain();
    }

    public void setFilterChain(FilterSequence chain) {
        this.filters.setFilterChain(chain);
    }

    private RangeSliderModel initGraphs() {
        ArrayList<String> positions = new ArrayList<String>();
        this.graphContainer.getGraphs().forEach(graph -> positions.add(graph.getName()));
        if (positions.isEmpty()) {
            InputGraph ig = this.createEmptyGraph();
            positions.add(ig.getName());
        }
        return new RangeSliderAccess(positions);
    }

    private List<InputGraph> graphs() {
        if (this.getHideDuplicates()) {
            ArrayList<InputGraph> graphs = new ArrayList<InputGraph>(this.graphContainer.getGraphs());
            Iterator it = graphs.iterator();
            while (it.hasNext()) {
                if (!((InputGraph)it.next()).isDuplicate()) continue;
                it.remove();
            }
            return graphs;
        }
        return this.graphContainer.getGraphs();
    }

    public boolean isValid() {
        List lg = this.graphContainer.getGraphs();
        return lg.size() > 1 || lg.get(0) != this.emptyGraph;
    }

    public InputGraph getFirstGraph() {
        int fp = this.graphPeerModel.getFirstPosition();
        if (fp < this.graphs().size()) {
            return this.getGraphAtPos(fp);
        }
        return this.getGraphAtPos(this.graphs().size() - 1);
    }

    private synchronized InputGraph createEmptyGraph() {
        if (this.emptyGraph == null) {
            InputGraph ig = InputGraph.createTestGraph((String)"");
            ig.setParent((Folder)this.graphContainer.getContentOwner());
            this.emptyGraph = ig;
        }
        return this.emptyGraph;
    }

    private InputGraph getGraphAtPos(int i) {
        InputGraph g = null;
        if (this.timeline != null) {
            g = this.timeline.findGraph(this.graphPeerModel, i);
        } else if (i < this.graphs().size() && i >= 0) {
            g = this.graphs().get(i);
        }
        if (g != null) {
            return g;
        }
        return this.createEmptyGraph();
    }

    public InputGraph getSecondGraph() {
        if (this.graphPeerModel.getSecondPosition() < this.graphs().size()) {
            return this.getGraphAtPos(this.graphPeerModel.getSecondPosition());
        }
        return this.getFirstGraph();
    }

    public boolean selectGraph(InputGraph g) {
        int index = this.graphs().indexOf(g);
        if (index == -1 && this.getHideDuplicates()) {
            this.timeline.setHideDuplicates(false);
            this.timeline.whenStable().execute(() -> this.selectGraph(g));
            return false;
        }
        assert (index != -1);
        this.graphPeerModel.setPositions(index, index);
        return true;
    }

    public boolean isStubDiagram(Diagram dg) {
        return dg == null || dg.getFigures().isEmpty() && "".equals(dg.getNodeText());
    }

    public Future<Diagram> applyScriptFilter(Filter filterToApply, ScriptEnvironment env, boolean append, Consumer<Diagram> callback) {
        this.filters.setScriptFilter(filterToApply, env, append);
        return this.withDiagramToView(callback);
    }

    public Future<Diagram> withDiagramToView(Consumer<Diagram> task) {
        Diagram dg = this.getDiagramToView();
        return this.addCompletionTask(dg, task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<Diagram> addCompletionTask(Diagram dg, Consumer<Diagram> task) {
        Object object = this.sync;
        synchronized (object) {
            if (this.isStubDiagram(this.diagram)) {
                LOG.log(Level.FINE, "Diagram not ready scheduling completion task.");
                W r = new W(task, SwingUtilities.isEventDispatchThread());
                this.tasks.add(r);
                return r;
            }
        }
        LOG.log(Level.FINE, "Diagram ready, executing completion task.");
        if (task != null) {
            task.accept(dg);
        }
        return CompletableFuture.completedFuture(dg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTask(W r) {
        Object object = this.sync;
        synchronized (object) {
            this.tasks.remove(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Diagram getDiagramToView() {
        List<W> tsks;
        Object object = this.sync;
        synchronized (object) {
            if (this.diagram != null) {
                LOG.log(Level.FINE, "Saved stub=={1} Diagram: {0}.", new Object[]{this.diagram, this.isStubDiagram(this.diagram)});
                return this.diagram;
            }
        }
        Diagram dg = this.getCachedDiagram();
        if (dg == null) {
            Object object2 = this.sync;
            synchronized (object2) {
                if (this.diagram == null || this.diagram.getGraph() != this.inputGraph) {
                    final Diagram prev = this.previousDiagram.get();
                    if (prev != null) {
                        this.previousDiagram = new WeakReference<Diagram>(prev){
                            private final Diagram keep;
                            {
                                super(referent);
                                this.keep = prev;
                            }
                        };
                    }
                    this.diagram = Diagram.createEmptyDiagram((InputGraph)this.inputGraph);
                    LOG.log(Level.FINE, "Diagram isn't ready yet, returning stub: " + this.diagram);
                }
                dg = this.diagram;
            }
        }
        LOG.log(Level.FINE, "Cached Diagram: {0}.", dg);
        Object object3 = this.sync;
        synchronized (object3) {
            this.diagram = dg;
            tsks = this.tasks;
            this.tasks = new ArrayList<W>();
        }
        this.finalizeTasks(tsks, dg, false);
        assert (dg != null);
        return dg;
    }

    private Diagram getCachedDiagram() {
        return DiagramCache.getInstance().getDiagram(this, this::diagramFinished);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void diagramFinished(Diagram diagram) {
        assert (diagram != null);
        if (diagram.getGraph() == this.inputGraph) {
            List<W> tsks;
            boolean changed;
            assert (this.isStubDiagram(this.diagram));
            assert (!SwingUtilities.isEventDispatchThread());
            Object object = this.sync;
            synchronized (object) {
                boolean bl = changed = this.diagram != diagram;
                if (changed) {
                    LOG.log(Level.FINE, "Diagram updated from: {0} to: {1}.", new Object[]{this.diagram, diagram});
                    this.diagram = diagram;
                }
                tsks = this.tasks;
                this.tasks = new ArrayList<W>();
            }
            this.finalizeTasks(tsks, diagram, changed);
        }
    }

    private void finalizeTasks(List<W> tasks, Diagram finishedDiagram, boolean changed) {
        if (changed) {
            tasks.add(new W(d -> this.fireDiagramChanged(), true));
        }
        if (tasks.isEmpty()) {
            LOG.log(Level.FINE, "No Diagram tasks.");
            return;
        }
        LOG.log(Level.FINE, "Finalizing Diagram tasks.");
        boolean needSwing = false;
        for (W r : tasks) {
            if (r.edt) {
                needSwing = true;
                continue;
            }
            r.run(finishedDiagram);
        }
        if (needSwing) {
            SwingUtilities.invokeLater(() -> {
                boolean cancel;
                Iterator iterator = this.sync;
                synchronized (iterator) {
                    cancel = finishedDiagram != this.diagram;
                }
                for (W r : tasks) {
                    if (!r.edt) continue;
                    if (cancel) {
                        r.cancel(false);
                        continue;
                    }
                    r.run(finishedDiagram);
                }
                this.finishDiagramTasks(tasks, finishedDiagram);
            });
        } else {
            this.finishDiagramTasks(tasks, finishedDiagram);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishDiagramTasks(List<W> tasks, Diagram finishedDiagram) {
        Diagram previous;
        if (!SwingUtilities.isEventDispatchThread()) {
            LOG.log(Level.FINE, "Finished Diagram tasks.");
            SwingUtilities.invokeLater(() -> this.finishDiagramTasks(tasks, finishedDiagram));
            return;
        }
        for (W t : tasks) {
            t.complete(finishedDiagram);
        }
        DiagramViewModel diagramViewModel = this;
        synchronized (diagramViewModel) {
            previous = this.previousDiagram.get();
            if (this.diagram == finishedDiagram) {
                this.previousDiagram = new WeakReference<Object>(null);
            }
        }
        this.fireDiagramEvent(() -> new DiagramEvent((DiagramModel)this, previous), DiagramListener::diagramReady);
        LOG.log(Level.FINE, "Completed Diagram tasks.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputGraph makeDifference(InputGraph first, InputGraph second) {
        InputGraph g;
        Reference<InputGraph> r;
        Pair key = Pair.of((Object)first, (Object)second);
        Map<Pair<InputGraph, InputGraph>, Reference<InputGraph>> map = this.diffCache;
        synchronized (map) {
            r = this.diffCache.get(key);
            if (r != null && (g = r.get()) != null) {
                return g;
            }
        }
        g = Difference.createDiffGraph((InputGraph)first, (InputGraph)second);
        map = this.diffCache;
        synchronized (map) {
            InputGraph g2;
            r = this.diffCache.get(key);
            if (r != null && (g2 = r.get()) != null) {
                return g2;
            }
            this.diffCache.put((Pair<InputGraph, InputGraph>)key, new DiffGraphRef((Pair<InputGraph, InputGraph>)key, g));
        }
        return g;
    }

    public InputGraph getGraphToView() {
        if (this.inputGraph == null) {
            this.inputGraph = this.getFirstGraph();
            InputGraph scnd = this.getSecondGraph();
            if (this.inputGraph != scnd) {
                this.inputGraph = this.makeDifference(this.inputGraph, scnd);
            }
            LOG.log(Level.FINE, "New graph to view: {0}", this.inputGraph.getName());
        }
        return this.inputGraph;
    }

    public void changed(RangeSliderModel source) {
        InputGraph oldGraph = this.inputGraph;
        this.inputGraph = null;
        InputGraph curGraph = this.getGraphToView();
        if (curGraph == oldGraph) {
            this.getChangedEvent().fire();
            return;
        }
        this.hiddenCurrentGraphNodes = null;
        this.propSupport.firePropertyChange(PROP_SELECTED_GRAPH, oldGraph, curGraph);
        this.diagramChanged();
        this.getChangedEvent().fire();
    }

    public void setSelectedFigures(Collection<Figure> list) {
        HashSet<InputNode> newSelectedNodes = new HashSet<InputNode>();
        for (Figure f : list) {
            newSelectedNodes.addAll(f.getSource().getSourceNodes());
        }
        this.setSelectedNodes(newSelectedNodes);
    }

    void close() {
        this.filters.close();
    }

    Iterable<InputGraph> getGraphsForward() {
        return () -> new Iterator<InputGraph>(){
            int index;
            {
                this.index = DiagramViewModel.this.graphPeerModel.getFirstPosition();
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < DiagramViewModel.this.graphs().size();
            }

            @Override
            public InputGraph next() {
                return DiagramViewModel.this.graphs().get(++this.index);
            }
        };
    }

    Iterable<InputGraph> getGraphsBackward() {
        return () -> new Iterator<InputGraph>(){
            int index;
            {
                this.index = DiagramViewModel.this.graphPeerModel.getFirstPosition();
            }

            @Override
            public boolean hasNext() {
                return this.index > 0;
            }

            @Override
            public InputGraph next() {
                return DiagramViewModel.this.graphs().get(--this.index);
            }
        };
    }

    public boolean hasScriptFilter() {
        return !this.getScriptFilters().isEmpty();
    }

    public List<String> getPositions() {
        return this.graphPeerModel.getPositions();
    }

    public TimelineModel getTimeline() {
        return this.timeline;
    }

    static class RangeSliderAccess
    extends RangeSliderModel {
        public RangeSliderAccess(List<String> positions) {
            super(positions);
        }

        public RangeSliderAccess(RangeSliderModel model) {
            super(model);
        }

        public void setPositions(List<String> positions) {
            super.setPositions(positions);
        }

        protected boolean getPositionsDiffers0(RangeSliderModel model) {
            return super.getPositionsDiffers(model);
        }

        protected boolean getColorsDiffers0(RangeSliderModel model) {
            return super.getColorsDiffers(model);
        }
    }

    class W
    extends CompletableFuture {
        final boolean edt;
        final Consumer<Diagram> callback;

        void cancelled() {
            super.cancel(true);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            DiagramViewModel.this.removeTask(this);
            boolean r = super.cancel(mayInterruptIfRunning);
            return r;
        }

        public W(Consumer<Diagram> callback, boolean edt) {
            this.callback = callback;
            this.edt = edt;
        }

        public void run(Diagram dg) {
            if (this.callback != null) {
                this.callback.accept(dg);
            }
        }
    }

    class DiffGraphRef
    extends WeakReference<InputGraph>
    implements Runnable {
        private final Pair<InputGraph, InputGraph> key;

        public DiffGraphRef(Pair<InputGraph, InputGraph> key, InputGraph referent) {
            super(referent, Utilities.activeReferenceQueue());
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map<Pair<InputGraph, InputGraph>, Reference<InputGraph>> map = DiagramViewModel.this.diffCache;
            synchronized (map) {
                DiagramViewModel.this.diffCache.remove(this.key);
            }
        }
    }
}

