/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.view;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.graalvm.visualizer.data.Pair;
import org.graalvm.visualizer.graph.Diagram;
import org.graalvm.visualizer.view.DiagramScene;
import org.graalvm.visualizer.view.DiagramViewModel;
import org.graalvm.visualizer.view.SceneUpdaterTask;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

class SceneUpdater {
    private static final Logger LOG = Logger.getLogger(SceneUpdater.class.getName());
    private static final int VIEWPORT_UPDATE_DELAY = 50;
    private static final int VIEWPORT_CLEAN_DELAY = 500;
    private final RequestProcessor processor;
    private final DiagramScene scene;
    private final List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();
    private Rectangle updatedRectangle = new Rectangle(0, 0, 0, 0);
    private SceneUpdaterTask.DisplayWidgets viewportUpdate;
    private SceneUpdaterTask.Cleaner viewportCleanup;
    private final DiagramViewModel model;
    private Diagram lastDiagram;
    private List<Runnable> doWhenLayoutCompletes = new ArrayList<Runnable>();
    private Area validatedShape = new Area(new Rectangle(0, 0, 0, 0));
    private Set<Pair<Point, Point>> lineCache = new HashSet<Pair<Point, Point>>();
    private SceneUpdaterTask displayBlocker;
    private final PropertyChangeListener topRegistryListener;

    public SceneUpdater(DiagramScene scene) {
        this.scene = scene;
        this.model = scene.getModel();
        this.lastDiagram = this.model.getDiagramToView();
        scene.getScrollPane().getViewport().addChangeListener(e -> this.refreshView(false));
        this.model.getDiagramChangedEvent().addListener(e -> SwingUtilities.invokeLater(this::forceViewRefresh));
        String sceneName = this.model.getContainer().getName();
        this.processor = new RequestProcessor("SceneUpdater - " + sceneName);
        this.topRegistryListener = e -> {
            if (!"tcClosed".equals(e.getPropertyName())) {
                return;
            }
            if (e.getNewValue() == scene.getTopComponent()) {
                this.cancelAll();
            }
        };
        TopComponent.getRegistry().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.topRegistryListener, (Object)TopComponent.getRegistry()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener l) {
        SceneUpdater sceneUpdater = this;
        synchronized (sceneUpdater) {
            this.changeListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener l) {
        SceneUpdater sceneUpdater = this;
        synchronized (sceneUpdater) {
            this.changeListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChangeListeners() {
        ChangeListener[] ll;
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(this::fireChangeListeners);
            return;
        }
        SceneUpdater sceneUpdater = this;
        synchronized (sceneUpdater) {
            if (this.changeListeners.isEmpty()) {
                return;
            }
            ll = this.changeListeners.toArray(new ChangeListener[this.changeListeners.size()]);
        }
        ChangeEvent ev = new ChangeEvent(this);
        for (ChangeListener l : ll) {
            l.stateChanged(ev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean whenDiagramShown(Runnable r) {
        SceneUpdater sceneUpdater = this;
        synchronized (sceneUpdater) {
            if (this.isStubDiagram() || this.displayBlocker != null || this.lastDiagram != this.model.getDiagramToView()) {
                LOG.log(Level.FINE, "Diagram is stub or layout is blocked, sheduling for later execution.");
                this.doWhenLayoutCompletes.add(r);
                return true;
            }
        }
        LOG.log(Level.FINE, "Diagram is shown, executing immediately.");
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
        return false;
    }

    private boolean isStubDiagram() {
        return this.model.isStubDiagram(this.lastDiagram);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll() {
        LOG.log(Level.FINE, "Scene component closed, cancelling tasks");
        SceneUpdater sceneUpdater = this;
        synchronized (sceneUpdater) {
            this.cancelUpdateTask(this.viewportUpdate);
            this.cancelUpdateTask(this.viewportCleanup);
            this.viewportUpdate = null;
            this.viewportCleanup = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceViewRefresh() {
        Diagram d = this.model.getDiagramToView();
        SceneUpdater sceneUpdater = this;
        synchronized (sceneUpdater) {
            if (this.lastDiagram == d) {
                LOG.log(Level.FINE, "Don't react on same Diagram.");
                return;
            }
            boolean wasStub = this.isStubDiagram();
            this.lastDiagram = d;
            if (this.isStubDiagram()) {
                LOG.log(Level.FINE, "Diagram is stub, preparing scene.");
                this.updatedRectangle = new Rectangle(0, 0, 0, 0);
                this.validatedShape = new Area(new Rectangle(0, 0, 0, 0));
                this.scene.prepareUpdate();
                this.fireChangeListeners();
                return;
            }
            if (!wasStub) {
                LOG.log(Level.FINE, "Diagram isn't stub, preparing scene.");
                this.updatedRectangle = new Rectangle(0, 0, 0, 0);
                this.validatedShape = new Area(new Rectangle(0, 0, 0, 0));
                this.scene.prepareUpdate();
                this.fireChangeListeners();
            }
            LOG.log(Level.FINE, this.makeDiagramLog());
            if (this.viewportUpdate != null) {
                this.cancelUpdateTask(this.viewportUpdate);
                this.viewportUpdate = null;
            }
        }
        this.refreshView(true);
    }

    private String makeDiagramLog() {
        String sb = "New Diagram for scene update:\nDiagram: " + this.lastDiagram + ".\n\tGraph name: " + this.lastDiagram.getGraph().getName() + ".\n\tnodes count: " + this.lastDiagram.getGraph().getNodeCount() + ".\n\tfigures count: " + this.lastDiagram.getFigures().size() + ".\n\tvisible figures count: " + this.lastDiagram.getFigures().stream().filter(n -> n.isVisible()).count() + ".\n\tboundary figures count: " + this.lastDiagram.getFigures().stream().filter(n -> n.isBoundary()).count() + ".";
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLayoutTasks(SceneUpdaterTask blocker) {
        List<Runnable> completionTasks;
        SceneUpdater sceneUpdater = this;
        synchronized (sceneUpdater) {
            assert (!this.isStubDiagram());
            if (this.displayBlocker != null && this.displayBlocker != blocker) {
                return;
            }
            completionTasks = this.doWhenLayoutCompletes;
            this.doWhenLayoutCompletes = new ArrayList<Runnable>();
            this.displayBlocker = null;
        }
        Runnable r = () -> {
            LOG.log(Level.FINE, "Running after-display tasks.");
            this.scene.finishUpdate();
            for (Runnable x : completionTasks) {
                x.run();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            LOG.log(Level.FINE, "Scheduling post-display tasks to AWT");
            SwingUtilities.invokeLater(r);
        }
    }

    private void cancelUpdateTask(SceneUpdaterTask t) {
        if (t == null) {
            return;
        }
        t.cancel();
        if (this.displayBlocker == t) {
            this.displayBlocker = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean refreshView(boolean blockDisplay) {
        assert (SwingUtilities.isEventDispatchThread());
        if (!this.scene.getTopComponent().isOpened() || this.isStubDiagram() || this.lastDiagram != this.model.getDiagramToView()) {
            LOG.log(Level.FINE, "Nothing to do with unopened TopComponent, stub or old Diagram.");
            return false;
        }
        Rectangle viewRect = this.scene.getVisibleSceneRect();
        SceneUpdater sceneUpdater = this;
        synchronized (sceneUpdater) {
            LOG.log(Level.FINE, "Potential viewport update for extent: {0} ", viewRect);
            if (this.updatedRectangle.contains(viewRect)) {
                Dimension d = this.updatedRectangle.getSize();
                Dimension d2 = viewRect.getSize();
                if (d.width > 5 * d2.width || d.height > 5 * d2.height) {
                    LOG.log(Level.FINE, "The updated area {0} is extremely large, cleaning excess widgets and keeping for {1}", new Object[]{this.updatedRectangle, viewRect});
                    SwingUtilities.invokeLater(() -> this.cleanViewport());
                }
                return true;
            }
            if (this.viewportUpdate != null) {
                if (this.viewportUpdate.getPhase() != SceneUpdaterTask.Phase.OBSOLETE && this.viewportUpdate.getExtendedBounds().contains(viewRect)) {
                    LOG.log(Level.FINE, "Viewport update is alredy scheduled for {0}, view bounds {1} still inside.", new Object[]{this.viewportUpdate.getExtendedBounds(), viewRect});
                    return true;
                }
                LOG.log(Level.FINE, "Old viewport update cancelled");
                this.cancelUpdateTask(this.viewportUpdate);
                this.viewportUpdate = null;
            }
            if (this.viewportCleanup != null) {
                LOG.log(Level.FINE, "Old viewport cleanup cancelled");
                this.cancelUpdateTask(this.viewportCleanup);
                this.viewportCleanup = null;
            }
            SceneUpdaterTask.DisplayWidgets upd = new SceneUpdaterTask.DisplayWidgets(this.scene, this.model.getLayoutSetting(), this.processor, this.lineCache);
            if (blockDisplay) {
                this.displayBlocker = upd;
            }
            LOG.log(Level.FINE, "New viewport update task {2}, for rectangle {0}, current view rect {1}", new Object[]{upd.getExtendedBounds(), viewRect, upd});
            this.viewportUpdate = upd;
            this.viewportUpdate.schedule(50).onCompletion(e -> {
                SceneUpdater sceneUpdater = this;
                synchronized (sceneUpdater) {
                    if (upd != this.viewportUpdate) {
                        return;
                    }
                    if (!this.isStubDiagram()) {
                        this.updatedRectangle = upd.getExtendedBounds();
                        this.validatedShape.add(new Area(this.updatedRectangle));
                        this.fireChangeListeners();
                    }
                    this.viewportUpdate = null;
                    this.lineCache = upd.getLineCache();
                }
                this.processLayoutTasks(upd);
                SwingUtilities.invokeLater(() -> {
                    this.scene.fireSceneUpdated(true);
                    this.cleanViewport();
                });
            });
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanViewport() {
        SceneUpdater sceneUpdater = this;
        synchronized (sceneUpdater) {
            if (this.viewportCleanup != null) {
                return;
            }
            LOG.log(Level.FINE, "Scheduling viewport cleanup task");
            SceneUpdaterTask.Cleaner cl = new SceneUpdaterTask.Cleaner(this.scene, this.processor, this::limitUpdatedRectangle);
            cl.schedule(500).onCompletion(e -> {
                SceneUpdater sceneUpdater = this;
                synchronized (sceneUpdater) {
                    if (this.viewportCleanup != cl) {
                        return;
                    }
                    this.viewportCleanup = null;
                }
            });
            this.viewportCleanup = cl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void limitUpdatedRectangle(Rectangle r) {
        Rectangle ints;
        Rectangle viewRect = this.scene.getVisibleSceneRect();
        SceneUpdater sceneUpdater = this;
        synchronized (sceneUpdater) {
            if (!this.updatedRectangle.contains(viewRect)) {
                return;
            }
            this.updatedRectangle = ints = this.updatedRectangle.intersection(r);
        }
        if (!ints.contains(viewRect)) {
            this.refreshView(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Area getValidatedShape() {
        SceneUpdater sceneUpdater = this;
        synchronized (sceneUpdater) {
            return new Area(this.validatedShape);
        }
    }

    public Rectangle getValidatedRectangle() {
        return this.updatedRectangle;
    }
}

