/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.view;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import jdk.graal.compiler.graphio.parsing.model.InputBlock;
import org.graalvm.visualizer.data.Pair;
import org.graalvm.visualizer.graph.Block;
import org.graalvm.visualizer.graph.Connection;
import org.graalvm.visualizer.graph.Diagram;
import org.graalvm.visualizer.graph.DiagramItem;
import org.graalvm.visualizer.graph.Figure;
import org.graalvm.visualizer.graph.OutputSlot;
import org.graalvm.visualizer.graph.Slot;
import org.graalvm.visualizer.settings.layout.LayoutSettings;
import org.graalvm.visualizer.view.DiagramScene;
import org.graalvm.visualizer.view.DiagramViewModel;
import org.graalvm.visualizer.view.widgets.BlockWidget;
import org.graalvm.visualizer.view.widgets.FigureWidget;
import org.graalvm.visualizer.view.widgets.LineWidget;
import org.netbeans.api.visual.animator.SceneAnimator;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Widget;
import org.openide.util.RequestProcessor;

abstract class SceneUpdaterTask
implements Runnable {
    private static final Logger LOG = Logger.getLogger(SceneUpdaterTask.class.getName());
    private static final float VIEWPORT_EXTENSION_FACTOR_X = 1.0f;
    private static final float VIEWPORT_EXTENSION_FACTOR_Y = 2.0f;
    private static final int UI_PROCESSING_LIMIT = 150;
    private static final int UI_PROCESSING_CHUNK = 150;
    private static final int UI_MINIMUM_VISIBLE_CHUNK = 2000;
    private static final int UI_THREAD_INTERLEAVE = 200;
    protected final RequestProcessor processor;
    protected Consumer<SceneUpdaterTask> completionListener;
    private final Set<Integer> oldMaterializedFigures = new HashSet<Integer>();
    private final Set<InputBlock> oldMaterializedBlocks = new HashSet<InputBlock>();
    private Collection<Widget> oldVisibleWidgets;
    protected final Diagram diagram;
    protected final DiagramScene scene;
    private int maxX = -20;
    private int maxY = -20;
    private Phase phase = Phase.PREPARE;
    private final DiagramViewModel model;
    protected Rectangle extendedViewportBounds;
    protected Rectangle viewportBounds;
    private final Set<Integer> reachableFigureIDs = new HashSet<Integer>();
    private int visibleFigureCount;
    private final AtomicBoolean cancelled = new AtomicBoolean();
    protected RequestProcessor.Task scheduled;
    private SceneAnimator sceneAnimator;
    protected final Set<Pair<Point, Point>> lastLineCache;
    protected final Set<Pair<Point, Point>> lineCache = new HashSet<Pair<Point, Point>>();
    protected Phase nextPhase = Phase.PREPARE;
    private int figIndex;
    private int blockIndex;
    protected List<Figure> updateFigures;
    protected List<Block> updateBlocks;
    private boolean firstMove = true;

    protected SceneUpdaterTask(DiagramScene scene, LayoutSettings.LayoutSettingBean settings, RequestProcessor processor, Phase initialPhase, Set<Pair<Point, Point>> lastLineCache) {
        this(scene, settings, false, processor, lastLineCache);
        this.phase = initialPhase;
    }

    SceneUpdaterTask(DiagramScene scene, LayoutSettings.LayoutSettingBean settings, boolean relayout, RequestProcessor processor, Set<Pair<Point, Point>> lastLineCache) {
        this.processor = processor;
        this.scene = scene;
        this.model = scene.getModel();
        this.diagram = this.model.getDiagramToView();
        this.lastLineCache = lastLineCache;
        this.setupViewportBounds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupViewportBounds() {
        assert (SwingUtilities.isEventDispatchThread());
        JViewport viewport = this.scene.getScrollPane().getViewport();
        Rectangle tmp = this.scene.convertViewToScene(viewport.getViewRect());
        Dimension viewSize = tmp.getSize();
        Rectangle enlarged = new Rectangle(Math.max(-20, tmp.x - (int)(1.0f * (float)viewSize.width)), Math.max(-20, tmp.y - (int)(2.0f * (float)viewSize.height)), tmp.width + 2 * (int)(1.0f * (float)viewSize.width), tmp.height + 2 * (int)(2.0f * (float)viewSize.height));
        enlarged.add(this.scene.getVisibleSceneRect());
        SceneUpdaterTask sceneUpdaterTask = this;
        synchronized (sceneUpdaterTask) {
            this.viewportBounds = tmp;
            this.extendedViewportBounds = enlarged;
        }
        LOG.log(Level.FINE, "Setting up viewport viewport:{2}, bounds:{0}, extended:{1}", new Object[]{this.viewportBounds, this.extendedViewportBounds, viewport.getViewRect()});
    }

    public Phase getPhase() {
        return this.phase;
    }

    protected abstract void processPhase(Phase var1);

    @Override
    public void run() {
        do {
            LOG.log(Level.FINE, "Executing task {0}, phase {1}", new Object[]{this, this.phase});
            if (this.cancelled.get()) {
                this.phase = Phase.OBSOLETE;
            }
            if (this.phase == Phase.OBSOLETE) {
                LOG.log(Level.FINE, "Final terminate task {0}, phase {1}", new Object[]{this, this.phase});
                return;
            }
            this.nextPhase = this.phase.ordinal() <= Phase.COMPLETE.ordinal() ? Phase.values()[this.phase.ordinal() + 1] : Phase.OBSOLETE;
            if (this.phase.runsInAWT() && !SwingUtilities.isEventDispatchThread()) {
                LOG.log(Level.FINE, "Phase shall run in AWT, but does not; rescheduling to AWT");
                SwingUtilities.invokeLater(this);
                return;
            }
            try {
                this.processPhase(this.phase);
            }
            catch (CancelException ex) {
                this.nextPhase = Phase.OBSOLETE;
            }
            if (this.phase == Phase.COMPLETE) {
                if (this.completionListener != null) {
                    this.completionListener.accept(this);
                }
                this.nextPhase = Phase.OBSOLETE;
            }
            if (SwingUtilities.isEventDispatchThread()) {
                this.scene.validate();
            }
            LOG.log(Level.FINE, "Rescheduling task {0}, old phase {2}, next phase {1}", new Object[]{this, this.nextPhase, this.phase});
        } while (this.schedule());
        LOG.log(Level.FINE, "Pausing task {0}, next phase {1}", new Object[]{this, this.phase});
    }

    protected final void complete() {
        this.nextPhase = Phase.COMPLETE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean schedule() {
        SceneUpdaterTask sceneUpdaterTask;
        boolean samePhase = this.nextPhase == null;
        Phase oldPhase = this.phase;
        if (!samePhase) {
            this.phase = this.nextPhase;
        }
        if (oldPhase.ordinal() >= Phase.COMPLETE.ordinal()) {
            return false;
        }
        if (this.phase != Phase.PREPARE) {
            sceneUpdaterTask = this;
            synchronized (sceneUpdaterTask) {
                if (samePhase) {
                    this.scheduled = this.processor.post(() -> SwingUtilities.invokeLater(this), 200);
                    return false;
                }
            }
            if (this.phase.runsInAWT() == oldPhase.runsInAWT()) {
                return true;
            }
        }
        switch (this.phase) {
            case PREPARE: {
                SwingUtilities.invokeLater(this);
                break;
            }
            case VIEWPORT: 
            case UPDATE_A: 
            case UPDATE_B: {
                SwingUtilities.invokeLater(this);
                return false;
            }
            case FIND_WIDGETS: 
            case COMPUTE: {
                sceneUpdaterTask = this;
                synchronized (sceneUpdaterTask) {
                    this.scheduled = this.processor.post((Runnable)this);
                }
                return false;
            }
            case COMPLETE: {
                this.processor.post((Runnable)this);
                break;
            }
        }
        return false;
    }

    protected boolean isConnectionReachable(Connection c) {
        Figure sf = c.getOutputSlot().getFigure();
        Figure tf = c.getInputSlot().getFigure();
        if (this.isReachable((DiagramItem)sf) || this.isReachable((DiagramItem)tf)) {
            return true;
        }
        for (Point pt : c.getControlPoints()) {
            if (pt == null || !this.extendedViewportBounds.contains(pt)) continue;
            return true;
        }
        return false;
    }

    protected void findWidgetsToUpdate(boolean updateAllMaterialized) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Find widgets to update, materialized:{0}, viewport:{1}, extendedViewportBounds:{2}", new Object[]{updateAllMaterialized, this.viewportBounds, this.extendedViewportBounds});
        }
        HashSet<Connection> inspectedConnections = new HashSet<Connection>();
        this.updateFigures = new ArrayList<Figure>(this.diagram.getFigures().size());
        for (Figure f : this.diagram.getFigures()) {
            boolean reachable = this.isReachable((DiagramItem)f);
            if (!reachable) continue;
            for (OutputSlot os : f.getOutputSlots()) {
                for (Connection c : os.getConnections()) {
                    if (!inspectedConnections.add(c) || !this.isConnectionReachable(c)) continue;
                    this.reachableFigureIDs.add(c.getInputSlot().getFigure().getId());
                }
            }
            for (Slot is : f.getInputSlots()) {
                for (Connection c : is.getConnections()) {
                    if (!inspectedConnections.add(c) || !this.isConnectionReachable(c)) continue;
                    this.reachableFigureIDs.add(c.getOutputSlot().getFigure().getId());
                }
            }
            this.reachableFigureIDs.add(f.getId());
            if (!this.isVisible(f)) continue;
            ++this.visibleFigureCount;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Find widgets: reachable figures:{0}, visibleFigures:{1}", new Object[]{this.reachableFigureIDs.size(), this.visibleFigureCount});
        }
        if (this.model.getShowBlocks()) {
            Collection blocks = this.diagram.getBlocks();
            ArrayList<Block> bls = new ArrayList<Block>(blocks);
            for (Block b : blocks) {
                if (!this.isReachable((DiagramItem)b) && !this.oldMaterializedBlocks.contains(b.getInputBlock())) continue;
                bls.add(b);
            }
            this.updateBlocks = bls;
        } else {
            this.updateBlocks = Collections.emptyList();
        }
        if (updateAllMaterialized) {
            this.reachableFigureIDs.addAll(this.oldMaterializedFigures);
        }
        Iterator<Object> iterator = this.reachableFigureIDs.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            Figure f = this.diagram.getFigureById(i);
            if (f == null) continue;
            this.updateFigures.add(f);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Added {0} already materialized, total to update:{1}", new Object[]{updateAllMaterialized ? this.oldMaterializedFigures.size() : -1, this.updateFigures.size()});
        }
    }

    protected boolean updateVisibleWidgetsIncrementally() {
        TimedIterable<Figure> figs = null;
        int widgetCount = 0;
        if (this.figIndex < this.updateFigures.size()) {
            figs = new TimedIterable<Figure>(this.updateFigures.subList(this.figIndex, this.updateFigures.size()), 2000);
            for (Figure f : figs) {
                FigureWidget w = this.scene.createFigureWidget(f);
                if (w == null) continue;
                w.setVisible(f.isVisible());
                ++widgetCount;
            }
            this.figIndex += figs.getStopIndex();
        }
        if (this.blockIndex < this.updateBlocks.size()) {
            TimedIterable<Block> blocks = new TimedIterable<Block>(this.updateBlocks.subList(this.blockIndex, this.updateBlocks.size()), 2000, figs);
            for (Block f : blocks) {
                BlockWidget w = this.scene.createBlockWidget(f.getInputBlock());
                w.setVisible(f.isVisible());
            }
            this.blockIndex += blocks.getStopIndex();
        }
        LOG.log(Level.FINE, "Updated {0} widgets", widgetCount);
        this.scene.validate();
        return this.figIndex < this.updateFigures.size() || this.blockIndex < this.updateBlocks.size();
    }

    protected void findDimensions() {
        assert (!SwingUtilities.isEventDispatchThread());
        Dimension size = this.diagram.getSize();
        if (size == null) {
            throw new IllegalStateException("Diagram size has to be set after layouting phase and before display phase.");
        }
        this.maxX = size.width;
        this.maxY = size.height;
        this.extendedViewportBounds = new Rectangle(this.extendedViewportBounds.x, this.extendedViewportBounds.y, Math.min(this.extendedViewportBounds.width, this.maxX), Math.min(this.extendedViewportBounds.height, this.maxY));
        LOG.log(Level.FINE, "findDimensions: New dimensions of scene: {0}:{1}", new Object[]{this.maxX, this.maxY});
    }

    protected boolean moveFiguresIncrementally() {
        if (this.firstMove) {
            this.blockIndex = 0;
            this.figIndex = 0;
            this.firstMove = false;
        }
        LOG.log(Level.FINE, "Moving figures from {0}, top = {1}, viewport = {2}", new Object[]{this.figIndex, this.updateFigures.size(), this.viewportBounds});
        TimedIterable<Figure> figs = new TimedIterable<Figure>(this.updateFigures.subList(this.figIndex, this.updateFigures.size()), 200);
        TimedIterable<Block> blocks = new TimedIterable<Block>(this.updateBlocks.subList(this.blockIndex, this.updateBlocks.size()), 200, figs);
        this.moveFigures(figs, blocks);
        this.figIndex += figs.getStopIndex();
        this.blockIndex += blocks.getStopIndex();
        LOG.log(Level.FINE, "Figure move stopped, new start = {0}, top = {1}", new Object[]{this.figIndex, this.updateFigures.size()});
        boolean cont = this.figIndex < this.updateFigures.size() || this.model.getShowBlocks() && this.blockIndex < this.updateBlocks.size();
        LOG.log(Level.FINE, "Move will continue: {0}", cont);
        return cont;
    }

    private boolean isReachable(DiagramItem f) {
        if (!f.isVisible()) {
            return false;
        }
        Rectangle b = f.getBounds();
        if (b == null) {
            return false;
        }
        return this.extendedViewportBounds.intersects(b);
    }

    private boolean isVisible(Figure f) {
        if (!f.isVisible()) {
            return false;
        }
        Rectangle b = f.getBounds();
        if (b.x == 0 && b.y == 0) {
            return true;
        }
        return this.viewportBounds.intersects(b);
    }

    SceneUpdaterTask execute() {
        this.schedule();
        return this;
    }

    private void processOutputSlot(OutputSlot s) {
        List<Connection> connections = s.getConnections().stream().filter(c -> c.getInputSlot().getFigure().isVisible() && c.getControlPoints().size() > 1).collect(Collectors.toList());
        if (connections.isEmpty()) {
            return;
        }
        List points = ((Connection)connections.get(0)).getControlPoints();
        ArrayDeque<LineEntry> entries = new ArrayDeque<LineEntry>();
        entries.addAll(this.prepareLineEntries(connections, 1, (Point)points.get(0), null));
        while (!entries.isEmpty()) {
            entries.addAll(this.processLineEntry(s, (LineEntry)entries.remove()));
        }
    }

    private List<LineEntry> prepareLineEntries(List<Connection> connections, int nextPointIndex, Point lastPoint, LineWidget predecessor) {
        HashMap<Point, List> nexts = new HashMap<Point, List>();
        for (Connection connection : connections) {
            List controlPoints = connection.getControlPoints();
            if (controlPoints.size() <= nextPointIndex) continue;
            nexts.computeIfAbsent((Point)controlPoints.get(nextPointIndex), p -> new ArrayList()).add(connection);
        }
        ArrayList<LineEntry> entries = new ArrayList<LineEntry>();
        nexts.values().forEach(c -> {
            if (c.size() == 1) {
                this.finishSingleConnection((List<Connection>)c, predecessor, lastPoint, nextPointIndex);
            } else {
                entries.add(new LineEntry((List<Connection>)c, nextPointIndex, lastPoint, predecessor));
            }
        });
        return entries;
    }

    private List<LineEntry> processLineEntry(OutputSlot s, LineEntry task) {
        return this.processLineEntry(s, task.conns, task.pred, task.last, task.index);
    }

    private List<LineEntry> processLineEntry(OutputSlot s, List<Connection> connections, LineWidget predecessor, Point lastPoint, int controlPointIndex) {
        Point nextPoint = (Point)connections.get(0).getControlPoints().get(controlPointIndex);
        if (lastPoint == null || nextPoint == null) {
            return this.prepareLineEntries(connections, controlPointIndex + 1, nextPoint, predecessor);
        }
        boolean isBold = false;
        boolean isDashed = true;
        for (Connection c : connections) {
            if (!isBold && c.getStyle() == Connection.ConnectionStyle.BOLD) {
                isBold = true;
            }
            if (!isDashed || c.getStyle() == Connection.ConnectionStyle.DASHED) continue;
            isDashed = false;
        }
        LineWidget newPredecessor = this.processLineWidget(s, lastPoint, nextPoint, connections, predecessor, isBold, isDashed);
        return this.prepareLineEntries(connections, controlPointIndex + 1, nextPoint, newPredecessor);
    }

    private void finishSingleConnection(List<Connection> connections, LineWidget predecessor, Point lastPoint, int controlPointIndex) {
        boolean isDashed;
        Connection connection = connections.get(0);
        OutputSlot outputSlot = connection.getOutputSlot();
        List points = connection.getControlPoints();
        boolean isBold = connection.getStyle() == Connection.ConnectionStyle.BOLD;
        boolean bl = isDashed = connection.getStyle() == Connection.ConnectionStyle.DASHED;
        while (points.size() > controlPointIndex) {
            Point nextPoint = (Point)points.get(controlPointIndex);
            if (lastPoint != null && nextPoint != null) {
                predecessor = this.processLineWidget(outputSlot, lastPoint, nextPoint, connections, predecessor, isBold, isDashed);
            }
            ++controlPointIndex;
            lastPoint = nextPoint;
        }
    }

    private LineWidget processLineWidget(OutputSlot s, Point lastPoint, Point nextPoint, List<Connection> connections, LineWidget predecessor, boolean isBold, boolean isDashed) {
        Point p1 = lastPoint.getLocation();
        Point p2 = nextPoint.getLocation();
        Pair curPair = new Pair((Object)p1, (Object)p2);
        SceneAnimator curAnimator = this.sceneAnimator;
        if (this.lastLineCache.contains(curPair)) {
            curAnimator = null;
        } else {
            this.lineCache.add((Pair<Point, Point>)curPair);
        }
        ConnectionSet key = new ConnectionSet(connections, lastPoint.x, lastPoint.y, nextPoint.x, nextPoint.y);
        LineWidget w = (LineWidget)((Object)this.scene.getWidget(key));
        if (w == null) {
            w = new LineWidget(this.scene, s, connections, p1, p2, predecessor, curAnimator, isBold, isDashed);
            w.getActions().addAction(this.scene.getHoverAction());
            this.scene.addObject(key, new Widget[]{w});
        } else {
            w.setPredecessor(predecessor);
            w.setPoints(p1, p2);
        }
        if (w.getParentWidget() == null) {
            this.scene.addConnection(w);
        }
        return w;
    }

    public Set<Pair<Point, Point>> getLineCache() {
        return this.lineCache;
    }

    protected void findOldWidgets() {
        this.oldVisibleWidgets = new HashSet<Widget>();
        for (Object o : this.scene.getObjects()) {
            if (!(o instanceof DiagramItem)) continue;
            DiagramItem di = (DiagramItem)o;
            List ow = this.scene.findWidgets(o);
            if (ow == null || !di.isVisible()) continue;
            if (di instanceof Figure) {
                this.oldMaterializedFigures.add(((Figure)di).getId());
            } else if (di instanceof Block) {
                this.oldMaterializedBlocks.add(((Block)di).getInputBlock());
            }
            this.oldVisibleWidgets.addAll(ow);
        }
        LOG.log(Level.FINE, "findOldWidgets: old visible count = {0}", this.oldVisibleWidgets.size());
    }

    private void moveFigures(Iterable<Figure> figs, Iterable<Block> blocks) {
        Widget w;
        if (this.model.getDiagramToView() != this.diagram) {
            this.phase = Phase.OBSOLETE;
            return;
        }
        this.sceneAnimator = this.scene.getSceneAnimator();
        boolean diagramEmpty = this.diagram.getFigures().isEmpty();
        this.scene.setBottomRightLocation(new Point(this.maxX + 20, this.maxY + 20));
        int count = 0;
        for (Figure f : figs) {
            assert (diagramEmpty || f.getDiagram() == this.diagram) : "Only figures created by UI thread can be moved";
            w = this.scene.createFigureWidget(f);
            if (w == null) continue;
            ++count;
            Point p = f.getPosition();
            w.setVisible(f.isVisible() && p != null);
            if (!w.isVisible()) continue;
            w.setBoundary(f.isBoundary());
            Point p2 = p.getLocation();
            if (this.visibleFigureCount <= 40 && this.oldVisibleWidgets != null && this.oldVisibleWidgets.contains(w)) {
                this.scene.animateMoveWidget(w, p2);
            } else {
                this.scene.moveWidget(w, p2);
            }
            for (OutputSlot s : f.getOutputSlots()) {
                this.processOutputSlot(s);
            }
        }
        LOG.log(Level.FINE, "moveFigures: moved {0} figures, number of objects: {1}", new Object[]{count, this.scene.getObjects().size()});
        if (this.model.getShowBlocks()) {
            for (Block b : blocks) {
                w = this.scene.createBlockWidget(b.getInputBlock());
                Rectangle bounds = b.getBounds();
                w.setVisible(b.isVisible() && bounds != null);
                if (!w.isVisible()) continue;
                Rectangle r = new Rectangle(bounds.getLocation(), bounds.getSize());
                if (this.visibleFigureCount <= 40 && this.oldVisibleWidgets != null && this.oldVisibleWidgets.contains(w)) {
                    this.scene.animateBounds(w, r);
                    continue;
                }
                this.scene.moveWidget(w, r);
            }
        }
        this.scene.validate();
    }

    protected boolean checkVisibleRectangle() {
        Rectangle r = this.scene.convertViewToScene(this.scene.getScrollPane().getViewport().getViewRect());
        return this.extendedViewportBounds.contains(r);
    }

    synchronized SceneUpdaterTask schedule(int delay) {
        this.scheduled = this.processor.post((Runnable)this, delay);
        return this;
    }

    synchronized void cancel() {
        if (this.scheduled != null) {
            this.scheduled.cancel();
        }
        LOG.log(Level.FINE, "Task cancelled: {0}", this);
        this.cancelled.set(true);
    }

    public boolean isCancelled() {
        return this.cancelled.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCompletion(Consumer<SceneUpdaterTask> l) {
        SceneUpdaterTask sceneUpdaterTask = this;
        synchronized (sceneUpdaterTask) {
            assert (this.completionListener == null);
            this.completionListener = l;
            if (this.phase != Phase.COMPLETE) {
                return;
            }
        }
        l.accept(this);
    }

    public synchronized Rectangle getExtendedBounds() {
        return new Rectangle(this.extendedViewportBounds);
    }

    static enum Phase {
        PREPARE,
        COMPUTE(false),
        VIEWPORT(true),
        FIND_WIDGETS(false),
        UPDATE_A,
        UPDATE_B,
        COMPLETE(false),
        OBSOLETE;

        private final boolean runInAWT;

        private Phase() {
            this(true);
        }

        private Phase(boolean runInAWT) {
            this.runInAWT = runInAWT;
        }

        public boolean runsInAWT() {
            return this.runInAWT;
        }
    }

    private static class CancelException
    extends RuntimeException {
    }

    class TimedIterable<T>
    implements Iterable<T> {
        private final long t = System.currentTimeMillis();
        private final Iterable<T> collection;
        private final int maxChunk;
        private final TimedIterable predecessor;
        private int reachedStop = Integer.MAX_VALUE;
        private boolean timeout;

        TimedIterable(Iterable<T> collection, int maxChunk, TimedIterable predecessor) {
            this.collection = collection;
            this.maxChunk = maxChunk;
            this.predecessor = predecessor;
            if (predecessor != null && predecessor.reachedStop < Integer.MAX_VALUE) {
                this.reachedStop = 0;
            }
        }

        TimedIterable(Iterable<T> collection, int maxChunk) {
            this(collection, maxChunk, null);
        }

        public int getStopIndex() {
            return this.reachedStop == Integer.MAX_VALUE ? 0 : this.reachedStop;
        }

        @Override
        public Iterator<T> iterator() {
            return new It<T>(this.collection.iterator());
        }

        void stopAt(int index, boolean time) {
            if (this.reachedStop < Integer.MAX_VALUE) {
                return;
            }
            this.reachedStop = index;
            this.timeout = time;
        }

        boolean isTimeOut() {
            return this.timeout;
        }

        boolean isTimeUp(int index) {
            long l = System.currentTimeMillis();
            if (this.predecessor != null && this.predecessor.isTimeOut()) {
                this.stopAt(index, true);
                return true;
            }
            if (index < this.maxChunk || l - this.t < 150L) {
                return false;
            }
            this.stopAt(index, true);
            return true;
        }

        class It<T>
        implements Iterator<T> {
            private final Iterator<T> delegate;
            private int cnt;
            private boolean stop;
            private T item;

            public It(Iterator<T> delegate) {
                this.delegate = delegate;
            }

            private void nextItem() {
                if (this.item != null || this.stop) {
                    return;
                }
                if (!this.delegate.hasNext()) {
                    this.stop = true;
                    TimedIterable.this.stopAt(this.cnt, false);
                }
                if (this.cnt >= TimedIterable.this.reachedStop || SceneUpdaterTask.this.cancelled.get()) {
                    this.stop = true;
                } else if (this.cnt % 150 == 0 && TimedIterable.this.isTimeUp(this.cnt)) {
                    this.stop = true;
                } else {
                    this.item = this.delegate.next();
                }
            }

            @Override
            public boolean hasNext() {
                this.nextItem();
                return this.item != null;
            }

            @Override
            public T next() {
                this.nextItem();
                if (this.item == null) {
                    throw new NoSuchElementException();
                }
                ++this.cnt;
                T tmp = this.item;
                this.item = null;
                return tmp;
            }
        }
    }

    private static class LineEntry {
        final int index;
        final Point last;
        final LineWidget pred;
        final List<Connection> conns;

        public LineEntry(List<Connection> connections, int controlPointIndex, Point lastPoint, LineWidget predecessor) {
            this.index = controlPointIndex;
            this.conns = connections;
            this.last = lastPoint;
            this.pred = predecessor;
        }
    }

    static class ConnectionSet {
        private final int hash;
        private final int x1;
        private final int y1;
        private final int x2;
        private final int y2;
        private final Set<Connection> connections;

        public ConnectionSet(Collection<Connection> connections, int x1, int y1, int x2, int y2) {
            this.connections = new HashSet<Connection>(connections);
            int h = 0;
            for (Connection c : connections) {
                h = h * 37 + c.hashCode();
            }
            h = h * 83 + x1;
            h = h * 83 + y1;
            h = h * 83 + x2;
            this.hash = h * 83 + y2;
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ConnectionSet)) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            ConnectionSet o = (ConnectionSet)obj;
            return o.x1 == this.x1 && o.y1 == this.y1 && o.x2 == this.x2 && o.y2 == this.y2 && this.connections.equals(o.connections);
        }

        public int hashCode() {
            return this.hash;
        }

        public Set<Connection> getConnectionSet() {
            return Collections.unmodifiableSet(this.connections);
        }
    }

    static class Cleaner
    extends SceneUpdaterTask {
        private List<Widget> allWidgets;
        private int from = 0;
        private final Consumer<Rectangle> updatedRectangleCallback;

        public Cleaner(DiagramScene scene, RequestProcessor processor, Consumer<Rectangle> callback) {
            super(scene, null, processor, Phase.PREPARE, Collections.emptySet());
            this.updatedRectangleCallback = callback;
        }

        private int collectObjects(Collection out, Widget w) {
            int cnt = 0;
            Object o = this.scene.findObject(w);
            if (o != null) {
                ++cnt;
                out.add(o);
            }
            for (Widget ch : w.getChildren()) {
                cnt += this.collectObjects(out, ch);
            }
            return cnt;
        }

        private boolean freeWidgets() {
            TimedIterable<Widget> ti = new TimedIterable<Widget>(this.allWidgets.subList(this.from, this.allWidgets.size()), 400);
            HashSet objectsToRemove = new HashSet();
            int cleanedObjects = 0;
            int cleanedWidgets = 0;
            block0: for (Widget w : ti) {
                List allW;
                Object o;
                Rectangle wb;
                Rectangle ob;
                if (w == null) continue;
                if (this.isCancelled()) {
                    return false;
                }
                Widget parent = w.getParentWidget();
                if (!(parent instanceof LayerWidget) || !w.isVisible() || (ob = w.getBounds()) == null || this.extendedViewportBounds.intersects(wb = w.convertLocalToScene(ob)) || (o = this.scene.findObject(w)) == null) continue;
                if (w instanceof LineWidget && o instanceof ConnectionSet) {
                    ConnectionSet cs = (ConnectionSet)o;
                    for (Connection c : cs.getConnectionSet()) {
                        if (!this.isConnectionReachable(c)) continue;
                        continue block0;
                    }
                }
                if ((allW = this.scene.findWidgets(o)) == null) continue;
                ++cleanedObjects;
                for (Widget x : allW) {
                    Widget pw = x.getParentWidget();
                    if (pw != null) {
                        pw.removeChild(x);
                        ++cleanedWidgets;
                    }
                    int c = this.collectObjects(objectsToRemove, w);
                    if (pw == null) continue;
                    cleanedWidgets += c;
                }
            }
            for (Object o : objectsToRemove) {
                ObjectState s = this.scene.getObjectState(o);
                if (s != ObjectState.createNormal()) {
                    this.scene.removeObjectMapping(o);
                    continue;
                }
                this.scene.removeObject(o);
            }
            this.from += ti.getStopIndex();
            LOG.log(Level.FINE, "Cleaned objects: {0}, widgets: {1}", new Object[]{cleanedObjects, cleanedWidgets});
            return this.from < this.allWidgets.size();
        }

        @Override
        protected void processPhase(Phase phase) {
            switch (phase) {
                case PREPARE: {
                    this.allWidgets = ((Stream)this.scene.getObjects().stream().parallel()).map(o -> (Widget)this.scene.getWidget(o)).collect(Collectors.toList());
                    this.nextPhase = Phase.UPDATE_A;
                    return;
                }
                case UPDATE_A: {
                    Rectangle rect = this.scene.getVisibleSceneRect();
                    if (!this.extendedViewportBounds.contains(rect)) {
                        this.nextPhase = Phase.COMPLETE;
                        return;
                    }
                    this.updatedRectangleCallback.accept(this.extendedViewportBounds);
                    if (this.freeWidgets()) {
                        this.nextPhase = null;
                        break;
                    }
                    this.complete();
                }
            }
        }
    }

    static class DisplayWidgets
    extends SceneUpdaterTask {
        public DisplayWidgets(DiagramScene scene, LayoutSettings.LayoutSettingBean settings, RequestProcessor processor, Set<Pair<Point, Point>> lastLineCache) {
            super(scene, settings, processor, Phase.COMPUTE, lastLineCache);
        }

        @Override
        protected void processPhase(Phase phase) {
            Rectangle rect = this.scene.convertViewToScene(this.scene.getScrollPane().getViewport().getViewRect());
            if (!this.extendedViewportBounds.intersects(rect)) {
                this.nextPhase = Phase.OBSOLETE;
                return;
            }
            switch (phase) {
                case COMPUTE: {
                    LOG.log(Level.FINE, "Display update for exviewport: {0} ", new Object[]{this.extendedViewportBounds});
                    this.diagram.render(this::findDimensions);
                    break;
                }
                case VIEWPORT: {
                    this.setupViewportBounds();
                    break;
                }
                case FIND_WIDGETS: {
                    this.findWidgetsToUpdate(false);
                    break;
                }
                case UPDATE_A: {
                    LOG.log(Level.FINE, "Display update visible for viewport: {0} ", new Object[]{this.extendedViewportBounds});
                    if (this.updateVisibleWidgetsIncrementally()) {
                        this.nextPhase = null;
                        this.scene.fireSceneUpdated(false);
                        break;
                    }
                    LOG.log(Level.FINE, "Visible updated, count = {0} ", new Object[]{this.updateFigures.size()});
                    break;
                }
                case UPDATE_B: {
                    this.diagram.render(() -> {
                        if (this.moveFiguresIncrementally()) {
                            this.nextPhase = null;
                        } else {
                            this.complete();
                        }
                    });
                }
            }
        }
    }
}

