/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.graalvm.visualizer.util.GraphTypes;
import org.graalvm.visualizer.util.RangeSlider;
import org.graalvm.visualizer.util.RangeSliderModel;
import org.graalvm.visualizer.view.api.TimelineModel;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;

public class SliderPanel
extends JPanel {
    private static final Logger LOG = Logger.getLogger(SliderPanel.class.getName());
    private final TimelineModel timeline;
    private final Map<String, RangeSlider> sliderUIs = new HashMap<String, RangeSlider>();
    private final String primaryType;
    private final GraphTypes graphTypes;
    private List<RangeSlider> rowOrder = Collections.emptyList();
    private JPanel sliders;

    public SliderPanel(String primaryType, TimelineModel timeline) {
        this.timeline = timeline;
        this.primaryType = primaryType;
        this.graphTypes = (GraphTypes)Lookup.getDefault().lookup(GraphTypes.class);
        this.initComponents();
        timeline.addPropertyChangeListener(pe -> {
            if ("partitions".equals(pe.getPropertyName())) {
                this.updateSliders();
            }
        });
    }

    private void initComponents() {
        this.sliders = new JPanel();
        this.sliders.setLayout(new GridBagLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sliders, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sliders, -2, -1, -2));
    }

    private void updateSliders() {
        Container p;
        LOG.log(Level.FINE, "{0}: sliders updating", this.logId());
        Set types = this.timeline.getPartitionTypes();
        ArrayList<RangeSlider> newOrder = new ArrayList<RangeSlider>();
        ArrayList<String> keys = new ArrayList<String>(types);
        Collections.sort(keys, this.graphTypes.typeOrderComparator());
        if (keys.remove(this.primaryType)) {
            keys.add(0, this.primaryType);
        }
        for (String t : types) {
            RangeSliderModel m = this.timeline.getPartitionRange(t);
            if (m == null) continue;
            RangeSlider sl = this.sliderUIs.get(t);
            if (sl == null || sl.getModel() != m) {
                sl = new RangeSlider();
                sl.setShowGaps(true);
                sl.setModel(m);
                if (m != this.timeline.getPrimaryRange()) {
                    sl.setBasicBarColor(RangeSlider.BAR_INACTIVE_COLOR);
                }
                this.sliderUIs.put(t, sl);
            }
            newOrder.add(sl);
        }
        if (this.rowOrder.equals(newOrder)) {
            return;
        }
        for (Component c : this.sliders.getComponents()) {
            this.sliders.remove(c);
        }
        this.rowOrder = newOrder;
        GridBagConstraints iconConstraints = new GridBagConstraints();
        iconConstraints.anchor = 13;
        GridBagConstraints sliderConstraints = new GridBagConstraints();
        sliderConstraints.gridwidth = 0;
        sliderConstraints.weightx = 1.0;
        sliderConstraints.fill = 2;
        for (String k : keys) {
            RangeSlider sl = this.sliderUIs.get(k);
            JLabel jl = new JLabel();
            Node n = this.graphTypes.getTypeNode(k);
            Image im = n.getIcon(1);
            jl.setIcon(ImageUtilities.image2Icon((Image)im));
            jl.setToolTipText(n.getDisplayName());
            this.sliders.add((Component)jl, iconConstraints);
            this.sliders.add((Component)sl, sliderConstraints);
            sl.setAlignmentX(0.0f);
        }
        JComponent c = this;
        while (!(c instanceof JScrollPane) && (p = c.getParent()) instanceof JComponent) {
            c = (JComponent)p;
        }
        LOG.log(Level.FINE, "{0}: sliders updated = {1}", new Object[]{this.logId(), keys});
        this.sliders.invalidate();
        this.invalidate();
        JComponent target = (JComponent)c.getParent();
        SwingUtilities.invokeLater(() -> {
            target.invalidate();
            target.revalidate();
        });
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.updateSliders();
    }

    private static String logId(TimelineModel timeline) {
        return "SliderPanel[" + timeline.getSource().getName() + " / " + timeline.getPrimaryType() + "]";
    }

    private String logId() {
        return SliderPanel.logId(this.timeline);
    }

    @Override
    public String toString() {
        return "SliderPanel[timeline = " + this.timeline + ", " + this.paramString() + "]";
    }

    static class Layout
    extends ScrollPaneLayout.UIResource {
        final TimelineModel timeline;

        public Layout(TimelineModel timeline) {
            this.timeline = timeline;
        }

        @Override
        public void layoutContainer(Container parent) {
            super.layoutContainer(parent);
            LOG.log(Level.FINER, "{0}: Layouted: {1}, parent: {2}", new Object[]{SliderPanel.logId(this.timeline), parent.getBounds(), parent.getParent().getBounds()});
            if (parent.getSize().width == 0) {
                SwingUtilities.invokeLater(() -> {
                    parent.invalidate();
                    parent.revalidate();
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension dim;
            Container p;
            int w;
            Dimension extentSize = null;
            JScrollPane scrollPane = (JScrollPane)parent;
            boolean forceScrollbar = false;
            int thsbPolicy = scrollPane.getHorizontalScrollBarPolicy();
            if (this.viewport != null) {
                extentSize = this.viewport.getPreferredSize();
            }
            if ((w = parent.getWidth()) == 0 && (w = (p = parent.getParent()).getWidth()) == 0) {
                SwingUtilities.invokeLater(() -> {
                    p.invalidate();
                    p.revalidate();
                });
            }
            if (extentSize != null && w > 0) {
                Insets insets = parent.getInsets();
                int prefWidth = insets.left + insets.right;
                prefWidth += extentSize.width;
                Border viewportBorder = scrollPane.getViewportBorder();
                if (viewportBorder != null) {
                    Insets vpbInsets = viewportBorder.getBorderInsets(parent);
                    prefWidth += vpbInsets.left + vpbInsets.right;
                }
                if (this.rowHead != null && this.rowHead.isVisible()) {
                    prefWidth += this.rowHead.getPreferredSize().width;
                }
                if (prefWidth > w && this.hsb != null && thsbPolicy != 31) {
                    forceScrollbar = true;
                }
            }
            try {
                if (forceScrollbar) {
                    scrollPane.setHorizontalScrollBarPolicy(32);
                }
                dim = super.preferredLayoutSize(parent);
            }
            finally {
                if (forceScrollbar) {
                    scrollPane.setHorizontalScrollBarPolicy(thsbPolicy);
                }
            }
            LOG.log(Level.FINER, "{0}: Preferred layout: {1}, parent was: {2}", new Object[]{SliderPanel.logId(this.timeline), dim, parent.getSize()});
            return dim;
        }
    }
}

