/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.view.impl;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import org.graalvm.visualizer.filter.Filter;
import org.graalvm.visualizer.graph.Diagram;
import org.graalvm.visualizer.settings.layout.LayoutSettings;
import org.graalvm.visualizer.view.DiagramViewModel;
import org.graalvm.visualizer.view.impl.DiagramCacheBase;
import org.graalvm.visualizer.view.impl.DiagramCacheUpdater;
import org.openide.util.Utilities;

public class DiagramCache
implements DiagramCacheBase {
    private static final Logger LOG = Logger.getLogger(DiagramCache.class.getName());
    private final Map<GraphTextKey, InputGraphDiagramCache> baseDiagramMap = new HashMap<GraphTextKey, InputGraphDiagramCache>();
    private final Map<DiagramViewModel, DiagramCacheUpdater> updaters = new WeakHashMap<DiagramViewModel, DiagramCacheUpdater>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flush() {
        DiagramCache inst;
        DiagramCache diagramCache = inst = DiagramCache.getInstance();
        synchronized (diagramCache) {
            inst.baseDiagramMap.clear();
            inst.updaters.clear();
        }
    }

    private DiagramCache() {
    }

    @Override
    public DiagramCacheUpdater.Phase nextPhase(DiagramViewModel model) {
        return DiagramCacheUpdater.Phase.BUILD;
    }

    @Override
    public Diagram get() {
        return null;
    }

    @Override
    public Map getMap() {
        return this.baseDiagramMap;
    }

    public static DiagramCache getInstance() {
        return DiagramCacheHolder.INSTANCE;
    }

    private DiagramCacheUpdater getUpdater(DiagramViewModel model) {
        return this.updaters.computeIfAbsent(model, m -> new DiagramCacheUpdater((DiagramViewModel)m));
    }

    @Override
    public synchronized Diagram getDiagram(DiagramViewModel model, Consumer<Diagram> diagramReadyCallback) {
        GraphTextKey key = new GraphTextKey(model.getGraphToView(), model.getNodeText());
        InputGraphDiagramCache inputGraphDiagramCache = this.baseDiagramMap.get(key);
        Diagram tmp = null;
        if (inputGraphDiagramCache != null) {
            tmp = (Diagram)inputGraphDiagramCache.get();
        }
        if (tmp == null) {
            LOG.log(Level.FINE, "Scheduling building of Diagram for model: {0}", model);
            this.getUpdater(model).scheduleUpdate(this, diagramReadyCallback);
            return null;
        }
        LOG.log(Level.FINE, "Obtaining cached Diagram from: {0}", inputGraphDiagramCache);
        return inputGraphDiagramCache.getDiagram(model, diagramReadyCallback);
    }

    @Override
    public synchronized DiagramCacheBase makeCache(DiagramViewModel model, Diagram baseDiagram) {
        GraphTextKey key = new GraphTextKey(model.getGraphToView(), model.getNodeText());
        InputGraphDiagramCache inputGraphDiagramCache = this.baseDiagramMap.get(key);
        Diagram tmp = null;
        if (inputGraphDiagramCache != null) {
            tmp = (Diagram)inputGraphDiagramCache.get();
        }
        if (tmp == null) {
            inputGraphDiagramCache = new InputGraphDiagramCache(baseDiagram, new SoftReference<GraphTextKey>(key), this);
            this.baseDiagramMap.put(key, inputGraphDiagramCache);
        }
        return inputGraphDiagramCache;
    }

    private static class DiagramCacheHolder {
        private static final DiagramCache INSTANCE = new DiagramCache();

        private DiagramCacheHolder() {
        }
    }

    private static final class GraphTextKey {
        final InputGraph graph;
        final String nodeText;
        final int hash;

        public GraphTextKey(InputGraph graph, String nodeText) {
            this.graph = graph;
            this.nodeText = nodeText;
            this.hash = this.makeHash();
        }

        private int makeHash() {
            return (this.nodeText.hashCode() * 53 + this.graph.hashCode() * 17) * 31;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof GraphTextKey)) {
                return false;
            }
            GraphTextKey other = (GraphTextKey)obj;
            return this.nodeText.equals(other.nodeText) && this.graph == other.graph;
        }
    }

    public final class InputGraphDiagramCache
    extends DiagramCacheValue<GraphTextKey> {
        public final Map<List<Filter>, FilterDiagramCache> filteredDiagramMap;

        protected InputGraphDiagramCache(Diagram referent, Reference<GraphTextKey> key, DiagramCacheBase parent) {
            super(referent, key, parent);
            this.filteredDiagramMap = new HashMap<List<Filter>, FilterDiagramCache>();
        }

        @Override
        protected Map<GraphTextKey, InputGraphDiagramCache> getParentMap() {
            return DiagramCache.this.baseDiagramMap;
        }

        @Override
        public synchronized Diagram getDiagram(DiagramViewModel model, Consumer<Diagram> diagramReadyCallback) {
            List<Filter> filters = model.getFilters();
            FilterDiagramCache filterDiagramCache = this.filteredDiagramMap.get(filters);
            Diagram tmp = null;
            if (filterDiagramCache != null) {
                tmp = (Diagram)filterDiagramCache.get();
            }
            if (tmp == null) {
                LOG.log(Level.FINE, "Scheduling filtering of Diagram for model: {0}", model);
                DiagramCache.this.getUpdater(model).scheduleUpdate(this, diagramReadyCallback);
                return null;
            }
            LOG.log(Level.FINE, "Obtaining cached Diagram from: {0}", filterDiagramCache);
            return filterDiagramCache.getDiagram(model, diagramReadyCallback);
        }

        @Override
        public synchronized DiagramCacheBase makeCache(DiagramViewModel model, Diagram baseDiagram) {
            List<Filter> filters = model.getFilters();
            FilterDiagramCache filterDiagramCache = this.filteredDiagramMap.get(filters);
            Diagram tmp = null;
            if (filterDiagramCache != null) {
                tmp = (Diagram)filterDiagramCache.get();
            }
            if (tmp == null) {
                filterDiagramCache = new FilterDiagramCache(baseDiagram, new WeakReference<List<Filter>>(filters), this);
                this.filteredDiagramMap.put(filters, filterDiagramCache);
            }
            return filterDiagramCache;
        }

        @Override
        public DiagramCacheUpdater.Phase nextPhase(DiagramViewModel model) {
            return DiagramCacheUpdater.Phase.FILTER;
        }

        @Override
        public Map getMap() {
            return this.filteredDiagramMap;
        }
    }

    private static final class HiddenNodesSet
    extends HashSet<Integer> {
        final int hash;
        final boolean showNodeHull;

        public HiddenNodesSet(Set<Integer> ids, boolean showNodeHull) {
            super(ids);
            this.showNodeHull = showNodeHull;
            this.hash = this.makeHash();
        }

        private int makeHash() {
            int hash = 0;
            for (Integer i : this) {
                hash += i.intValue();
            }
            return this.showNodeHull ? hash * 7 : hash;
        }

        @Override
        public int hashCode() {
            return this.hash;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof HiddenNodesSet)) {
                return false;
            }
            HiddenNodesSet other = (HiddenNodesSet)o;
            if (other.size() != this.size() || this.showNodeHull != other.showNodeHull) {
                return false;
            }
            return this.containsAll(other);
        }
    }

    private static abstract class DiagramCacheValue<TKey>
    extends WeakReference<Diagram>
    implements DiagramCacheBase,
    Runnable {
        protected final Reference<TKey> key;
        protected final Diagram parentDiagram;
        protected final DiagramCacheBase parent;

        protected DiagramCacheValue(Diagram referent, Reference<TKey> key, DiagramCacheBase parent) {
            super(referent, Utilities.activeReferenceQueue());
            assert (parent != null);
            this.key = key;
            this.parentDiagram = parent.get();
            this.parent = parent;
        }

        public Diagram getParentDiagram() {
            return this.parentDiagram;
        }

        private DiagramCacheBase getParent() {
            return this.parent;
        }

        protected Map getParentMap() {
            return this.getParent().getMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TKey g = this.key.get();
            if (g != null) {
                LOG.log(Level.FINE, "Diagram GCed, removing cache: {0}", this);
                DiagramCacheBase diagramCacheBase = this.getParent();
                synchronized (diagramCacheBase) {
                    this.getParentMap().remove(g, this);
                }
            } else {
                LOG.log(Level.FINE, "Key GCed, removed cache: {0}", this);
            }
        }
    }

    public final class ExtractedDiagramCache
    extends DiagramCacheValue<Set<Integer>> {
        protected ExtractedDiagramCache(Diagram referent, Reference<Set<Integer>> key, DiagramCacheBase parent) {
            super(referent, key, parent);
        }

        @Override
        public synchronized Diagram getDiagram(DiagramViewModel model, Consumer<Diagram> diagramReadyCallback) {
            Diagram fin = (Diagram)this.get();
            assert (fin != null);
            LOG.log(Level.FINE, "Loaded cached Diagram: {0}.", fin);
            return fin;
        }

        @Override
        public DiagramCacheUpdater.Phase nextPhase(DiagramViewModel model) {
            return DiagramCacheUpdater.Phase.DONE;
        }

        @Override
        public DiagramCacheBase makeCache(DiagramViewModel model, Diagram baseDiagram) {
            return null;
        }

        @Override
        public Map getMap() {
            return null;
        }
    }

    public final class LayoutDiagramCache
    extends DiagramCacheValue<LayoutSettings.LayoutSettingBean> {
        public final Map<Set<Integer>, ExtractedDiagramCache> extractedDiagramMap;

        protected LayoutDiagramCache(Diagram referent, Reference<LayoutSettings.LayoutSettingBean> key, DiagramCacheBase parent) {
            super(referent, key, parent);
            this.extractedDiagramMap = new HashMap<Set<Integer>, ExtractedDiagramCache>();
        }

        @Override
        public synchronized Diagram getDiagram(DiagramViewModel model, Consumer<Diagram> diagramReadyCallback) {
            Collection hidNodes = model.getHiddenNodes();
            if (hidNodes.isEmpty()) {
                Diagram fin = (Diagram)this.get();
                assert (fin != null);
                assert (fin.getSize() != null) : "Diagram wasn't laid out, but would be returned as finished.";
                LOG.log(Level.FINE, "Loaded cached unextracted Diagram: {0}.", fin);
                return fin;
            }
            HiddenNodesSet hiddenNodes = new HiddenNodesSet((Set<Integer>)hidNodes, model.getShowNodeHull());
            ExtractedDiagramCache extractedDiagramCache = this.extractedDiagramMap.get(hiddenNodes);
            Diagram tmp = null;
            if (extractedDiagramCache != null) {
                tmp = (Diagram)extractedDiagramCache.get();
            }
            if (tmp == null) {
                LOG.log(Level.FINE, "Scheduling extraction of Diagram for model: {0}", model);
                DiagramCache.this.getUpdater(model).scheduleUpdate(this, diagramReadyCallback);
                return null;
            }
            LOG.log(Level.FINE, "Obtaining cached Diagram from: {0}", extractedDiagramCache);
            return extractedDiagramCache.getDiagram(model, diagramReadyCallback);
        }

        @Override
        public synchronized DiagramCacheBase makeCache(DiagramViewModel model, Diagram baseDiagram) {
            HiddenNodesSet hiddenNodes = new HiddenNodesSet((Set<Integer>)model.getHiddenNodes(), model.getShowNodeHull());
            ExtractedDiagramCache extractedDiagramCache = this.extractedDiagramMap.get(hiddenNodes);
            Diagram tmp = null;
            if (extractedDiagramCache != null) {
                tmp = (Diagram)extractedDiagramCache.get();
            }
            if (tmp == null) {
                extractedDiagramCache = new ExtractedDiagramCache(baseDiagram, new SoftReference<Set<Integer>>(hiddenNodes), this);
                this.extractedDiagramMap.put(hiddenNodes, extractedDiagramCache);
            }
            return extractedDiagramCache;
        }

        @Override
        public DiagramCacheUpdater.Phase nextPhase(DiagramViewModel model) {
            if (model.getHiddenNodes().isEmpty()) {
                return DiagramCacheUpdater.Phase.DONE;
            }
            return DiagramCacheUpdater.Phase.EXTRACT;
        }

        @Override
        public Map getMap() {
            return this.extractedDiagramMap;
        }
    }

    public final class FilterDiagramCache
    extends DiagramCacheValue<List<Filter>> {
        public final Map<LayoutSettings.LayoutSettingBean, LayoutDiagramCache> laidOutDiagramMap;

        protected FilterDiagramCache(Diagram referent, Reference<List<Filter>> key, DiagramCacheBase parent) {
            super(referent, key, parent);
            this.laidOutDiagramMap = new HashMap<LayoutSettings.LayoutSettingBean, LayoutDiagramCache>();
        }

        @Override
        public synchronized Diagram getDiagram(DiagramViewModel model, Consumer<Diagram> diagramReadyCallback) {
            LayoutSettings.LayoutSettingBean layoutSetting = model.getLayoutSetting();
            LayoutDiagramCache layoutDiagramCache = this.laidOutDiagramMap.get(layoutSetting);
            Diagram tmp = null;
            if (layoutDiagramCache != null) {
                tmp = (Diagram)layoutDiagramCache.get();
            }
            if (tmp == null || tmp.getSize() == null) {
                LOG.log(Level.FINE, "Scheduling layouting of Diagram for model: {0}", model);
                DiagramCache.this.getUpdater(model).scheduleUpdate(this, diagramReadyCallback);
                return null;
            }
            LOG.log(Level.FINE, "Obtaining cached Diagram from: {0}", layoutDiagramCache);
            return layoutDiagramCache.getDiagram(model, diagramReadyCallback);
        }

        @Override
        public synchronized DiagramCacheBase makeCache(DiagramViewModel model, Diagram baseDiagram) {
            LayoutSettings.LayoutSettingBean layoutSetting = model.getLayoutSetting();
            LayoutDiagramCache layoutDiagramCache = this.laidOutDiagramMap.get(layoutSetting);
            Diagram tmp = null;
            if (layoutDiagramCache != null) {
                tmp = (Diagram)layoutDiagramCache.get();
            }
            if (tmp != null && tmp.getSize() == null) {
                LOG.log(Level.FINE, "Exchanging stub Diagram: {0} for its laid out counterpart: {1}", new Object[]{tmp, baseDiagram});
                LayoutDiagramCache layoutDiagramCacheNew = new LayoutDiagramCache(baseDiagram, new WeakReference<LayoutSettings.LayoutSettingBean>(layoutSetting), this);
                this.laidOutDiagramMap.put(layoutSetting, layoutDiagramCacheNew);
                for (ExtractedDiagramCache c : layoutDiagramCache.extractedDiagramMap.values()) {
                    Set key = (Set)c.key.get();
                    Diagram d = (Diagram)c.get();
                    if (d == null || key == null) continue;
                    layoutDiagramCacheNew.extractedDiagramMap.put(key, new ExtractedDiagramCache(d, c.key, layoutDiagramCacheNew));
                }
                layoutDiagramCache = layoutDiagramCacheNew;
            } else if (tmp == null) {
                layoutDiagramCache = new LayoutDiagramCache(baseDiagram, new WeakReference<LayoutSettings.LayoutSettingBean>(layoutSetting), this);
                this.laidOutDiagramMap.put(layoutSetting, layoutDiagramCache);
            }
            return layoutDiagramCache;
        }

        @Override
        public DiagramCacheUpdater.Phase nextPhase(DiagramViewModel model) {
            return DiagramCacheUpdater.Phase.LAYOUT;
        }

        @Override
        public Map getMap() {
            return this.laidOutDiagramMap;
        }
    }
}

