/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.view.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import jdk.graal.compiler.graphio.parsing.model.Group;
import jdk.graal.compiler.graphio.parsing.model.InputBlock;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import org.graalvm.visualizer.filter.CustomFilter;
import org.graalvm.visualizer.filter.Filter;
import org.graalvm.visualizer.filter.FilterCanceledException;
import org.graalvm.visualizer.filter.FilterChain;
import org.graalvm.visualizer.filter.FilterExecution;
import org.graalvm.visualizer.filter.FilterExecutionService;
import org.graalvm.visualizer.graph.Block;
import org.graalvm.visualizer.graph.Connection;
import org.graalvm.visualizer.graph.Diagram;
import org.graalvm.visualizer.graph.Figure;
import org.graalvm.visualizer.hierarchicallayout.HierarchicalClusterLayoutManager;
import org.graalvm.visualizer.hierarchicallayout.HierarchicalLayoutManager;
import org.graalvm.visualizer.layout.LayoutGraph;
import org.graalvm.visualizer.settings.layout.LayoutSettings;
import org.graalvm.visualizer.view.DiagramScene;
import org.graalvm.visualizer.view.DiagramViewModel;
import org.graalvm.visualizer.view.impl.DiagramCacheUpdater;
import org.graalvm.visualizer.view.impl.FilterView;
import org.openide.util.Exceptions;

public abstract class DiagramCacheTask
implements Runnable {
    private static final Logger LOG = Logger.getLogger(DiagramCacheTask.class.getName());
    protected final DiagramViewModel model;
    protected final Diagram baseDiagram;
    private final DiagramCacheUpdater updater;
    protected Diagram outputDiagram;
    private final AtomicBoolean cancelled;

    static DiagramCacheTask makeTask(Diagram diagram, DiagramViewModel model, DiagramCacheUpdater updater, DiagramCacheUpdater.Phase phase) {
        switch (phase) {
            case BUILD: {
                return new Building(model, updater);
            }
            case EXTRACT: {
                return new Extraction(diagram, model, updater);
            }
            case FILTER: {
                return new Filtering(diagram, model, updater);
            }
            case LAYOUT: {
                return new Layouting(diagram, model, updater);
            }
        }
        return null;
    }

    private DiagramCacheTask(Diagram baseDiagram, DiagramViewModel model, DiagramCacheUpdater updater) {
        this.baseDiagram = baseDiagram;
        this.cancelled = new AtomicBoolean(false);
        this.model = model;
        this.updater = updater;
    }

    public void cancel() {
        LOG.log(Level.FINE, "Cancelled task: {0}", this);
        this.cancelled.set(true);
    }

    public boolean cancelled() {
        return this.cancelled.get();
    }

    protected abstract void execute();

    @Override
    public final void run() {
        if (this.baseDiagram != null && !this.cancelled()) {
            this.outputDiagram = this.baseDiagram.copy();
        }
        if (!this.cancelled()) {
            this.execute();
        }
        if (!this.cancelled()) {
            this.updater.afterTask(this);
        }
    }

    private static class Building
    extends DiagramCacheTask {
        public Building(DiagramViewModel model, DiagramCacheUpdater updater) {
            super(null, model, updater);
        }

        @Override
        protected void execute() {
            Group.LazyContent lg;
            InputGraph g = this.model.getGraphToView();
            if (g instanceof Group.LazyContent && !(lg = (Group.LazyContent)g).isComplete()) {
                try {
                    Object lc = lg.completeContents(null).get();
                }
                catch (InterruptedException | ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            this.outputDiagram = Diagram.createDiagram((InputGraph)g, (String)this.model.getNodeText());
        }
    }

    private static class Extraction
    extends DiagramCacheTask {
        HierarchicalLayoutManager manager;
        HierarchicalClusterLayoutManager clusterManager;

        @Override
        public void cancel() {
            super.cancel();
            if (this.manager != null) {
                this.manager.cancel();
            }
            if (this.clusterManager != null) {
                this.clusterManager.cancel();
            }
        }

        public Extraction(Diagram baseDiagram, DiagramViewModel model, DiagramCacheUpdater updater) {
            super(baseDiagram, model, updater);
        }

        @Override
        protected void execute() {
            LayoutSettings.LayoutSettingBean layoutSettings = this.model.getLayoutSetting();
            Set<InputNode> hiddenNodes = this.model.getHiddenGraphNodes();
            assert (!hiddenNodes.isEmpty()) : "Diagram should never be extracted without hidden nodes.";
            this.updateHiddenFigures(hiddenNodes);
            if (this.cancelled()) {
                return;
            }
            HashSet<Figure> figures = new HashSet<Figure>();
            HashSet<Connection> edges = new HashSet<Connection>();
            for (Figure f : this.outputDiagram.getFigures()) {
                if (!f.isVisible()) continue;
                figures.add(f);
            }
            for (Connection c : this.outputDiagram.iterateConnections()) {
                Figure f1 = c.getOutputSlot().getFigure();
                Figure f2 = c.getInputSlot().getFigure();
                if (!f1.isVisible() || !f2.isVisible()) continue;
                edges.add(c);
            }
            if (this.cancelled()) {
                return;
            }
            LayoutGraph graph = new LayoutGraph(edges, figures);
            if (this.model.getShowBlocks()) {
                this.clusterManager = new HierarchicalClusterLayoutManager(HierarchicalLayoutManager.Combine.SAME_OUTPUTS, layoutSettings);
                this.clusterManager.getManager().setMaxLayerLength(((Integer)layoutSettings.get(Integer.class, "MAX_BLOCK_LAYER_LENGTH")).intValue());
                this.clusterManager.getSubManager().setMaxLayerLength(((Integer)layoutSettings.get(Integer.class, "MAX_LAYER_LENGTH")).intValue());
                if (((Boolean)layoutSettings.get(Boolean.class, "STABILIZED_LAYOUT")).booleanValue() && !((Boolean)layoutSettings.get(Boolean.class, "DEFAULT_LAYOUT")).booleanValue()) {
                    this.clusterManager.doRouting(graph);
                } else {
                    this.clusterManager.doLayout(graph);
                }
            } else {
                this.manager = new HierarchicalLayoutManager(HierarchicalLayoutManager.Combine.SAME_OUTPUTS, layoutSettings);
                this.manager.setMaxLayerLength(((Integer)layoutSettings.get(Integer.class, "MAX_LAYER_LENGTH")).intValue());
                if (((Boolean)layoutSettings.get(Boolean.class, "STABILIZED_LAYOUT")).booleanValue() && !((Boolean)layoutSettings.get(Boolean.class, "DEFAULT_LAYOUT")).booleanValue()) {
                    this.manager.doRouting(graph);
                } else {
                    this.manager.doLayout(graph);
                }
            }
            if (this.cancelled()) {
                return;
            }
            this.outputDiagram.setSize(graph.getSize());
            LOG.log(Level.FINE, "outputDiagram figure size: {0}", this.outputDiagram.getFigures().size());
        }

        private void updateHiddenFigures(Set<InputNode> newHiddenNodes) {
            assert (this.outputDiagram != null);
            assert (!SwingUtilities.isEventDispatchThread());
            InputGraph g = this.outputDiagram.getGraph();
            HashSet<InputBlock> visibleBlocks = new HashSet<InputBlock>();
            int hiddenCount = 0;
            Iterator iterator = this.outputDiagram.getFigures().iterator();
            while (iterator.hasNext()) {
                Figure f;
                boolean hiddenAfter = DiagramScene.doesIntersect((f = (Figure)iterator.next()).getSource().getSourceNodes(), newHiddenNodes);
                f.setVisible(!hiddenAfter);
                f.setBoundary(false);
                if (hiddenAfter) {
                    ++hiddenCount;
                } else {
                    for (Object n : f.getSource().getSourceNodes()) {
                        visibleBlocks.add(g.getBlock((InputNode)n));
                    }
                }
                if (!this.cancelled()) continue;
                return;
            }
            HashSet<Figure> boundaryFigures = new HashSet<Figure>();
            if (this.model.getShowNodeHull()) {
                block2: for (Figure f : this.outputDiagram.getFigures()) {
                    if (f.isVisible()) continue;
                    HashSet set = new HashSet(f.getPredecessorSet());
                    set.addAll(f.getSuccessorSet());
                    for (Figure neighbor : set) {
                        if (!neighbor.isVisible()) continue;
                        boundaryFigures.add(f);
                        continue block2;
                    }
                }
                if (this.cancelled()) {
                    return;
                }
                for (Figure f : boundaryFigures) {
                    f.setVisible(true);
                    f.setBoundary(true);
                    for (Object n : f.getSource().getSourceNodes()) {
                        this.outputDiagram.getBlock(g.getBlock((InputNode)n)).setVisible(true);
                    }
                }
                if (this.cancelled()) {
                    return;
                }
            }
            for (InputBlock ib : visibleBlocks) {
                this.outputDiagram.getBlock(ib).setVisible(true);
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "updateHiddenFigures: hidden count:{0}, boundaryFigures:{1}", new Object[]{hiddenCount, boundaryFigures.size()});
            }
        }
    }

    private static class Filtering
    extends DiagramCacheTask {
        private static final CustomFilter DIFF_FILTER = new CustomFilter("difference", "colorize('state', 'same', white);colorize('state', 'changed', orange);colorize('state', 'new', green);colorize('state', 'deleted', red);");
        private final FilterView viewApi;
        private FilterExecution chainControl;

        public Filtering(Diagram baseDiagram, DiagramViewModel model, DiagramCacheUpdater updater) {
            super(baseDiagram, model, updater);
            this.viewApi = new FilterView(model);
        }

        @Override
        public void cancel() {
            super.cancel();
            if (this.chainControl != null) {
                this.chainControl.cancel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void execute() {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Processing diagram {0} of graph {1} with filters", new Object[]{this.outputDiagram, this.outputDiagram.getGraph().getName()});
            }
            FilterChain filterChain = new FilterChain(this.model.getFilterChain());
            if (this.model.getDiagramPeers().getFirstPosition() != this.model.getDiagramPeers().getSecondPosition()) {
                filterChain.addFilter((Filter)DIFF_FILTER);
            }
            this.model.getScriptFilters().forEach(f -> filterChain.addFilter(f));
            boolean error = true;
            FilterExecutionService exec = FilterExecution.getExecutionService();
            try {
                this.chainControl = this.configure(exec.createExecution(filterChain, null, this.outputDiagram));
                LOG.log(Level.FINE, "Using filterchain control {0}", this.chainControl);
                this.chainControl.process();
                if (this.cancelled()) {
                    LOG.log(Level.FINE, "Processing cancelled");
                    return;
                }
                LOG.log(Level.FINE, "Scheduling viewApi execution.");
                SwingUtilities.invokeAndWait(() -> {
                    if (!this.cancelled()) {
                        this.model.withDiagramToView(d -> this.viewApi.perform());
                    }
                });
                error = false;
            }
            catch (FilterCanceledException ex) {
                LOG.log(Level.FINE, "Aborted with Cancelled exception from control {0}", ex.getEnvironment());
                this.cancel();
                error = false;
            }
            catch (RuntimeException ex) {
                LOG.log(Level.WARNING, "Error during processing", ex);
            }
            catch (InterruptedException | InvocationTargetException ex) {
                LOG.log(Level.WARNING, "Error during processing", ex);
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                if (error) {
                    this.cancel();
                }
            }
            LOG.log(Level.FINE, "outputDiagram figure size: {0}", this.outputDiagram.getFigures().size());
        }

        private FilterExecution configure(FilterExecution ex) {
            ex.getEnvironment().globals().put("view", this.viewApi);
            this.viewApi.setExecution(ex);
            return ex;
        }
    }

    private static class Layouting
    extends DiagramCacheTask {
        HierarchicalLayoutManager manager;
        HierarchicalClusterLayoutManager clusterManager;

        @Override
        public void cancel() {
            super.cancel();
            if (this.manager != null) {
                this.manager.cancel();
            }
            if (this.clusterManager != null) {
                this.clusterManager.cancel();
            }
        }

        public Layouting(Diagram baseDiagram, DiagramViewModel model, DiagramCacheUpdater updater) {
            super(baseDiagram, model, updater);
        }

        @Override
        protected void execute() {
            LayoutSettings.LayoutSettingBean layoutSettings = this.model.getLayoutSetting();
            if (this.model.getHiddenGraphNodes().isEmpty() || ((Boolean)layoutSettings.get(Boolean.class, "STABILIZED_LAYOUT")).booleanValue()) {
                for (Figure f : this.outputDiagram.getFigures()) {
                    f.setVisible(true);
                    f.setBoundary(false);
                }
                for (Block b : this.outputDiagram.getBlocks()) {
                    b.setVisible(true);
                }
            } else {
                return;
            }
            HashSet figures = new HashSet(this.outputDiagram.getFigures());
            HashSet edges = new HashSet(this.outputDiagram.getConnections());
            if (this.cancelled()) {
                return;
            }
            LayoutGraph graph = new LayoutGraph(edges, figures);
            if (this.model.getShowBlocks()) {
                this.clusterManager = new HierarchicalClusterLayoutManager(HierarchicalLayoutManager.Combine.SAME_OUTPUTS, layoutSettings);
                this.clusterManager.getManager().setMaxLayerLength(((Integer)layoutSettings.get(Integer.class, "MAX_BLOCK_LAYER_LENGTH")).intValue());
                this.clusterManager.getSubManager().setMaxLayerLength(((Integer)layoutSettings.get(Integer.class, "MAX_LAYER_LENGTH")).intValue());
                this.clusterManager.doLayout(graph);
            } else {
                this.manager = new HierarchicalLayoutManager(HierarchicalLayoutManager.Combine.SAME_OUTPUTS, layoutSettings);
                this.manager.setMaxLayerLength(((Integer)layoutSettings.get(Integer.class, "MAX_LAYER_LENGTH")).intValue());
                this.manager.doLayout(graph);
            }
            if (this.cancelled()) {
                return;
            }
            this.outputDiagram.setSize(graph.getSize());
            LOG.log(Level.FINE, "outputDiagram figure size: {0}", this.outputDiagram.getFigures().size());
        }
    }
}

