/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.view.impl;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import jdk.graal.compiler.graphio.parsing.model.ChangedEvent;
import jdk.graal.compiler.graphio.parsing.model.ChangedListener;
import org.graalvm.visualizer.filter.CustomFilter;
import org.graalvm.visualizer.filter.Filter;
import org.graalvm.visualizer.filter.FilterChain;
import org.graalvm.visualizer.filter.FilterSequence;
import org.graalvm.visualizer.script.ScriptEnvironment;
import org.graalvm.visualizer.util.ListenerSupport;

public class Filters {
    private static final Logger LOG = Logger.getLogger(Filters.class.getName());
    private FilterSequence filterChain;
    private final List<Filter> scriptFilters = new ArrayList<Filter>();
    private ScriptEnvironment scriptEnvironment;
    private FiltersSnapshot filtersSnapshot;
    private ChangedListener<FilterChain> weakFilterChainChangedListener;
    private final ChangedListener<FilterSequence> filterChainChangedListener = this::filtersChanged;
    private final ChangedEvent<Filters> filtersChanged = new ChangedEvent((Object)this);

    public Filters(FilterSequence filterChain) {
        this.setFilterChainInternal(filterChain);
    }

    public synchronized void setDataInternal(Filters otherFilters) {
        this.setFilterChainInternal((FilterSequence)new FilterChain(otherFilters.getFilterChain()));
        this.setScriptFilters(otherFilters.scriptFilters, otherFilters.scriptEnvironment);
    }

    public void setFilterChain(FilterSequence chain) {
        if (this.setFilterChainInternal(chain)) {
            LOG.log(Level.FINE, "FilterChain was changed.");
            this.filtersChanged(chain);
        }
    }

    private synchronized boolean setFilterChainInternal(FilterSequence chain) {
        assert (chain != null) : "filterChain must never be null";
        if (this.filterChain == chain) {
            return false;
        }
        if (this.filterChain != null) {
            this.filterChain.getChangedEvent().removeListener(this.weakFilterChainChangedListener);
        }
        this.filterChain = chain;
        this.weakFilterChainChangedListener = ListenerSupport.addWeakListener(this.filterChainChangedListener, (ChangedEvent)this.filterChain.getChangedEvent());
        return true;
    }

    public void setScriptFilter(Filter scriptFilter, ScriptEnvironment env, boolean append) {
        if (this.setScriptFilterInternal(scriptFilter, env, append)) {
            LOG.log(Level.FINE, "CustomScriptFilters changed.");
            this.filtersChanged(null);
        }
    }

    private synchronized boolean setScriptFilterInternal(Filter scriptFilter, ScriptEnvironment env, boolean append) {
        boolean changed = false;
        boolean bl = append = append && (env == this.scriptEnvironment || this.scriptEnvironment == null || env == null);
        if (!append) {
            this.scriptFilters.clear();
            this.scriptEnvironment = null;
            changed = true;
        }
        if (env != null && this.scriptEnvironment == null) {
            this.scriptEnvironment = env;
            changed = true;
        }
        if (scriptFilter != null) {
            this.scriptFilters.add(scriptFilter);
            changed = true;
        }
        return changed;
    }

    private synchronized void setScriptFilters(Collection<Filter> scriptFilters, ScriptEnvironment env) {
        this.scriptFilters.clear();
        this.scriptFilters.addAll(scriptFilters);
        this.scriptEnvironment = env;
        this.filtersSnapshot = null;
    }

    public synchronized List<Filter> getScriptFilters() {
        return Collections.unmodifiableList(new ArrayList<Filter>(this.scriptFilters));
    }

    public synchronized ScriptEnvironment getScriptEnvironment() {
        return this.scriptEnvironment;
    }

    public synchronized FilterSequence getFilterChain() {
        return this.filterChain;
    }

    public ChangedEvent<Filters> getFiltersChangedEvent() {
        return this.filtersChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filtersChanged(FilterSequence fc) {
        Filters filters = this;
        synchronized (filters) {
            if (fc != null) {
                LOG.log(Level.FINE, "FilterChain: {0} changed.", fc);
            } else {
                LOG.log(Level.FINE, "Scripts changed.");
            }
            this.filtersSnapshot = null;
        }
        this.filtersChanged.fire();
    }

    public synchronized void close() {
        this.filterChain.getChangedEvent().removeListener(this.weakFilterChainChangedListener);
    }

    public synchronized List<Filter> getFiltersSnapshot() {
        if (this.filtersSnapshot == null) {
            this.filtersSnapshot = new FiltersSnapshot(this.filterChain, this.scriptFilters, this.scriptEnvironment);
        }
        return this.filtersSnapshot;
    }

    public static class FiltersSnapshot
    extends AbstractList<Filter> {
        private final List<Filter> filters;
        private final ScriptEnvironment scriptEnvironment;
        private final int hash;

        public FiltersSnapshot(FilterSequence filterChain, List<Filter> scriptFilters, ScriptEnvironment scriptEnvironment) {
            this.filters = new ArrayList<Filter>(filterChain.getFilters());
            this.filters.addAll(scriptFilters);
            this.scriptEnvironment = scriptEnvironment;
            this.hash = this.makeHash();
        }

        private int makeHash() {
            int h = Objects.hashCode(this.scriptEnvironment);
            for (Filter f : this.filters) {
                CustomFilter cf = null;
                cf = f instanceof CustomFilter ? (CustomFilter)f : (CustomFilter)f.getLookup().lookup(CustomFilter.class);
                if (cf != null) {
                    h = h * 13 + cf.getCode().hashCode();
                    continue;
                }
                h = h * 13 + f.hashCode();
            }
            return h;
        }

        @Override
        public Filter get(int index) {
            return this.filters.get(index);
        }

        @Override
        public int hashCode() {
            return this.hash;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof FiltersSnapshot)) {
                return false;
            }
            FiltersSnapshot other = (FiltersSnapshot)obj;
            return this.hash == other.hash && this.scriptEnvironment == other.scriptEnvironment && this.filters.equals(other.filters);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("FilterSnapshot(").append(this.scriptEnvironment).append(")[ ");
            for (Filter f : this.filters) {
                sb.append(f).append(" ,");
            }
            sb.append(" ]");
            return sb.toString();
        }

        @Override
        public int size() {
            return this.filters.size();
        }
    }
}

