/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.view.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;
import jdk.graal.compiler.graphio.parsing.model.GraphContainer;
import jdk.graal.compiler.graphio.parsing.model.Group;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import org.graalvm.visualizer.data.services.InputGraphProvider;
import org.graalvm.visualizer.util.RangeSliderModel;
import org.graalvm.visualizer.view.api.DiagramViewer;
import org.graalvm.visualizer.view.api.DiagramViewerLocator;
import org.graalvm.visualizer.view.api.TimelineEvent;
import org.graalvm.visualizer.view.api.TimelineListener;
import org.graalvm.visualizer.view.api.TimelineModel;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;
import org.openide.windows.TopComponent;

public class GraphCoordinator
implements PropertyChangeListener,
TimelineListener {
    private boolean initialized;
    private final Map<TimelineModel, Reference<TopComponent>> openedTimelines = new HashMap<TimelineModel, Reference<TopComponent>>();
    private Set<TimelineModel> timelines = Collections.emptySet();
    private boolean synchronizing;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSynchronizedModel(TimelineModel mdl, TopComponent tc) {
        assert (SwingUtilities.isEventDispatchThread());
        GraphCoordinator graphCoordinator = this;
        synchronized (graphCoordinator) {
            if (this.timelines.isEmpty()) {
                this.timelines = new WeakSet();
            }
            if (this.timelines.add(mdl)) {
                mdl.addTimelineListener((TimelineListener)this);
                this.openedTimelines.put(mdl, new WeakReference<TopComponent>(tc));
            }
        }
        if (!this.initialized) {
            TopComponent.getRegistry().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)TopComponent.getRegistry()));
            this.initialized = true;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("opened".equals(evt.getPropertyName())) {
            this.refreshOpenedComponents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshOpenedComponents() {
        HashSet<TimelineModel> obsolete;
        assert (SwingUtilities.isEventDispatchThread());
        Set tcs = TopComponent.getRegistry().getOpened();
        HashSet<TimelineModel> newModels = new HashSet<TimelineModel>();
        for (TopComponent tc : tcs) {
            TimelineModel viewerModel = (TimelineModel)tc.getLookup().lookup(TimelineModel.class);
            if (viewerModel == null) continue;
            newModels.add(viewerModel);
        }
        GraphCoordinator graphCoordinator = this;
        synchronized (graphCoordinator) {
            obsolete = new HashSet<TimelineModel>(this.timelines);
            obsolete.removeAll(newModels);
            this.timelines.removeAll(obsolete);
            this.openedTimelines.keySet().removeAll(obsolete);
        }
        for (TimelineModel om : obsolete) {
            om.removeTimelineListener((TimelineListener)this);
        }
    }

    public void primaryRangeChanged(TimelineEvent e) {
        this.avoidRecursion(this::primaryRangeChanged0, e);
    }

    void primaryRangeChanged0(TimelineEvent e) {
        assert (SwingUtilities.isEventDispatchThread());
        TimelineModel source = e.getSource();
        RangeSliderModel current = e.getSlider();
        String partition = e.getPartitionType();
        DiagramViewerLocator mgr = (DiagramViewerLocator)Lookup.getDefault().lookup(DiagramViewerLocator.class);
        Group g = source.getPrimaryPartition().getContentOwner();
        ArrayList viewers = new ArrayList(mgr.find(g));
        Iterator it = viewers.iterator();
        while (it.hasNext()) {
            TimelineModel match;
            DiagramViewer vwr = (DiagramViewer)it.next();
            TopComponent tc = (TopComponent)vwr.getLookup().lookup(TopComponent.class);
            if (tc == null || !Objects.equals((match = (TimelineModel)tc.getLookup().lookup(TimelineModel.class)).getPrimaryType(), partition)) continue;
            it.remove();
        }
        if (viewers.isEmpty()) {
            return;
        }
        String n1 = (String)current.getPositions().get(current.getFirstPosition());
        String n2 = (String)current.getPositions().get(current.getSecondPosition());
        for (DiagramViewer vwr : viewers) {
            TimelineModel tm = vwr.getModel().getTimeline();
            RangeSliderModel mdl = tm.getPartitionRange(partition);
            if (mdl == null) continue;
            int p1 = mdl.getPositions().indexOf(n1);
            int p2 = mdl.getPositions().indexOf(n2);
            if (p1 == -1 || p2 == -1) continue;
            mdl.setPositions(p1, p2);
            break;
        }
    }

    public void partitionsChanged(TimelineEvent e) {
    }

    private InputGraph getGraphInstance(GraphContainer c, int pos) {
        if (pos <= 0 || pos >= c.getGraphsCount()) {
            return null;
        }
        return (InputGraph)c.getGraphs().get(pos);
    }

    private InputGraph getGraphInstance(TimelineModel model, String type, int pos) {
        RangeSliderModel slider = model.getPartitionRange(type);
        if (pos == -1) {
            return null;
        }
        return model.findGraph(slider, pos);
    }

    public void rangeChanged(TimelineEvent e) {
        this.avoidRecursion(this::rangeChanged0, e);
    }

    private void avoidRecursion(Consumer<TimelineEvent> c, TimelineEvent e) {
        if (this.synchronizing) {
            return;
        }
        this.synchronizing = true;
        try {
            c.accept(e);
        }
        finally {
            this.synchronizing = false;
        }
    }

    private void rangeChanged0(TimelineEvent e) {
        assert (SwingUtilities.isEventDispatchThread());
        TimelineModel source = e.getSource();
        RangeSliderModel current = e.getSlider();
        String partition = e.getPartitionType();
        int oldFirstPos = e.getFirstGraph();
        int oldSecondPos = e.getSecondGraph();
        InputGraph oldFirst = this.getGraphInstance(source, partition, oldFirstPos);
        InputGraph oldSecond = this.getGraphInstance(source, partition, oldSecondPos);
        InputGraph first = this.getGraphInstance(source, partition, current.getFirstPosition());
        InputGraph second = this.getGraphInstance(source, partition, current.getSecondPosition());
        InputGraph anchor = null;
        if (oldFirst != null) {
            anchor = oldFirst;
        } else if (oldSecond != null) {
            anchor = oldSecond;
        }
        DiagramViewerLocator mgr = (DiagramViewerLocator)Lookup.getDefault().lookup(DiagramViewerLocator.class);
        ArrayList viewers = Collections.emptyList();
        DiagramViewer candidate = null;
        DiagramViewer secondCandidate = null;
        DiagramViewer thirdCandidate = null;
        RangeSliderModel myRange = source.getPrimaryRange();
        if (anchor != null) {
            viewers = mgr.find(anchor);
        }
        if (viewers.isEmpty()) {
            if (first != null) {
                anchor = first;
            } else if (second != null) {
                anchor = second;
            }
            if (anchor != null) {
                viewers = mgr.findCompatible(anchor);
            }
        }
        if (viewers.isEmpty()) {
            Group g = source.getPrimaryPartition().getContentOwner();
            viewers = new ArrayList(mgr.find(g));
            DiagramViewer exclude = null;
            for (DiagramViewer vwr : viewers) {
                TimelineModel match = vwr.getModel().getTimeline();
                if (match != source) continue;
                exclude = vwr;
                break;
            }
            if (exclude != null) {
                viewers.remove(exclude);
            }
        }
        for (DiagramViewer v : viewers) {
            TimelineModel tv = v.getModel().getTimeline();
            if (tv == null) continue;
            RangeSliderModel primRange = tv.getPrimaryRange();
            RangeSliderModel matchRange = tv.getPartitionRange(source.getPrimaryType());
            if (thirdCandidate == null) {
                thirdCandidate = v;
            }
            if (primRange.getFirstPosition() != oldFirstPos || primRange.getSecondPosition() != oldSecondPos) continue;
            if (secondCandidate == null) {
                secondCandidate = v;
            }
            if (matchRange == null || matchRange.getFirstPosition() != myRange.getFirstPosition() || matchRange.getSecondPosition() != myRange.getSecondPosition()) continue;
            candidate = v;
            break;
        }
        if (candidate == null) {
            candidate = secondCandidate;
        }
        if (candidate == null) {
            candidate = thirdCandidate;
        }
        if (candidate != null) {
            GraphContainer targetC = candidate.getModel().getContainer();
            RangeSliderModel targetM = candidate.getModel().getTimeline().getPrimaryRange();
            InputGraph g1 = this.getGraphInstance(targetC, current.getFirstPosition());
            InputGraph g2 = this.getGraphInstance(targetC, current.getSecondPosition());
            int pos1 = targetC.getGraphs().indexOf(g1);
            int pos2 = targetC.getGraphs().indexOf(g2);
            if (pos1 == -1) {
                pos1 = pos2;
            }
            if (pos1 != -1) {
                targetM.setPositions(pos1, pos2);
                TopComponent tc = (TopComponent)candidate.getLookup().lookup(TopComponent.class);
                if (tc != null) {
                    tc.requestVisible();
                }
            }
        } else {
            class Initializer
            implements BiConsumer<Boolean, InputGraphProvider> {
                Initializer() {
                }

                @Override
                public void accept(Boolean t, InputGraphProvider u) {
                }
            }
            mgr.view((BiConsumer)new Initializer(), first, false, false, new Object[0]);
        }
    }

    public void rangePropertyChanged(TimelineEvent e) {
    }
}

