/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.view.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import jdk.graal.compiler.graphio.parsing.model.ChangedEvent;
import jdk.graal.compiler.graphio.parsing.model.ChangedListener;
import jdk.graal.compiler.graphio.parsing.model.GraphContainer;
import jdk.graal.compiler.graphio.parsing.model.Group;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import org.graalvm.visualizer.util.ListenerSupport;

public class GraphTypeContainer
implements GraphContainer {
    private final GraphContainer delegate;
    private final Predicate<InputGraph> acceptor;
    private final ChangedEvent<GraphContainer> changeEvent = new ChangedEvent((Object)this);
    private final String type;
    private final ChangedListener<GraphContainer> refireListener = e -> {
        this.filteredGraphs = null;
        this.changeEvent.fire();
    };
    private volatile List<InputGraph> filteredGraphs;

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + Objects.hashCode(this.delegate);
        hash = 97 * hash + Objects.hashCode(this.acceptor);
        hash = 97 * hash + Objects.hashCode(this.type);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GraphTypeContainer other = (GraphTypeContainer)obj;
        if (!Objects.equals(this.type, other.type)) {
            return false;
        }
        if (!Objects.equals(this.delegate, other.delegate)) {
            return false;
        }
        return Objects.equals(this.acceptor, other.acceptor);
    }

    public GraphTypeContainer(GraphContainer delegate, String graphType, Predicate<InputGraph> acceptor) {
        this.delegate = delegate;
        this.type = graphType;
        this.acceptor = acceptor;
        ListenerSupport.addWeakListener(this.refireListener, (ChangedEvent)this.delegate.getChangedEvent());
    }

    public Group getContentOwner() {
        return this.delegate.getContentOwner();
    }

    public ChangedEvent<GraphContainer> getChangedEvent() {
        return this.changeEvent;
    }

    public boolean accept(InputGraph g) {
        if (this.acceptor != null) {
            return this.acceptor.test(g);
        }
        return this.type == null || this.type.equals(g.getGraphType());
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.getContentOwner().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<InputGraph> findGraphs() {
        List<InputGraph> res = this.filteredGraphs;
        if (res != null) {
            return res;
        }
        ArrayList<InputGraph> graphs = new ArrayList<InputGraph>(this.delegate.getGraphs());
        Iterator itg = graphs.iterator();
        while (itg.hasNext()) {
            InputGraph g = (InputGraph)itg.next();
            if (this.accept(g)) continue;
            itg.remove();
        }
        GraphTypeContainer graphTypeContainer = this;
        synchronized (graphTypeContainer) {
            if (this.filteredGraphs == null) {
                this.filteredGraphs = graphs;
            }
            return graphs;
        }
    }

    public int getGraphsCount() {
        return this.findGraphs().size();
    }

    public Set<Integer> getChildNodeIds() {
        return this.getGraphs().parallelStream().flatMap(e -> e.getNodeIds().stream()).collect(Collectors.toSet());
    }

    public Set<InputNode> getChildNodes() {
        return this.getGraphs().parallelStream().flatMap(e -> e.getNodes().stream()).collect(Collectors.toSet());
    }

    public List<InputGraph> getGraphs() {
        return Collections.unmodifiableList(this.findGraphs());
    }

    public InputGraph getLastGraph() {
        List<InputGraph> gs = this.findGraphs();
        return gs.isEmpty() ? null : gs.get(gs.size() - 1);
    }

    public boolean isNodeChanged(InputGraph base, InputGraph to, int nodeId) {
        List<InputGraph> graphs = this.getGraphs();
        int fromIndex = graphs.indexOf(base);
        int toIndex = graphs.indexOf(to);
        assert (fromIndex != -1 && toIndex >= fromIndex);
        if (fromIndex == toIndex) {
            return false;
        }
        for (int i = fromIndex + 1; i <= toIndex; ++i) {
            InputGraph g = graphs.get(i);
            if (g.isDuplicate() || !g.isNodeChanged(nodeId)) continue;
            return true;
        }
        return false;
    }
}

