/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.view.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jdk.graal.compiler.graphio.parsing.model.FolderElement;
import jdk.graal.compiler.graphio.parsing.model.GraphClassifier;
import jdk.graal.compiler.graphio.parsing.model.GraphContainer;
import jdk.graal.compiler.graphio.parsing.model.Group;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import org.graalvm.visualizer.data.services.InputGraphProvider;
import org.graalvm.visualizer.graph.Figure;
import org.graalvm.visualizer.view.EditorTopComponent;
import org.graalvm.visualizer.view.api.DiagramViewer;
import org.graalvm.visualizer.view.api.DiagramViewerLocator;
import org.graalvm.visualizer.view.api.TimelineModel;
import org.graalvm.visualizer.view.impl.Bundle;
import org.graalvm.visualizer.view.impl.TimelineModelImpl;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

public class GraphViewerImplementation
implements DiagramViewerLocator,
PropertyChangeListener {
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>(2);
    private List<Reference<TopComponent>> viewers = new ArrayList<Reference<TopComponent>>(2);
    private Reference<InputGraphProvider> lastActive = new WeakReference<Object>(null);
    private final PropertyChangeListener listener = evt -> {
        if ("activatedNodes".equals(evt.getPropertyName()) || "displayName".equals(evt.getPropertyName())) {
            this.fireChangeEvent();
        }
    };

    public GraphViewerImplementation() {
        TopComponent.getRegistry().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)TopComponent.getRegistry()));
        this.lastActive = new WeakReference<Object>(null);
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateLastActiveViewer();
        } else {
            SwingUtilities.invokeLater(this::updateLastActiveViewer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateViewers(TopComponent toFront) {
        TopComponent.Registry reg = TopComponent.getRegistry();
        TopComponent active = this.filter(reg.getActivated());
        HashSet<TopComponent> all = new HashSet<TopComponent>();
        Reference refHead = null;
        boolean changed = false;
        for (TopComponent tc : reg.getOpened()) {
            if ((tc = this.filter(tc)) == null) continue;
            all.add(tc);
        }
        GraphViewerImplementation graphViewerImplementation = this;
        synchronized (graphViewerImplementation) {
            Iterator<Reference<TopComponent>> itr = this.viewers.iterator();
            while (itr.hasNext()) {
                Reference<TopComponent> obj = itr.next();
                TopComponent tc = obj.get();
                if (tc == null || !all.contains(tc)) {
                    itr.remove();
                    changed = true;
                    continue;
                }
                if (tc == active && refHead == null) {
                    refHead = obj;
                } else if (tc == toFront) {
                    refHead = new WeakReference<TopComponent>(tc);
                }
                all.remove(tc);
            }
            for (TopComponent tc : all) {
                WeakReference<TopComponent> rtc = new WeakReference<TopComponent>(tc);
                if (tc == active || tc == toFront) {
                    refHead = rtc;
                } else {
                    this.viewers.add(0, rtc);
                }
                changed = true;
            }
            if (refHead != null) {
                if (!this.viewers.isEmpty() && this.viewers.get(0) != refHead) {
                    changed = true;
                }
                this.viewers.remove(refHead);
                this.viewers.add(0, refHead);
            }
        }
        if (changed) {
            this.fireChangeEvent();
        }
    }

    private TopComponent filter(TopComponent tc) {
        if (tc == null) {
            return null;
        }
        InputGraphProvider p = (InputGraphProvider)tc.getLookup().lookup(InputGraphProvider.class);
        return p != null ? tc : null;
    }

    private void updateLastActiveViewer() {
        this.updateViewers(TopComponent.getRegistry().getActivated());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener l) {
        GraphViewerImplementation graphViewerImplementation = this;
        synchronized (graphViewerImplementation) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener l) {
        GraphViewerImplementation graphViewerImplementation = this;
        synchronized (graphViewerImplementation) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeEvent() {
        ChangeListener[] ll;
        GraphViewerImplementation graphViewerImplementation = this;
        synchronized (graphViewerImplementation) {
            if (this.listeners.isEmpty()) {
                return;
            }
            ll = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
        }
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : ll) {
            l.stateChanged(e);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("tcOpened".equals(evt.getPropertyName()) && evt.getNewValue() instanceof EditorTopComponent) {
            ((EditorTopComponent)evt.getNewValue()).addPropertyChangeListener(this.listener);
            this.updateViewers((TopComponent)evt.getNewValue());
        }
        if ("tcClosed".equals(evt.getPropertyName()) && evt.getNewValue() instanceof EditorTopComponent) {
            ((EditorTopComponent)evt.getNewValue()).removePropertyChangeListener(this.listener);
            this.updateViewers(null);
        }
        if ("activated".equals(evt.getPropertyName())) {
            this.updateLastActiveViewer();
        }
    }

    public void view(BiConsumer<Boolean, InputGraphProvider> viewerInit, InputGraph graph, boolean clone, boolean activate, Object ... parameters) {
        Iterator<DiagramViewer> iterator;
        List<DiagramViewer> viewers;
        if (!clone && !(viewers = this.findCompatible(graph)).isEmpty() && (iterator = viewers.iterator()).hasNext()) {
            DiagramViewer v = iterator.next();
            TopComponent tc = (TopComponent)v.getLookup().lookup(TopComponent.class);
            GraphViewerImplementation.initAndRunWithProgress(graph, () -> {
                v.getModel().selectGraph(graph);
                if (tc != null) {
                    if (activate) {
                        tc.requestActive();
                    } else {
                        tc.requestVisible();
                    }
                }
                if (viewerInit != null) {
                    viewerInit.accept(false, (InputGraphProvider)v);
                }
            });
            return;
        }
        GraphViewerImplementation.initAndRunWithProgress(graph, () -> this.openSimple(graph, activate, viewerInit));
    }

    static TimelineModel createTimeline(InputGraph graph) {
        String type = GraphViewerImplementation.classifyGraphType(graph);
        TimelineModelImpl mdl = new TimelineModelImpl(graph.getGroup(), GraphClassifier.DEFAULT_CLASSIFIER, type);
        return mdl;
    }

    private void openSimple(InputGraph graph, boolean activate, BiConsumer<Boolean, InputGraphProvider> viewerInit) {
        TimelineModel mdl = GraphViewerImplementation.createTimeline(graph);
        EditorTopComponent tc = new EditorTopComponent(graph, mdl);
        if (viewerInit != null) {
            viewerInit.accept(true, (InputGraphProvider)tc.getViewer());
        }
        tc.open();
        if (activate) {
            tc.requestActive();
        }
        tc.requestVisible();
        tc.getModel().withDiagramToView(dg -> {
            InputGraph g = dg.getGraph();
            ArrayList ids = new ArrayList(g.getNodeIds());
            Collections.sort(ids);
            Iterator iterator = ids.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                Figure f = dg.getFigureById(i);
                if (f == null || !f.isVisible()) continue;
                tc.whenReady().execute(() -> tc.setSelectedFigures(Collections.singletonList(f)));
                break;
            }
        });
    }

    static void initAndRunWithProgress(InputGraph graph, Runnable swingRunnable) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> GraphViewerImplementation.initAndRunWithProgress(graph, swingRunnable));
            return;
        }
        if (graph instanceof Group.LazyContent) {
            GraphViewerImplementation.processLargeGraph(graph, swingRunnable);
        } else {
            swingRunnable.run();
        }
    }

    private static void processLargeGraph(InputGraph graph, final Runnable runNext) {
        final Group.LazyContent lazy = (Group.LazyContent)graph;
        final String title = Bundle.MSG_PrepareGraph(graph.getName());
        class F
        implements Group.Feedback,
        Cancellable,
        Runnable {
            private boolean start;
            private final ProgressHandle ph;
            private final AtomicBoolean cancelled;
            private volatile Future waitFor;
            private int lastTotal;

            F() {
                this.ph = ProgressHandle.createHandle((String)title, (Cancellable)this);
                this.cancelled = new AtomicBoolean();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void reportProgress(int workDone, int totalWork, String description) {
                F f = this;
                synchronized (f) {
                    if (!this.start) {
                        if (totalWork == -1) {
                            this.ph.start();
                        } else {
                            this.ph.start(totalWork);
                        }
                        this.start = true;
                    }
                }
                if (totalWork != this.lastTotal) {
                    this.ph.switchToDeterminate(totalWork);
                }
                if (description != null) {
                    if (totalWork > 0) {
                        this.ph.progress(description, workDone);
                    } else {
                        this.ph.progress(description);
                    }
                } else if (totalWork > 0) {
                    this.ph.progress(workDone);
                }
                this.lastTotal = totalWork;
            }

            public boolean isCancelled() {
                return this.cancelled.get();
            }

            public synchronized void finish() {
                this.ph.finish();
            }

            public boolean cancel() {
                this.cancelled.set(true);
                this.waitFor.cancel(true);
                return true;
            }

            @Override
            public void run() {
                this.waitFor = lazy.completeContents((Group.Feedback)this);
                try {
                    this.waitFor.get();
                }
                catch (InterruptedException | CancellationException ex) {
                    return;
                }
                catch (ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                if (!this.cancelled.get()) {
                    SwingUtilities.invokeLater(runNext);
                }
            }

            public void reportError(List<FolderElement> parents, List<String> parentNames, String name, String errorMessage) {
            }
        }
        F feedback = new F();
        BaseProgressUtils.runOffEventThreadWithProgressDialog((Runnable)feedback, (String)title, (ProgressHandle)feedback.ph, (boolean)false, (int)200, (int)3000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiagramViewer getActiveViewer() {
        GraphViewerImplementation graphViewerImplementation = this;
        synchronized (graphViewerImplementation) {
            if (this.viewers.isEmpty()) {
                return null;
            }
            for (Reference<TopComponent> tcs : this.viewers) {
                DiagramViewer res;
                TopComponent tc = tcs.get();
                if (tc == null || (res = (DiagramViewer)tc.getLookup().lookup(DiagramViewer.class)) == null) continue;
                return res;
            }
        }
        return null;
    }

    public InputGraph getActiveGraph() {
        DiagramViewer vwr = this.getActiveViewer();
        return vwr != null ? vwr.getGraph() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DiagramViewer> getViewers() {
        ArrayList<DiagramViewer> result;
        boolean update = false;
        GraphViewerImplementation graphViewerImplementation = this;
        synchronized (graphViewerImplementation) {
            result = new ArrayList<DiagramViewer>(this.viewers.size());
            for (Reference<TopComponent> r : this.viewers) {
                TopComponent tc = r.get();
                if (tc == null) {
                    update = true;
                    continue;
                }
                DiagramViewer vwr = (DiagramViewer)tc.getLookup().lookup(DiagramViewer.class);
                result.add(vwr);
            }
        }
        if (update) {
            this.updateViewers(null);
        }
        return result;
    }

    protected Stream<DiagramViewer> viewers() {
        return this.getViewers().stream();
    }

    public List<DiagramViewer> find(Group g) {
        return this.viewers().filter((? super T v) -> v.getModel().getContainer().getContentOwner() == g).collect(Collectors.toList());
    }

    public List<DiagramViewer> find(InputGraph g) {
        return this.viewers().filter((? super T v) -> v.getModel().getGraphToView() == g).collect(Collectors.toList());
    }

    public List<DiagramViewer> findCompatible(InputGraph g) {
        String gtype = GraphViewerImplementation.classifyGraphType(g);
        Group gg = g.getGroup();
        if (gtype == null) {
            return this.find(gg);
        }
        return this.viewers().filter((? super T v) -> {
            GraphContainer c = v.getModel().getContainer();
            if (c.getContentOwner() != gg) {
                return false;
            }
            return c == c.getContentOwner() || c.accept(g);
        }).collect(Collectors.toList());
    }

    private static String classifyGraphType(InputGraph graph) {
        return graph.getGraphType();
    }
}

