/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.view.widgets;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.graalvm.visualizer.graph.Connection;
import org.graalvm.visualizer.graph.Figure;
import org.graalvm.visualizer.graph.InputSlot;
import org.graalvm.visualizer.graph.OutputSlot;
import org.graalvm.visualizer.util.StringUtils;
import org.graalvm.visualizer.view.DiagramScene;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.action.SelectProvider;
import org.netbeans.api.visual.animator.SceneAnimator;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public final class LineWidget
extends Widget
implements PopupMenuProvider {
    public static final int BORDER = 5;
    public static final int ARROW_SIZE = 6;
    public static final int BOLD_ARROW_SIZE = 7;
    public static final int HOVER_ARROW_SIZE = 8;
    public static final int BOLD_STROKE_WIDTH = 2;
    public static final int HOVER_STROKE_WIDTH = 3;
    private static final double ZOOM_FACTOR = 0.1;
    private OutputSlot outputSlot;
    private DiagramScene scene;
    private List<Connection> connections;
    private Point from;
    private Point to;
    private Rectangle clientArea;
    private Color color = Color.BLACK;
    private LineWidget predecessor;
    private List<LineWidget> successors;
    private boolean highlighted;
    private boolean popupVisible;
    private boolean isBold;
    private boolean isDashed;

    public LineWidget(DiagramScene scene, OutputSlot s, List<Connection> connections, Point from, Point to, LineWidget predecessor, SceneAnimator animator, boolean isBold, boolean isDashed) {
        super((Scene)scene);
        this.scene = scene;
        this.outputSlot = s;
        this.connections = connections;
        this.predecessor = predecessor;
        this.successors = new ArrayList<LineWidget>();
        if (predecessor != null) {
            predecessor.addSuccessor(this);
        }
        this.isBold = isBold;
        this.isDashed = isDashed;
        this.setPoints(from, to);
        if (connections.size() > 0) {
            this.color = connections.get(0).getColor();
        }
        this.setToolTipText("<HTML>" + this.generateToolTipText(this.connections) + "</HTML>");
        this.setCheckClipping(true);
        this.getActions().addAction(ActionFactory.createPopupMenuAction((PopupMenuProvider)this));
        if (animator == null) {
            this.setBackground(this.color);
        } else {
            this.setBackground(Color.WHITE);
            animator.animateBackgroundColor((Widget)this, this.color);
        }
        this.getActions().addAction(ActionFactory.createSelectAction((SelectProvider)new SelectProvider(){

            public boolean isAimingAllowed(Widget arg0, Point arg1, boolean arg2) {
                return true;
            }

            public boolean isSelectionAllowed(Widget arg0, Point arg1, boolean arg2) {
                return true;
            }

            public void select(Widget arg0, Point arg1, boolean arg2) {
                HashSet<Figure> set = new HashSet<Figure>();
                set.add(LineWidget.this.outputSlot.getFigure());
                for (Connection c : LineWidget.this.connections) {
                    set.add(c.getInputSlot().getFigure());
                }
                LineWidget.this.scene.setSelectedObjects(set);
            }
        }));
    }

    public void setPoints(Point from, Point to) {
        int tmp;
        if (this.from != null && from.equals(this.from) && to.equals(this.to)) {
            return;
        }
        this.from = from;
        this.to = to;
        int minX = from.x;
        int minY = from.y;
        int maxX = to.x;
        int maxY = to.y;
        if (minX > maxX) {
            tmp = minX;
            minX = maxX;
            maxX = tmp;
        }
        if (minY > maxY) {
            tmp = minY;
            minY = maxY;
            maxY = tmp;
        }
        this.clientArea = new Rectangle(minX, minY, maxX - minX + 1, maxY - minY + 1);
        this.clientArea.grow(5, 5);
        this.revalidate();
    }

    private String generateToolTipText(List<Connection> conn) {
        StringBuilder sb = new StringBuilder();
        for (Connection c : conn) {
            sb.append(StringUtils.escapeHTML((String)c.getToolTipText())).append("<br>");
        }
        return sb.toString();
    }

    public Point getFrom() {
        return this.from;
    }

    public Point getTo() {
        return this.to;
    }

    private void addSuccessor(LineWidget widget) {
        if (!this.successors.contains((Object)widget)) {
            this.successors.add(widget);
        }
    }

    public void setPredecessor(LineWidget predecessor) {
        if (this.predecessor != predecessor) {
            if (this.predecessor != null) {
                this.predecessor.successors.remove((Object)this);
            }
            this.predecessor = predecessor;
            if (predecessor != null) {
                predecessor.addSuccessor(this);
            }
        }
    }

    protected Rectangle calculateClientArea() {
        return this.clientArea;
    }

    protected void paintWidget() {
        if (this.scene.getZoomFactor() < 0.1) {
            return;
        }
        Graphics2D g = this.getScene().getGraphics();
        g.setPaint(this.getBackground());
        float width = 1.0f;
        if (this.isBold) {
            width = 2.0f;
        }
        if (this.highlighted || this.popupVisible) {
            width = 3.0f;
        }
        Stroke oldStroke = g.getStroke();
        if (this.isDashed) {
            float[] dashPattern = new float[]{5.0f, 5.0f, 5.0f, 5.0f};
            g.setStroke(new BasicStroke(width, 0, 0, 10.0f, dashPattern, 0.0f));
        } else {
            g.setStroke(new BasicStroke(width));
        }
        g.drawLine(this.from.x, this.from.y, this.to.x, this.to.y);
        boolean sameFrom = false;
        boolean sameTo = this.successors.isEmpty();
        for (LineWidget w : this.successors) {
            if (!w.getFrom().equals(this.getTo())) continue;
            sameTo = true;
            break;
        }
        if (this.predecessor == null || this.predecessor.getTo().equals(this.getFrom())) {
            sameFrom = true;
        }
        int size = 6;
        if (this.isBold) {
            size = 7;
        }
        if (this.highlighted || this.popupVisible) {
            size = 8;
        }
        this.drawArrows(g, size, !sameFrom, !sameTo);
        g.setStroke(oldStroke);
    }

    private void drawArrows(Graphics2D g, int size, boolean drawFrom, boolean drawTo) {
        if (drawFrom || drawTo) {
            Polygon arrow = new Polygon(new int[]{-size / 2, size / 2, 0}, new int[]{-size / 2, -size / 2, size / 2}, 3);
            if (drawFrom) {
                assert (this.predecessor != null);
                arrow.translate(this.from.x, this.from.y);
                g.fillPolygon(arrow);
            } else if (drawTo) {
                assert (this.successors.size() > 0);
                arrow.translate(this.to.x, this.to.y);
                g.fillPolygon(arrow);
            }
        }
    }

    private void setHighlighted(boolean b) {
        this.highlighted = b;
        HashSet highlightedObjects = new HashSet(this.scene.getHighlightedObjects());
        HashSet<Object> highlightedObjectsChange = new HashSet<Object>();
        highlightedObjectsChange.add(this.outputSlot.getFigure());
        highlightedObjectsChange.add(this.outputSlot);
        for (Connection c : this.connections) {
            highlightedObjectsChange.add(c.getInputSlot().getFigure());
            highlightedObjectsChange.add(c.getInputSlot());
        }
        if (b) {
            highlightedObjects.addAll(highlightedObjectsChange);
        } else {
            highlightedObjects.removeAll(highlightedObjectsChange);
        }
        this.scene.setHighlightedObjects(highlightedObjects);
        this.revalidate(true);
    }

    private void setPopupVisible(boolean b) {
        this.popupVisible = b;
        this.revalidate(true);
    }

    public boolean isHitAt(Point localPoint) {
        return Line2D.ptLineDistSq(this.from.x, this.from.y, this.to.x, this.to.y, localPoint.x, localPoint.y) <= 25.0;
    }

    protected void notifyStateChanged(ObjectState previousState, ObjectState state) {
        if (previousState.isHovered() != state.isHovered()) {
            this.setRecursiveHighlighted(state.isHovered());
        }
    }

    private void setRecursiveHighlighted(boolean b) {
        LineWidget cur = this.predecessor;
        while (cur != null) {
            cur.setHighlighted(b);
            cur = cur.predecessor;
        }
        this.highlightSuccessors(b);
        this.setHighlighted(b);
    }

    private void highlightSuccessors(boolean b) {
        for (LineWidget s : this.successors) {
            s.setHighlighted(b);
            s.highlightSuccessors(b);
        }
    }

    private void setRecursivePopupVisible(boolean b) {
        LineWidget cur = this.predecessor;
        while (cur != null) {
            cur.setPopupVisible(b);
            cur = cur.predecessor;
        }
        this.popupVisibleSuccessors(b);
        this.setPopupVisible(b);
    }

    private void popupVisibleSuccessors(boolean b) {
        for (LineWidget s : this.successors) {
            s.setPopupVisible(b);
            s.popupVisibleSuccessors(b);
        }
    }

    public JPopupMenu getPopupMenu(Widget widget, Point localLocation) {
        JPopupMenu menu = new JPopupMenu();
        menu.add(this.scene.createGotoAction(this.outputSlot.getFigure()));
        menu.addSeparator();
        for (Connection c : this.connections) {
            InputSlot s = c.getInputSlot();
            menu.add(this.scene.createGotoAction(s.getFigure()));
        }
        final LineWidget w = this;
        menu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                w.setRecursivePopupVisible(true);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                w.setRecursivePopupVisible(false);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        return menu;
    }
}

