/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source;

import java.util.Objects;
import org.graalvm.visualizer.source.FileKey;
import org.graalvm.visualizer.source.SpecificLocationInfo;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public final class Location {
    private final String originSpec;
    private FileKey file;
    private final int originLine;
    private final int startOffset;
    private final int endOffset;
    private Lookup lookup = Lookup.EMPTY;
    private Location parent;
    private SpecificLocationInfo info;
    private short frameFrom = (short)-1;
    private short frameTo = (short)-1;
    int cachedHash = -1;

    public Location(String originSpec, FileKey originFile, int originLine, int startOffset, int endOffset, Location nested, int frame, int frameTo) {
        this.file = originFile;
        this.originSpec = originSpec;
        this.originLine = originLine;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.frameFrom = (short)frame;
        this.frameTo = (short)(frameTo == -1 ? frame : frameTo);
    }

    public FileKey getFile() {
        return this.file;
    }

    public String getFileName() {
        return this.file.getFileSpec();
    }

    public String getOriginSpec() {
        return this.originSpec;
    }

    public boolean isResolved() {
        return this.file.isResolved();
    }

    public String getMimeType() {
        return this.file.getMime();
    }

    public FileObject getOriginFile() {
        return this.file.getResolvedFile();
    }

    public int getLine() {
        return this.originLine;
    }

    public int[] getOffsetsOrNull() {
        if (this.startOffset >= 0 && this.endOffset > this.startOffset) {
            return new int[]{this.startOffset, this.endOffset};
        }
        return null;
    }

    Lookup getLookup() {
        return this.lookup;
    }

    public int hashCode() {
        if (this.cachedHash != -1) {
            return this.cachedHash;
        }
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.originSpec);
        hash = 89 * hash + this.originLine;
        hash = 89 * hash + Objects.hashCode(this.file);
        hash = 89 * hash + Objects.hashCode(this.parent);
        hash = 37 * hash + this.startOffset;
        this.cachedHash = (hash = 37 * hash + this.endOffset) == -1 ? 7 : hash;
        return this.cachedHash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Location other = (Location)obj;
        if (this.originLine != other.originLine) {
            return false;
        }
        if (this.startOffset != other.startOffset) {
            return false;
        }
        if (this.endOffset != other.endOffset) {
            return false;
        }
        if (this.parent != other.parent) {
            return false;
        }
        if (!Objects.equals(this.originSpec, other.originSpec)) {
            return false;
        }
        return Objects.equals(this.file, other.file);
    }

    void attach(SpecificLocationInfo info) {
        this.info = info;
    }

    public <T extends SpecificLocationInfo> boolean isOfKind(Class<T> clazz) {
        return this.getSpecificInfo(clazz) != null;
    }

    public <T extends SpecificLocationInfo> T getSpecificInfo(Class<T> clazz) {
        if (clazz.isInstance(this.info)) {
            return (T)this.info;
        }
        return (T)((SpecificLocationInfo)this.getLookup().lookup(clazz));
    }

    public Location getParent() {
        return this.parent;
    }

    void setParent(Location parent) {
        this.parent = parent;
    }

    void setFrameRange(short from, short to) {
        assert (to >= from) : "Invalid frame positions";
        this.frameFrom = from;
        this.frameTo = to;
    }

    public short getFrameFrom() {
        return this.frameFrom;
    }

    public short getFrameTo() {
        return this.frameTo;
    }

    public String toString() {
        return "loc[" + this.file + ":" + this.originLine + "info = " + this.info + "]";
    }

    public boolean isNestedIn(Location other) {
        for (Location l = this.parent; l != null; l = l.getParent()) {
            if (!l.equals(other)) continue;
            return true;
        }
        return false;
    }

    public Line line() {
        return new Line(this.file, this.originLine);
    }

    public static int compareLineOnly(Location a, Location b) {
        return a.getLine() - b.getLine();
    }

    public static int compareWithFiles(Location a, Location b) {
        FileObject resA = a.getOriginFile();
        FileObject resB = b.getOriginFile();
        if (resA == null && resB != null) {
            return 1;
        }
        if (resB != null && resA == null) {
            return -1;
        }
        int cmp = resA != null && resB != null ? resA.getPath().compareTo(resB.getPath()) : a.getFileName().compareTo(b.getFileName());
        if (cmp != 0) {
            return cmp;
        }
        return a.getLine() - b.getLine();
    }

    public int compareNesting(Location other) {
        short oF = other.getFrameFrom();
        short oT = other.getFrameTo();
        if (this.frameFrom <= oT && this.frameTo >= oF) {
            return 0;
        }
        return this.frameFrom - oF;
    }

    public static final class Line {
        private final FileKey fk;
        private final int line;

        public Line(FileKey fk, int line) {
            this.fk = fk;
            this.line = line;
        }

        public int hashCode() {
            int hash = 3;
            hash = 61 * hash + Objects.hashCode(this.fk);
            hash = 61 * hash + this.line;
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Line other = (Line)obj;
            if (this.line != other.line) {
                return false;
            }
            return Objects.equals(this.fk, other.fk);
        }
    }
}

