/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.prefs.Preferences;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import org.graalvm.visualizer.source.FileKey;
import org.graalvm.visualizer.source.FileRegistry;
import org.graalvm.visualizer.source.GraphSource;
import org.graalvm.visualizer.source.Location;
import org.graalvm.visualizer.source.NodeLocationEvent;
import org.graalvm.visualizer.source.NodeLocationListener;
import org.graalvm.visualizer.source.NodeStack;
import org.netbeans.api.actions.Openable;
import org.openide.filesystems.FileObject;
import org.openide.util.NbPreferences;
import org.openide.util.WeakListeners;

public class NodeLocationContext {
    public static final String PROP_PREFER_GUEST_LANGUAGE = "preferGuestLanguage";
    public static final String PROP_SELECTED_LANGUAGE = "selectedLanguage";
    private InputGraph graph;
    private GraphSource graphSource;
    private String mimeType;
    private Collection<InputNode> nodes = Collections.emptyList();
    private Collection<InputNode> contextNodes = Collections.emptyList();
    private InputNode currentNode;
    private final Collection<NodeLocationListener> listeners = new ArrayList<NodeLocationListener>();
    private NodeStack.Frame selectedFrame;
    private Map<String, NodeStack.Frame> langFrames = new HashMap<String, NodeStack.Frame>();
    private final PropertyChangeSupport supp = new PropertyChangeSupport(this);
    private boolean preferGuestLanguage;
    private FileRegistry.FileRegistryListener resolveL = new FileRegistry.FileRegistryListener(){

        @Override
        public void filesResolved(FileRegistry.FileRegistryEvent ev) {
            NodeLocationContext.this.fireStackResolved(ev.getResolvedKeys());
        }
    };
    private Preferences prefs = NbPreferences.forModule(NodeLocationContext.class);

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.supp.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.supp.removePropertyChangeListener(listener);
    }

    public boolean isPreferGuestLanguage() {
        return this.preferGuestLanguage;
    }

    public void setPreferGuestLanguage(boolean preferGuestLanguage) {
        boolean ch = this.preferGuestLanguage != preferGuestLanguage;
        this.preferGuestLanguage = preferGuestLanguage;
        if (ch) {
            this.supp.firePropertyChange(PROP_PREFER_GUEST_LANGUAGE, !preferGuestLanguage, preferGuestLanguage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStackResolved(Collection<FileKey> keys) {
        HashSet<InputNode> nodes;
        GraphSource src;
        HashSet<NodeStack.Frame> frames = new HashSet<NodeStack.Frame>();
        NodeLocationContext nodeLocationContext = this;
        synchronized (nodeLocationContext) {
            src = this.getGraphSource();
            nodes = new HashSet<InputNode>(this.nodes);
        }
        if (src == null) {
            return;
        }
        for (InputNode n : nodes) {
            NodeStack st = src.getNodeStack(n);
            if (st == null) continue;
            for (NodeStack.Frame f : st) {
                if (!keys.contains(f.getLocation().getFile())) continue;
                frames.add(f);
            }
        }
        this.fireWithListeners(false, ll -> {
            NodeLocationEvent ev = new NodeLocationEvent(this, frames);
            for (NodeLocationListener l : ll) {
                l.locationsResolved(ev);
            }
        });
    }

    public NodeLocationContext() {
        FileRegistry.getInstance().addFileRegistryListener((FileRegistry.FileRegistryListener)WeakListeners.create(FileRegistry.FileRegistryListener.class, (EventListener)this.resolveL, (Object)FileRegistry.getInstance()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNodeLocationListener(NodeLocationListener l) {
        NodeLocationContext nodeLocationContext = this;
        synchronized (nodeLocationContext) {
            this.listeners.add(l);
        }
    }

    public synchronized InputGraph getGraph() {
        return this.graph;
    }

    public synchronized GraphSource getGraphSource() {
        return this.graphSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNodeLocationListener(NodeLocationListener l) {
        NodeLocationContext nodeLocationContext = this;
        synchronized (nodeLocationContext) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedLanguage(String mime) {
        String oldMime;
        NodeLocationContext nodeLocationContext = this;
        synchronized (nodeLocationContext) {
            if (Objects.equals(this.mimeType, mime)) {
                return;
            }
            oldMime = this.mimeType;
            this.mimeType = mime;
        }
        this.supp.firePropertyChange(PROP_SELECTED_LANGUAGE, oldMime, mime);
    }

    public synchronized String getSelectedLanguage() {
        return this.mimeType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Location> getFileLocations(FileObject f, boolean nodePresent) {
        GraphSource s;
        NodeLocationContext nodeLocationContext = this;
        synchronized (nodeLocationContext) {
            s = this.graphSource;
            if (s == null) {
                return Collections.emptyList();
            }
        }
        return s.getFileLocations(f, nodePresent);
    }

    public NodeStack getStack(InputNode n) {
        return this.getStack(n, this.getSelectedLanguage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeStack getStack(InputNode n, String lng) {
        GraphSource gs;
        NodeLocationContext nodeLocationContext = this;
        synchronized (nodeLocationContext) {
            if (this.graph == null || !this.graph.getNodes().contains(n)) {
                return null;
            }
            gs = this.graphSource;
        }
        return gs.getNodeStack(n, lng);
    }

    public synchronized Collection<InputNode> getGraphNodes() {
        return Collections.unmodifiableCollection(this.nodes);
    }

    public synchronized NodeStack.Frame getSelectedFrame() {
        return this.selectedFrame;
    }

    public synchronized Location getSelectedLocation() {
        return this.selectedFrame == null ? null : this.selectedFrame.getLocation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedLocation(NodeStack.Frame location) {
        InputNode n = null;
        if (location != null) {
            n = location.getNode();
            if (!this.getGraphNodes().contains(n)) {
                return;
            }
        }
        NodeLocationContext nodeLocationContext = this;
        synchronized (nodeLocationContext) {
            if (n != null && !this.nodes.contains(n) || this.selectedFrame == location) {
                return;
            }
            this.selectedFrame = location;
        }
        if (location == null) {
            return;
        }
        this.setSelectedLanguage(location.getLocation().getMimeType());
        this.fireWithListeners(false, ll -> {
            NodeLocationEvent ev = new NodeLocationEvent(this, location);
            for (NodeLocationListener l : ll) {
                l.selectedLocationChanged(ev);
            }
        });
        InputNode node = location.getNode();
        this.setCurrentNode(node, location);
        Openable o = (Openable)location.getLookup().lookup(Openable.class);
        if (o != null) {
            o.open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireWithListeners(boolean always, Consumer<NodeLocationListener[]> firer) {
        NodeLocationListener[] ll = null;
        NodeLocationContext nodeLocationContext = this;
        synchronized (nodeLocationContext) {
            if (this.listeners.isEmpty()) {
                if (!always) {
                    return;
                }
            } else {
                ll = this.listeners.toArray(new NodeLocationListener[this.listeners.size()]);
            }
        }
        firer.accept(ll);
    }

    public synchronized InputNode getCurrentNode() {
        return this.currentNode;
    }

    public void setCurrentNode(InputNode node, NodeStack.Frame nFrame) {
        this.setNodes0(node, nFrame, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNodes0(InputNode node, NodeStack.Frame nFrame, Collection<InputNode> selNodes) {
        InputNode previousNode;
        Object ns;
        NodeStack.Frame oldFrame;
        GraphSource s;
        assert (nFrame == null || nFrame.getNode() == node);
        NodeLocationContext nodeLocationContext = this;
        synchronized (nodeLocationContext) {
            s = this.graphSource;
            if (s == null) {
                return;
            }
            oldFrame = this.selectedFrame;
        }
        if (nFrame == null) {
            ns = s.getNodeStack(node, this.getSelectedLanguage());
            if (ns == null) {
                ns = s.getNodeStack(node, null);
            }
            if (oldFrame != null) {
                nFrame = oldFrame.findPeerFrame((NodeStack)ns);
            }
            if (nFrame == null && ns != null) {
                nFrame = ((NodeStack)ns).top();
            }
        }
        ns = this;
        synchronized (ns) {
            if (node == this.currentNode && nFrame == this.selectedFrame) {
                return;
            }
            this.selectedFrame = nFrame;
            previousNode = this.currentNode;
            if (!this.nodes.contains(node)) {
                assert (false);
                return;
            }
            if (node == previousNode) {
                return;
            }
            this.currentNode = node;
        }
        NodeStack.Frame fNewFrame = nFrame;
        this.fireWithListeners(false, ll -> {
            if (fNewFrame != null) {
                this.setSelectedLanguage(fNewFrame.getStack().getMime());
            }
            NodeLocationEvent evt = new NodeLocationEvent(this, this.nodes, node, this.selectedFrame);
            if (selNodes != null) {
                for (NodeLocationListener l : ll) {
                    l.nodesChanged(evt);
                }
            }
            if (node != previousNode) {
                for (NodeLocationListener l : ll) {
                    l.selectedNodeChanged(evt);
                }
            }
            if (oldFrame != fNewFrame) {
                evt = new NodeLocationEvent(this, fNewFrame);
                for (NodeLocationListener l : ll) {
                    l.selectedLocationChanged(evt);
                }
            }
        });
    }

    public void setSelectedNodes(Collection<InputNode> nodes) {
        this.setSelectedNodes0(nodes, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSelectedNodes0(Collection<InputNode> nodes, boolean fireGraph) {
        NodeStack.Frame nFrame;
        InputNode selNode;
        Set<Object> newNodes = new HashSet<InputNode>(nodes);
        boolean reselectNode = false;
        NodeLocationContext nodeLocationContext = this;
        synchronized (nodeLocationContext) {
            GraphSource src;
            if (this.graph == null) {
                newNodes = Collections.emptySet();
                src = null;
            } else {
                if (!fireGraph && newNodes.equals(this.nodes)) {
                    return;
                }
                src = GraphSource.getGraphSource(this.graph);
            }
            NodeStack.Frame oldFrame = this.selectedFrame;
            this.nodes = newNodes;
            this.graphSource = src;
            if (!newNodes.isEmpty()) {
                if (oldFrame == null || !newNodes.contains(oldFrame.getNode())) {
                    reselectNode = true;
                }
            } else {
                this.selectedFrame = null;
                this.currentNode = null;
            }
            selNode = this.currentNode;
            nFrame = this.selectedFrame;
        }
        if (reselectNode && !newNodes.isEmpty()) {
            this.setNodes0(nodes.iterator().next(), null, nodes);
            return;
        }
        Set<Object> fNodes = newNodes;
        this.fireWithListeners(false, ll -> {
            NodeLocationEvent evt = new NodeLocationEvent(this, fNodes, selNode, nFrame);
            for (NodeLocationListener l : ll) {
                l.nodesChanged(evt);
            }
        });
    }

    public void setGraphContext(Collection<InputNode> nodes) {
        this.setGraphContext(this.graph, nodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGraphContext(InputGraph graph, Collection<InputNode> nodes) {
        HashSet<InputNode> newNodes = new HashSet<InputNode>(nodes);
        NodeLocationContext nodeLocationContext = this;
        synchronized (nodeLocationContext) {
            if (this.graph == graph && newNodes.equals(this.nodes)) {
                return;
            }
            this.graph = graph;
            this.graphSource = null;
            this.contextNodes = new HashSet<InputNode>(nodes);
        }
        this.setSelectedNodes0(nodes, true);
    }

    public synchronized Collection<InputNode> getContextNodes() {
        return Collections.unmodifiableCollection(this.contextNodes);
    }
}

