/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import org.graalvm.visualizer.source.Location;
import org.graalvm.visualizer.source.NodeLocationContext;
import org.graalvm.visualizer.source.NodeStack;

public class NodeLocationEvent
extends EventObject {
    private final Collection<InputNode> nodes;
    private final InputNode selectedNode;
    private final NodeStack.Frame frame;
    private final Collection<NodeStack.Frame> resolvedFrames;
    private boolean extractNodes;

    NodeLocationEvent(NodeLocationContext ctx, NodeStack.Frame newLocation) {
        super(ctx);
        this.selectedNode = newLocation == null ? null : newLocation.getNode();
        this.nodes = null;
        this.frame = newLocation;
        this.resolvedFrames = null;
    }

    NodeLocationEvent(NodeLocationContext ctx, Set<NodeStack.Frame> resolvedFrames) {
        super(ctx);
        this.selectedNode = null;
        this.nodes = new HashSet<InputNode>();
        this.frame = null;
        this.resolvedFrames = resolvedFrames;
        this.extractNodes = true;
    }

    NodeLocationEvent(NodeLocationContext ctx, Collection<InputNode> nodes, InputNode selNode, NodeStack.Frame selFrame) {
        super(ctx);
        this.selectedNode = selNode;
        this.nodes = nodes;
        this.frame = selFrame;
        this.resolvedFrames = null;
    }

    public InputNode getSelectedNode() {
        return this.selectedNode;
    }

    public Collection<NodeStack.Frame> getResolvedFrames() {
        return this.resolvedFrames;
    }

    public Location getSelectedLocation() {
        if (this.frame == null) {
            return null;
        }
        return this.frame.getLocation();
    }

    public NodeStack.Frame getSelectedFrame() {
        return this.frame;
    }

    public NodeLocationContext getContext() {
        return (NodeLocationContext)this.getSource();
    }

    public Collection<InputNode> getNodes() {
        if (this.extractNodes) {
            for (NodeStack.Frame f : this.resolvedFrames) {
                this.nodes.add(f.getNode());
            }
            this.extractNodes = false;
        }
        return this.nodes;
    }
}

