/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.graalvm.visualizer.source.FileKey;
import org.graalvm.visualizer.source.Location;
import org.openide.filesystems.FileObject;

public final class SourceLocationUtils {
    private static Location createLocation(FileObject f, int line) {
        String spec = f.getPath() + ":" + line;
        return new Location(spec, FileKey.fromFile(f), line, -1, -1, null, -1, -1);
    }

    public static Collection<Location> atLine(List<Location> searchIn, int line) {
        return SourceLocationUtils.atLine(searchIn, line, line);
    }

    public static Collection<Location> atLine(List<Location> searchIn, int lineFrom, int lineTo) {
        Location x;
        Location x2;
        Location ref;
        FileObject f;
        if (searchIn == null || searchIn.isEmpty()) {
            return Collections.emptyList();
        }
        if (lineFrom > lineTo) {
            int x3 = lineFrom;
            lineFrom = lineTo;
            lineTo = x3;
        }
        if ((f = (ref = searchIn.iterator().next()).getOriginFile()) == null) {
            return Collections.emptyList();
        }
        Location l = SourceLocationUtils.createLocation(f, lineFrom);
        int locIndex = Collections.binarySearch(searchIn, l, Location::compareLineOnly);
        if (locIndex < 0) {
            return Collections.emptyList();
        }
        ArrayList<Location> locs = new ArrayList<Location>();
        for (int i = locIndex; i >= 0 && (x2 = searchIn.get(i)).getLine() >= lineFrom; --i) {
            locs.add(0, x2);
        }
        int max = searchIn.size();
        for (int i = locIndex; i < max && (x = searchIn.get(i)).getLine() <= lineTo; ++i) {
            locs.add(x);
        }
        return locs;
    }

    private SourceLocationUtils() {
    }
}

