/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source.impl.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.KeyStroke;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import org.graalvm.visualizer.data.services.GraphSelections;
import org.graalvm.visualizer.source.GraphSource;
import org.graalvm.visualizer.source.Location;
import org.graalvm.visualizer.source.impl.actions.Bundle;
import org.openide.awt.StatusDisplayer;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class ExtractLineAction
extends CallableSystemAction {
    public void performAction() {
        TopComponent tc = WindowManager.getDefault().getRegistry().getActivated();
        if (tc == null) {
            return;
        }
        GraphSelections sel = (GraphSelections)tc.getLookup().lookup(GraphSelections.class);
        if (sel == null) {
            return;
        }
        boolean unresolvedFound = false;
        InputGraph g = sel.getGraph();
        GraphSource gSrc = GraphSource.getGraphSource(g);
        Node[] nodes = tc.getActivatedNodes();
        HashSet<InputNode> selectNodes = new HashSet<InputNode>();
        HashSet<Location.Line> seenLines = new HashSet<Location.Line>();
        for (Node n : nodes) {
            Location x;
            Location x2;
            ArrayList<Location> searchIn;
            int locIndex;
            Location l;
            InputNode gn = (InputNode)n.getLookup().lookup(InputNode.class);
            if (gn == null || (l = gSrc.findNodeLocation(gn)) == null) continue;
            if (!l.isResolved()) {
                unresolvedFound = true;
                continue;
            }
            if (!seenLines.add(l.line()) || (locIndex = Collections.binarySearch(searchIn = new ArrayList<Location>(gSrc.getFileLocations(l.getOriginFile(), true)), l, Location::compareLineOnly)) < 0) continue;
            int lineno = l.getLine();
            for (int i = locIndex; i >= 0 && (x2 = (Location)searchIn.get(i)).getLine() == lineno; --i) {
                selectNodes.addAll(gSrc.getNodesAt(x2));
            }
            int max = searchIn.size();
            for (int i = locIndex; i < max && (x = (Location)searchIn.get(i)).getLine() == lineno; ++i) {
                selectNodes.addAll(gSrc.getNodesAt(x));
            }
        }
        if (selectNodes.isEmpty()) {
            StatusDisplayer.getDefault().setStatusText(Bundle.WARN_ExtractEmptySet());
            return;
        }
        if (unresolvedFound) {
            StatusDisplayer.getDefault().setStatusText(Bundle.WARN_UnresolvedLocations());
        }
        sel.extractNodes(selectNodes);
    }

    public ExtractLineAction() {
        this.putValue("ShortDescription", Bundle.ACTION_ExtractLine());
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, 3, false));
    }

    public String getName() {
        return Bundle.ACTION_ExtractLine();
    }

    protected void initialize() {
        super.initialize();
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected String iconResource() {
        return "org/graalvm/visualizer/source/resources/extractline.png";
    }
}

