/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source.impl.actions;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import org.graalvm.visualizer.source.GraphSource;
import org.graalvm.visualizer.source.Location;
import org.graalvm.visualizer.source.NodeLocationContext;
import org.graalvm.visualizer.source.NodeStack;
import org.graalvm.visualizer.source.impl.actions.Bundle;
import org.graalvm.visualizer.source.impl.actions.LocationAction;
import org.netbeans.api.actions.Openable;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public class GotoSourceAction
extends LocationAction
implements ContextAwareAction {
    public static final String ACTION_ID = "org.graalvm.visualizer.source.impl.actions.GotoSourceAction1";
    public static final String CATEGORY = "CallStack";
    private final NodeLocationContext locationContext = (NodeLocationContext)Lookup.getDefault().lookup(NodeLocationContext.class);

    public GotoSourceAction() {
        super(ACTION_ID);
    }

    private GotoSourceAction(Lookup context) {
        super(ACTION_ID, context);
    }

    @Override
    protected String iconResource() {
        return "org/graalvm/visualizer/source/resources/GoToSource.png";
    }

    private NodeStack getNodeStack(InputNode in, InputGraph gr) {
        GraphSource src = GraphSource.getGraphSource(gr);
        if (src == null) {
            return null;
        }
        String selectedMime = this.locationContext.getSelectedLanguage();
        NodeStack nodeStack = src.getNodeStack(in, selectedMime);
        if (nodeStack == null) {
            src.getNodeStack(in);
        }
        return nodeStack;
    }

    @Override
    public final void actionPerformed(ActionEvent e, InputGraph g, InputNode[] nodes) {
        Openable op;
        NodeStack.Frame loc = (NodeStack.Frame)this.context().lookup(NodeStack.Frame.class);
        if (loc != null) {
            Openable op2 = (Openable)loc.getLookup().lookup(Openable.class);
            if (!loc.isResolved() || op2 == null) {
                return;
            }
            op2.open();
            this.locationContext.setSelectedLocation(loc);
            return;
        }
        InputNode in = (InputNode)this.context().lookup(InputNode.class);
        if (in == null) {
            return;
        }
        InputGraph gr = (InputGraph)this.context().lookup(InputGraph.class);
        NodeStack nodeStack = this.getNodeStack(in, gr);
        if (nodeStack == null) {
            return;
        }
        NodeStack.Frame f = nodeStack.top();
        this.locationContext.setSelectedLocation(f);
        if (f.isResolved() && (op = (Openable)f.getLookup().lookup(Openable.class)) != null) {
            op.open();
        }
    }

    @Override
    protected boolean computeEnabled(InputGraph graph, InputNode[] nodes) {
        Node[] activatedNodes = this.activeNodes();
        if (activatedNodes.length != 1) {
            return false;
        }
        Node n = activatedNodes[0];
        Location l = (Location)n.getLookup().lookup(Location.class);
        if (l != null) {
            return l.isResolved();
        }
        InputNode in = (InputNode)n.getLookup().lookup(InputNode.class);
        if (in == null) {
            return false;
        }
        InputGraph gr = (InputGraph)n.getLookup().lookup(InputGraph.class);
        NodeStack nodeStack = this.getNodeStack(in, gr);
        if (nodeStack == null) {
            return false;
        }
        NodeStack.Frame f = nodeStack.top();
        return f.isResolved();
    }

    @Override
    public String getName() {
        return Bundle.ACTION_GotoSource();
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new GotoSourceAction(actionContext);
    }
}

