/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source.impl.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import org.graalvm.visualizer.source.NodeLocationContext;
import org.graalvm.visualizer.source.NodeLocationEvent;
import org.graalvm.visualizer.source.NodeLocationListener;
import org.graalvm.visualizer.source.NodeStack;
import org.graalvm.visualizer.source.impl.editor.StackAnnotation;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class StackAnnotator
implements Runnable,
NodeLocationListener {
    private static final RequestProcessor RP = new RequestProcessor(StackAnnotator.class);
    private final NodeLocationContext locContext;
    private final RequestProcessor.Task refreshTask = RP.create((Runnable)this, true);
    private Collection<Annotation> attachedAnnotations = Collections.emptyList();
    private Collection<Annotation> newAnnotations;
    private NodeStack.Frame current;

    public StackAnnotator(NodeLocationContext locContext) {
        this.locContext = locContext;
    }

    @Override
    public void run() {
        this.newAnnotations = new ArrayList<Annotation>();
        this.current = this.locContext.getSelectedFrame();
        for (InputNode n : this.locContext.getGraphNodes()) {
            boolean isCurrentNode;
            NodeStack locs = this.locContext.getStack(n);
            if (locs == null || !(isCurrentNode = locs.contains(this.current))) continue;
            for (NodeStack.Frame l : locs) {
                this.annotateLocation(l);
            }
        }
        for (Annotation a : this.attachedAnnotations) {
            a.detach();
        }
        this.attachedAnnotations = this.newAnnotations;
        this.newAnnotations = null;
        this.current = null;
    }

    void annotateLocation(NodeStack.Frame l) {
        StackAnnotation a;
        String suffix;
        FileObject f = l.getOriginFile();
        if (f == null) {
            return;
        }
        LineCookie cake = (LineCookie)f.getLookup().lookup(LineCookie.class);
        if (cake == null) {
            return;
        }
        Line line = null;
        try {
            line = cake.getLineSet().getOriginal(l.getLine() - 1);
        }
        catch (IndexOutOfBoundsException ex) {
            return;
        }
        if (line == null) {
            return;
        }
        if (this.current == null) {
            return;
        }
        String string = suffix = l == this.current ? "Current" : "";
        if (l.getNested() == null) {
            a = new StackAnnotation(line, l.getLocation(), "NodePosition" + suffix);
        } else if (this.current.isNestedIn(l)) {
            a = new StackAnnotation(line, l.getLocation(), "CallSite" + suffix);
        } else if (this.current == l || l.isNestedIn(this.current)) {
            a = new StackAnnotation(line, l.getLocation(), "CalledSite" + suffix);
        } else {
            return;
        }
        a.attach((Annotatable)line);
        this.newAnnotations.add(a);
    }

    @Override
    public void nodesChanged(NodeLocationEvent evt) {
    }

    @Override
    public void locationsResolved(NodeLocationEvent evt) {
    }

    @Override
    public void selectedNodeChanged(NodeLocationEvent evt) {
    }

    @Override
    public void selectedLocationChanged(NodeLocationEvent evt) {
        this.refreshTask.schedule(0);
    }

    public static class Init
    implements Runnable {
        @Override
        public void run() {
            NodeLocationContext locContext = (NodeLocationContext)Lookup.getDefault().lookup(NodeLocationContext.class);
            if (locContext != null) {
                locContext.addNodeLocationListener(new StackAnnotator(locContext));
            }
        }
    }
}

