/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source.impl.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.lang.reflect.Field;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.openide.awt.HtmlRenderer;
import org.openide.explorer.view.NodeRenderer;

final class CompactComboRenderer
extends NodeRenderer {
    private static Field refRendererField;
    private HtmlRenderer.Renderer myRenderer;
    private final ThinPanel rendererPanel = new ThinPanel();

    public CompactComboRenderer() {
        this.myRenderer = CompactComboRenderer.getRendererHack(this);
    }

    private static HtmlRenderer.Renderer getRendererHack(NodeRenderer instance) {
        if (refRendererField == null) {
            try {
                refRendererField = NodeRenderer.class.getDeclaredField("renderer");
                refRendererField.setAccessible(true);
            }
            catch (ReflectiveOperationException | SecurityException ex) {
                return HtmlRenderer.createRenderer();
            }
        }
        try {
            return (HtmlRenderer.Renderer)refRendererField.get(instance);
        }
        catch (ReflectiveOperationException ex) {
            return HtmlRenderer.createRenderer();
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean sel, boolean cellHasFocus) {
        if (index != -1) {
            Component c = super.getListCellRendererComponent(list, value, index, sel, cellHasFocus);
            return c;
        }
        Component c = this.rendererPanel.setRenderer(super.getListCellRendererComponent(list, value, index, sel, cellHasFocus));
        this.myRenderer.setIndent(0);
        return c;
    }

    private static final class ThinPanel
    extends JPanel {
        private Component lastRenderer;

        public ThinPanel() {
            this.setLayout(new BorderLayout());
            this.setBorder(null);
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.lastRenderer == null) {
                return super.getPreferredSize();
            }
            JComponent jc = null;
            Border b = null;
            if (this.lastRenderer instanceof JComponent) {
                jc = (JComponent)this.lastRenderer;
                b = jc.getBorder();
                jc.setBorder(null);
            }
            Dimension dim = this.lastRenderer.getPreferredSize();
            if (b != null && jc != null) {
                jc.setBorder(b);
            }
            dim.width = 5;
            return new Dimension(5, dim.height);
        }

        public Component setRenderer(Component c) {
            if (this.lastRenderer != c || c.getParent() != this) {
                if (this.lastRenderer != null) {
                    this.remove(this.lastRenderer);
                }
                this.lastRenderer = c;
                this.add(c, "Center");
            }
            return this;
        }
    }
}

