/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source.impl.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import org.graalvm.visualizer.source.impl.FileGroup;
import org.graalvm.visualizer.source.impl.SourceRepositoryImpl;
import org.graalvm.visualizer.source.impl.SourceRepositoryNode;
import org.graalvm.visualizer.source.impl.ui.RootPlacementUI;
import org.openide.explorer.ExplorerManager;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;

public class CreateRootPanel
extends JPanel {
    private JFileChooser chooser;
    private SourceRepositoryImpl impl;
    private final ExplorerManager mgr = new ExplorerManager();
    private final RootPlacementUI rootPlacement;
    private JPanel chooserParent;
    private JPanel placement;

    public CreateRootPanel(FileObject f, SourceRepositoryImpl impl) throws FileStateInvalidException {
        this.impl = impl;
        this.initComponents();
        File workingDir = FileUtil.toFile((FileObject)f);
        FileChooserBuilder b = FileChooserBuilder.create((FileSystem)f.getFileSystem()).setDirectoriesOnly(true).setDefaultWorkingDirectory(workingDir).setControlButtonsAreShown(false);
        this.chooser = b.createFileChooser();
        this.chooserParent.add(this.chooser);
        this.rootPlacement = new RootPlacementUI(this.chooser, impl);
        this.placement.add((Component)this.rootPlacement, "Center");
        SourceRepositoryNode rNode = new SourceRepositoryNode(impl, true);
        FilterNode.Children fChildren = new FilterNode.Children((Node)rNode){

            protected Node[] createNodes(Node key) {
                if (key.getLookup().lookup(FileGroup.class) == null) {
                    return null;
                }
                return new Node[]{new FilterNode(key, Children.LEAF)};
            }
        };
        AbstractNode an = new AbstractNode((Children)fChildren);
        this.mgr.setRootContext((Node)an);
    }

    boolean invokeCancelListener(ActionEvent ev) {
        Action l;
        FileChooserUI ui = this.chooser.getUI();
        if (ui instanceof BasicFileChooserUI) {
            l = ((BasicFileChooserUI)ui).getCancelSelectionAction();
        } else {
            l = this.chooser.getActionMap().get("cancelSelection");
            if (l == null) {
                return false;
            }
        }
        ActionEvent ae = new ActionEvent(this.chooser, 0, "CancelSelection", ev.getWhen(), ev.getModifiers());
        l.actionPerformed(ae);
        return true;
    }

    boolean invokeApproveListener(ActionEvent ev) {
        Action l;
        FileChooserUI ui = this.chooser.getUI();
        if (ui instanceof BasicFileChooserUI) {
            l = ((BasicFileChooserUI)ui).getApproveSelectionAction();
        } else {
            l = this.chooser.getActionMap().get("approveSelection");
            if (l == null) {
                return false;
            }
        }
        ActionEvent ae = new ActionEvent(this.chooser, 0, "ApproveSelection", ev.getWhen(), ev.getModifiers());
        l.actionPerformed(ae);
        return true;
    }

    void setFileGroup(FileGroup g) {
        this.rootPlacement.setFileGroup(g);
    }

    public void addActionListener(ActionListener al) {
        this.chooser.addActionListener(al);
    }

    private void initComponents() {
        this.chooserParent = new JPanel();
        this.placement = new JPanel();
        this.chooserParent.setLayout(new BorderLayout());
        this.placement.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chooserParent, -1, 400, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.placement, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.chooserParent, -1, 107, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.placement, -2, 67, -2).addContainerGap()));
    }

    public FileObject getSelectedRoot() {
        File f = this.chooser.getSelectedFile();
        return f == null ? null : FileUtil.toFileObject((File)f);
    }

    public String getDescription() {
        return this.rootPlacement.getDescription();
    }

    public FileGroup getParentGroup() {
        return this.rootPlacement.getParentGroup();
    }
}

