/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source.impl.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.graalvm.visualizer.source.Location;
import org.graalvm.visualizer.source.impl.ui.Bundle;
import org.graalvm.visualizer.source.ui.Trackable;
import org.netbeans.api.actions.Openable;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.editor.document.EditorDocumentUtils;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Mutex;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public final class LocationOpener
implements Openable,
Trackable {
    private final Location location;

    public LocationOpener(Location location) {
        this.location = location;
    }

    public void open() {
        this.openOrView(true);
    }

    private void openOrView(final boolean focus) {
        FileObject toOpen = this.location.getOriginFile();
        if (toOpen == null) {
            return;
        }
        final EditorCookie cake = (EditorCookie)toOpen.getLookup().lookup(EditorCookie.class);
        if (cake == null) {
            return;
        }
        Task task = cake.prepareDocument();
        class WhenShowing
        implements TaskListener,
        Runnable {
            WhenShowing() {
            }

            public void taskFinished(Task task) {
                task.removeTaskListener((TaskListener)this);
                Mutex.EVENT.postReadRequest((Runnable)this);
            }

            @Override
            public void run() {
                StyledDocument doc = cake.getDocument();
                if (doc == null) {
                    return;
                }
                List<Annotatable> select = LocationOpener.findLinesOrParts(cake.getLineSet(), doc, LocationOpener.this.location.getLine() - 1, LocationOpener.this.location.getOffsetsOrNull());
                if (select.size() == 1 && select.get(0) instanceof Line) {
                    Line line = (Line)select.get(0);
                    line.show(Line.ShowOpenType.REUSE, focus ? Line.ShowVisibilityType.FRONT : Line.ShowVisibilityType.FRONT);
                    CurrentNodeAnnotation.highlight(select);
                } else if (select.size() >= 1 && select.get(0) instanceof Line.Part) {
                    Line.Part part = (Line.Part)select.get(0);
                    part.getLine().show(Line.ShowOpenType.REUSE, focus ? Line.ShowVisibilityType.FRONT : Line.ShowVisibilityType.FRONT, part.getColumn());
                    CurrentNodeAnnotation.highlight(select);
                } else {
                    cake.open();
                    StatusDisplayer.getDefault().setStatusText(Bundle.ERR_LineNotFound());
                }
            }
        }
        WhenShowing select = new WhenShowing();
        task.addTaskListener((TaskListener)select);
    }

    @Override
    public void viewIfOpened() {
        FileObject toOpen = this.location.getOriginFile();
        if (toOpen == null) {
            return;
        }
        for (JTextComponent comp : EditorRegistry.componentList()) {
            Document doc = comp.getDocument();
            FileObject fo = EditorDocumentUtils.getFileObject((Document)doc);
            if (toOpen != fo) continue;
            this.view();
        }
    }

    public void view() {
        this.openOrView(false);
    }

    static List<Annotatable> findLinesOrParts(Line.Set lines, StyledDocument doc, int lineNumber, int[] offsetsOrNull) {
        assert (doc != null);
        Line exactLine = LocationOpener.findLine(lines, lineNumber);
        Line startLine = null;
        Line endLine = null;
        if (offsetsOrNull != null) {
            int startOffsetLineNumber = NbDocument.findLineNumber((StyledDocument)doc, (int)offsetsOrNull[0]);
            startLine = LocationOpener.findLine(lines, startOffsetLineNumber);
            int endOffsetLineNumber = NbDocument.findLineNumber((StyledDocument)doc, (int)offsetsOrNull[1]);
            endLine = LocationOpener.findLine(lines, endOffsetLineNumber);
        }
        if (startLine == null || exactLine != null && startLine != exactLine) {
            return Collections.singletonList(exactLine);
        }
        int startLineOffset = NbDocument.findLineOffset((StyledDocument)doc, (int)startLine.getLineNumber());
        int startColumn = offsetsOrNull[0] - startLineOffset;
        if (startLine == endLine || endLine == null) {
            int len = offsetsOrNull[1] - offsetsOrNull[0];
            Line.Part linePart = startLine.createPart(startColumn, len);
            return Collections.singletonList(linePart);
        }
        ArrayList<Annotatable> multiple = new ArrayList<Annotatable>();
        Line.Part firstLinePart = startLine.createPart(startColumn, startLine.getText().length() - startColumn);
        multiple.add((Annotatable)firstLinePart);
        for (int between = startLine.getLineNumber() + 1; between < endLine.getLineNumber(); ++between) {
            Line lineBetween = LocationOpener.findLine(lines, between);
            if (lineBetween == null) continue;
            multiple.add((Annotatable)lineBetween);
        }
        int endLineOffset = NbDocument.findLineOffset((StyledDocument)doc, (int)endLine.getLineNumber());
        int endColumn = offsetsOrNull[1] - endLineOffset;
        Line.Part lastLinePart = endLine.createPart(0, endColumn);
        multiple.add((Annotatable)lastLinePart);
        return multiple;
    }

    private static Line findLine(Line.Set lines, int line) {
        try {
            return lines.getOriginal(line);
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    private static final class CurrentNodeAnnotation
    extends Annotation {
        private static List<CurrentNodeAnnotation> previous = Collections.emptyList();

        private CurrentNodeAnnotation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void highlight(List<Annotatable> select) {
            ArrayList<CurrentNodeAnnotation> newOnes = new ArrayList<CurrentNodeAnnotation>();
            for (Annotatable l : select) {
                CurrentNodeAnnotation a = new CurrentNodeAnnotation();
                newOnes.add(a);
                a.attach(l);
            }
            Class<CurrentNodeAnnotation> clazz = CurrentNodeAnnotation.class;
            synchronized (CurrentNodeAnnotation.class) {
                List<CurrentNodeAnnotation> toClear = previous;
                previous = newOnes;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                for (CurrentNodeAnnotation a : toClear) {
                    a.detach();
                }
                return;
            }
        }

        public String getAnnotationType() {
            return "NodePositionOffset";
        }

        public String getShortDescription() {
            return Bundle.CTL_CurrentNode();
        }
    }
}

