/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source.impl.ui;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import org.graalvm.visualizer.source.impl.FileGroup;
import org.graalvm.visualizer.source.impl.SourceRepositoryImpl;
import org.graalvm.visualizer.source.impl.ui.Bundle;
import org.graalvm.visualizer.source.impl.ui.CreateRootPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

public class NewSourceRootAction
extends AbstractAction {
    final SourceRepositoryImpl repository;
    FileGroup defaultGroup;

    public NewSourceRootAction(SourceRepositoryImpl repository, FileGroup defaultGroup) {
        super(Bundle.ACTION_NewSourceRoot());
        this.repository = repository;
        this.defaultGroup = defaultGroup;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FileGroup group;
        CreateRootPanel crp;
        Preferences pref = NbPreferences.forModule(this.getClass());
        String dirUrl = pref.get("sourceroot.lastdir", null);
        FileObject dir = null;
        if (dirUrl != null) {
            try {
                dir = URLMapper.findFileObject((URL)new URL(dirUrl));
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (dir == null) {
            dir = FileUtil.toFileObject((File)new File(System.getProperty("user.home")));
        }
        try {
            crp = new CreateRootPanel(dir, this.repository);
            crp.setFileGroup(this.defaultGroup);
        }
        catch (FileStateInvalidException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return;
        }
        String sAdd = Bundle.BTN_Add();
        final String cmdAdd = Bundle.BTN_CommandAdd();
        String sCancel = Bundle.BTN_Cancel();
        final String cmdCancel = Bundle.BTN_CommandCancel();
        final DialogDescriptor nd = new DialogDescriptor((Object)crp, Bundle.TITLE_AddSourceRoot(), true, new Object[]{sAdd, sCancel}, (Object)sAdd, 0, null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String ac = e.getActionCommand();
                if (ac == null) {
                    return;
                }
                if (ac.equals(cmdAdd)) {
                    crp.invokeApproveListener(e);
                } else if (ac.equals(cmdCancel)) {
                    crp.invokeCancelListener(e);
                }
            }
        });
        nd.setNoDefaultClose(false);
        final Dialog dlg = DialogDisplayer.getDefault().createDialog(nd);
        crp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("CancelSelection".equals(e.getActionCommand())) {
                    nd.setValue(NotifyDescriptor.CANCEL_OPTION);
                    dlg.setVisible(false);
                } else if ("ApproveSelection".equals(e.getActionCommand())) {
                    nd.setValue(NotifyDescriptor.OK_OPTION);
                    dlg.setVisible(false);
                }
            }
        });
        dlg.setVisible(true);
        Object result = nd.getValue();
        if (result != NotifyDescriptor.OK_OPTION) {
            return;
        }
        FileObject root = crp.getSelectedRoot();
        String disp = crp.getDescription();
        this.defaultGroup = group = crp.getParentGroup();
        if (group == null) {
            group = this.repository.getDefaultGroup();
        }
        try {
            this.repository.addLocation(root, disp, group);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

