/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source.impl.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.swing.GroupLayout;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.graalvm.visualizer.source.Location;
import org.graalvm.visualizer.source.impl.FileGroup;
import org.graalvm.visualizer.source.impl.SourceRepositoryImpl;
import org.graalvm.visualizer.source.impl.ui.RootPlacementUI;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class RootContentPanel
extends JPanel
implements PropertyChangeListener {
    private final Location loc;
    private final JFileChooser chooser;
    private final RootPlacementUI rootPlacement;
    private JTextField fileName;
    private JPanel foundPanel;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel missingPanel;
    private JPanel outcomeHolder;

    public RootContentPanel(Location loc, JFileChooser chooser, SourceRepositoryImpl repository) throws IOException {
        this.loc = loc;
        this.chooser = chooser;
        this.initComponents();
        String spec = loc.getFile().getFileSpec();
        int last = spec.lastIndexOf("/");
        String simple = last == -1 ? spec : spec.substring(last + 1);
        this.fileName.setText(simple);
        chooser.addPropertyChangeListener(this);
        this.rootPlacement = new RootPlacementUI(chooser, repository);
        this.foundPanel.add((Component)this.rootPlacement, "Center");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("SelectedFileChangedProperty".equals(evt.getPropertyName())) {
            this.refresh();
        }
    }

    private void notFound() {
        ((CardLayout)this.outcomeHolder.getLayout()).show(this.outcomeHolder, "missing");
    }

    private void found(String where) {
        ((CardLayout)this.outcomeHolder.getLayout()).show(this.outcomeHolder, "found");
    }

    private void refresh() {
        File f = this.chooser.getSelectedFile();
        if (f == null) {
            this.notFound();
            return;
        }
        FileObject root = FileUtil.toFileObject((File)f);
        FileObject file = root.getFileObject(this.loc.getFileName());
        if (file != null) {
            String rel = FileUtil.getRelativePath((FileObject)root, (FileObject)file);
            this.found(rel);
        } else {
            this.notFound();
        }
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.outcomeHolder = new JPanel();
        this.missingPanel = new JPanel();
        this.jLabel4 = new JLabel();
        this.foundPanel = new JPanel();
        this.fileName = new JTextField();
        this.jLabel1 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(RootContentPanel.class, (String)"RootContentPanel.jLabel3.text"));
        this.outcomeHolder.setLayout(new CardLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(RootContentPanel.class, (String)"RootContentPanel.jLabel4.text"));
        GroupLayout missingPanelLayout = new GroupLayout(this.missingPanel);
        this.missingPanel.setLayout(missingPanelLayout);
        missingPanelLayout.setHorizontalGroup(missingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(missingPanelLayout.createSequentialGroup().addComponent(this.jLabel4).addGap(0, 189, Short.MAX_VALUE)));
        missingPanelLayout.setVerticalGroup(missingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(missingPanelLayout.createSequentialGroup().addComponent(this.jLabel4).addGap(0, 62, Short.MAX_VALUE)));
        this.outcomeHolder.add((Component)this.missingPanel, "missing");
        this.foundPanel.setLayout(new BorderLayout());
        this.outcomeHolder.add((Component)this.foundPanel, "found");
        this.fileName.setEditable(false);
        this.fileName.setText(NbBundle.getMessage(RootContentPanel.class, (String)"RootContentPanel.fileName.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(RootContentPanel.class, (String)"RootContentPanel.jLabel1.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.outcomeHolder, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addContainerGap(-1, Short.MAX_VALUE)).addComponent(this.fileName, GroupLayout.Alignment.TRAILING))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(8, 8, 8).addComponent(this.fileName, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outcomeHolder, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public void setFileGroup(FileGroup g) {
        this.rootPlacement.setFileGroup(g);
    }

    public String getDescription() {
        return this.rootPlacement.getDescription();
    }

    public FileGroup getParentGroup() {
        return this.rootPlacement.getParentGroup();
    }
}

