/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.script.js;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.graalvm.visualizer.script.ScriptDefinition;
import org.graalvm.visualizer.script.spi.UserScriptProcessor;

public class JavascriptWrapperImpl
implements UserScriptProcessor {
    private static final Logger LOG = Logger.getLogger(JavascriptWrapperImpl.class.getName());
    private static final AtomicInteger uniq = new AtomicInteger(0);

    private void generateFunctionalHeader(StringBuilder sb, ScriptDefinition def) {
        sb.append("(function(");
        boolean first = true;
        for (String pn : def.getParamNames()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(pn);
            first = false;
        }
        sb.append("){ ");
    }

    @Override
    public String processUserCode(ScriptDefinition def, String userCode) {
        if (def.isExecuteFunction()) {
            StringBuilder sb = new StringBuilder(userCode);
            sb.append("\n");
            this.generateFunctionalHeader(sb, def);
            sb.append(def.getFunctionName()).append('(');
            boolean first = true;
            for (String pn : def.getParamNames()) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(pn);
                first = false;
            }
            sb.append("); })");
            return sb.toString();
        }
        if (def.getParamNames().isEmpty()) {
            return userCode;
        }
        StringBuilder sb = new StringBuilder();
        this.generateFunctionalHeader(sb, def);
        sb.append(userCode);
        sb.append("})");
        return sb.toString();
    }

    public String assignGlobals(String scriptFilename, Map<String, Object> globalValues) {
        if (globalValues.isEmpty()) {
            return null;
        }
        StringBuilder fb = new StringBuilder();
        ArrayList<CallSite> globNames = new ArrayList<CallSite>(globalValues.size());
        int index = 0;
        int n = uniq.incrementAndGet();
        for (String pn : globalValues.keySet()) {
            fb.append("var ").append(pn).append(";\n");
        }
        fb.append("(function runScript_").append(Integer.toHexString(n)).append("(");
        for (String pn : globalValues.keySet()) {
            if (index > 0) {
                fb.append(", ");
            }
            String nn = "__" + pn;
            fb.append(nn);
            globNames.add((CallSite)((Object)nn));
            ++index;
        }
        fb.append("){");
        index = 0;
        for (String gn : globalValues.keySet()) {
            String pn = (String)globNames.get(index);
            fb.append(gn).append(" = ").append(pn).append(";");
            ++index;
        }
        fb.append("})");
        return fb.toString();
    }

    @Override
    public String assignGlobals(ScriptDefinition def) {
        return this.assignGlobals(def.getScriptFilename(), def.getGlobals());
    }
}

