/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.graph;

import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.graalvm.visualizer.graph.Figure;
import org.graalvm.visualizer.graph.InputSlot;
import org.graalvm.visualizer.graph.OutputSlot;
import org.graalvm.visualizer.layout.Link;
import org.graalvm.visualizer.layout.Port;

public final class Connection
implements Link {
    private final InputSlot inputSlot;
    private final OutputSlot outputSlot;
    private final int hash;
    private final String label;
    private final String type;
    private Color color;
    private ConnectionStyle style;
    private List<Point> controlPoints;

    public boolean isVIP() {
        return this.style == ConnectionStyle.BOLD;
    }

    protected Connection(InputSlot inputSlot, OutputSlot outputSlot, String label, String type) {
        this.inputSlot = inputSlot;
        this.outputSlot = outputSlot;
        this.label = label;
        this.type = type;
        this.inputSlot.connections.add(this);
        this.outputSlot.connections.add(this);
        this.controlPoints = new ArrayList<Point>();
        Figure sourceFigure = this.outputSlot.getFigure();
        Figure destFigure = this.inputSlot.getFigure();
        sourceFigure.addSuccessor(destFigure);
        destFigure.addPredecessor(sourceFigure);
        this.color = Color.BLACK;
        this.style = ConnectionStyle.NORMAL;
        this.hash = this.makeHash();
    }

    private int makeHash() {
        int h = this.inputSlot.getFigure().getId();
        h = h * 83 + this.outputSlot.getFigure().getId();
        h = h * 83 + this.inputSlot.getPosition();
        h = h * 83 + this.outputSlot.getPosition();
        return h;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Connection)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        Connection c = (Connection)other;
        return this.inputSlot.getFigure().getId() == c.getInputSlot().getFigure().getId() && this.outputSlot.getFigure().getId() == c.getOutputSlot().getFigure().getId() && this.outputSlot.getPosition() == c.getOutputSlot().getPosition() && this.inputSlot.getPosition() == c.getInputSlot().getPosition();
    }

    public InputSlot getInputSlot() {
        return this.inputSlot;
    }

    public OutputSlot getOutputSlot() {
        return this.outputSlot;
    }

    public Color getColor() {
        return this.color;
    }

    public ConnectionStyle getStyle() {
        return this.style;
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public void setStyle(ConnectionStyle s) {
        this.style = s;
    }

    public String getLabel() {
        return this.label;
    }

    public String getType() {
        return this.type;
    }

    public void remove() {
        this.inputSlot.getFigure().removePredecessor(this.outputSlot.getFigure());
        this.inputSlot.connections.remove(this);
        this.outputSlot.getFigure().removeSuccessor(this.inputSlot.getFigure());
        this.outputSlot.connections.remove(this);
    }

    public void remove(HashSet<Object> cleaned) {
        if (cleaned == null) {
            this.remove();
            return;
        }
        this.inputSlot.cleanDeletedFigures(cleaned);
        this.outputSlot.cleanDeletedFigures(cleaned);
    }

    public String getToolTipText() {
        StringBuilder builder = new StringBuilder();
        if (this.label != null) {
            builder.append(this.label).append(": ");
        }
        if (this.type != null) {
            builder.append(this.type).append(" ");
        }
        builder.append("from ");
        builder.append(this.getOutputSlot().getFigure().getSource().firstId());
        builder.append(" to ");
        builder.append(this.getInputSlot().getFigure().getSource().firstId());
        return builder.toString();
    }

    public String toString() {
        return "Connection('" + this.label + "', " + this.getFrom().getVertex() + " to " + this.getTo().getVertex() + ")";
    }

    public Port getFrom() {
        return this.outputSlot;
    }

    public Port getTo() {
        return this.inputSlot;
    }

    public List<Point> getControlPoints() {
        return this.controlPoints;
    }

    public void setControlPoints(List<Point> list) {
        this.controlPoints = list;
    }

    public Connection makeCopy(InputSlot is, OutputSlot os) {
        Connection c = new Connection(is, os, this.label, this.type);
        c.color = this.getColor();
        c.style = this.getStyle();
        if (this.controlPoints == null) {
            c.controlPoints = Collections.emptyList();
        } else {
            ArrayList<Point> pts = new ArrayList<Point>(this.controlPoints.size());
            for (Point pt : this.controlPoints) {
                if (pt == null) {
                    pts.add(null);
                    continue;
                }
                pts.add(pt.getLocation());
            }
            c.controlPoints = pts;
        }
        return c;
    }

    public static enum ConnectionStyle {
        NORMAL,
        DASHED,
        BOLD;

    }
}

