/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.view.actions;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.KeyStroke;
import org.graalvm.visualizer.view.EditorTopComponent;
import org.graalvm.visualizer.view.actions.Bundle;
import org.openide.util.HelpCtx;
import org.openide.util.actions.ActionInvoker;
import org.openide.util.actions.CallableSystemAction;

public final class ZoomOutAction
extends CallableSystemAction {
    public static final String ID = "org.graalvm.visualizer.view.actions.ZoomOutAction";

    public void actionPerformed(final ActionEvent ev) {
        if (this.isEnabled()) {
            ActionInvoker.invokeAction((Action)((Object)this), (ActionEvent)ev, (boolean)this.asynchronous(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    if ((ev.getModifiers() & 1) > 0) {
                        ZoomOutAction.this.performZoom(true);
                    } else {
                        ZoomOutAction.this.performZoom(false);
                    }
                }
            });
        } else {
            super.actionPerformed(ev);
        }
    }

    void performZoom(boolean origSize) {
        EditorTopComponent editor = EditorTopComponent.getActive();
        if (editor != null) {
            if (origSize) {
                editor.zoomTo(1.0f);
            } else {
                editor.zoomOut();
            }
        }
    }

    public void performAction() {
        this.performZoom(false);
    }

    public ZoomOutAction() {
        this.putValue("ShortDescription", Bundle.ACTION_ZoomOut());
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(45, 2, false));
    }

    public String getName() {
        return Bundle.ACTION_ZoomOut();
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected String iconResource() {
        return "org/graalvm/visualizer/view/images/zoom_out.png";
    }
}

