/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.coordinator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.dnd.DropTarget;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.Queue;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jdk.graal.compiler.graphio.parsing.model.ChangedListener;
import jdk.graal.compiler.graphio.parsing.model.Folder;
import jdk.graal.compiler.graphio.parsing.model.FolderElement;
import jdk.graal.compiler.graphio.parsing.model.GraphDocument;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import org.graalvm.visualizer.coordinator.actions.ImportAction;
import org.graalvm.visualizer.coordinator.actions.RemoveAction;
import org.graalvm.visualizer.coordinator.actions.RemoveAllAction;
import org.graalvm.visualizer.coordinator.actions.SaveAllAction;
import org.graalvm.visualizer.coordinator.actions.SaveAsAction;
import org.graalvm.visualizer.coordinator.impl.SessionManagerImpl;
import org.graalvm.visualizer.coordinator.impl.SessionNode;
import org.graalvm.visualizer.data.services.GraphViewer;
import org.graalvm.visualizer.data.services.InputGraphProvider;
import org.graalvm.visualizer.util.ExternalDropTarget;
import org.graalvm.visualizer.view.api.DiagramViewer;
import org.graalvm.visualizer.view.api.DiagramViewerEvent;
import org.graalvm.visualizer.view.api.DiagramViewerListener;
import org.netbeans.spi.project.ui.PathFinder;
import org.openide.ErrorManager;
import org.openide.awt.Actions;
import org.openide.awt.Toolbar;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class OutlineTopComponent
extends TopComponent
implements ExplorerManager.Provider,
LookupListener {
    public static OutlineTopComponent instance;
    public static final String PREFERRED_ID = "OutlineTopComponent";
    private ExplorerManager manager;
    private final GraphDocument document = SessionManagerImpl.getInstance().getCurrentDocument();
    private Node root;
    private DropTarget dt;
    private DiagramOutlineSynchronized sync;
    private JScrollPane treeView;

    private OutlineTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(OutlineTopComponent.class, (String)"CTL_OutlineTopComponent"));
        this.setToolTipText(NbBundle.getMessage(OutlineTopComponent.class, (String)"HINT_OutlineTopComponent"));
        this.initListView();
        this.initToolbar();
        this.dt = ExternalDropTarget.createDropTarget((JComponent)((Object)this));
        this.setDropTarget(this.dt);
        this.dt.setActive(true);
    }

    protected void componentShowing() {
        super.componentShowing();
        if (this.sync == null) {
            this.sync = new DiagramOutlineSynchronized((GraphViewer)Lookup.getDefault().lookup(GraphViewer.class));
        }
    }

    private void initListView() {
        this.manager = new ExplorerManager();
        this.resetFolderRoot();
        ((BeanTreeView)this.treeView).setRootVisible(false);
        Component view = this.treeView.getViewport().getView();
        DropTarget dt = ExternalDropTarget.createDropTarget((JComponent)((JComponent)view));
        dt.setActive(true);
        view.setDropTarget(dt);
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)this.getActionMap()));
    }

    private void selectPathOrIgnore(InputGraph element, Queue<FolderElement> path) {
        Node cur = Arrays.asList(this.manager.getSelectedNodes()).stream().filter(n -> n.getLookup().lookup(InputGraph.class) == element).findAny().orElse(null);
        if (cur != null) {
            return;
        }
        Node n2 = this.findPath(path);
        if (n2 == null) {
            return;
        }
        try {
            this.manager.setSelectedNodes(new Node[]{n2});
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private Node findPath(Queue<FolderElement> path) {
        FolderElement child;
        Node n = this.manager.getRootContext();
        while ((child = path.poll()) != null) {
            PathFinder pf = (PathFinder)n.getLookup().lookup(PathFinder.class);
            Node n2 = null;
            if (pf != null) {
                n2 = pf.findPath(n, (Object)child);
            }
            if (n2 == null) {
                FolderElement toFind = child;
                n2 = Arrays.asList(n.getChildren().getNodes()).stream().filter(t -> t.getLookup().lookup(FolderElement.class) == toFind).findFirst().orElse(null);
            }
            if (n2 == null) {
                return null;
            }
            n = n2;
        }
        return n;
    }

    private void resetFolderRoot() {
        this.root = new AbstractNode((Children)new SessionChildren(SessionManagerImpl.getInstance()));
        this.root.addNodeListener((NodeListener)new NewDataExpander());
        this.manager.setRootContext(this.root);
    }

    private void initToolbar() {
        Toolbar toolbar = new Toolbar();
        Border b = (Border)UIManager.get("Nb.Editor.Toolbar.border");
        toolbar.setBorder(b);
        this.add((Component)toolbar, "North");
        toolbar.add((Action)ImportAction.get(ImportAction.class));
        toolbar.add(((NodeAction)SaveAsAction.get(SaveAsAction.class)).createContextAwareInstance(this.getLookup()));
        toolbar.add((Action)SaveAllAction.get(SaveAllAction.class));
        toolbar.add(((NodeAction)RemoveAction.get(RemoveAction.class)).createContextAwareInstance(this.getLookup()));
        toolbar.add((Action)RemoveAllAction.get(RemoveAllAction.class));
        toolbar.add(Actions.forID((String)"IGV", (String)"org.graalvm.visualizer.coordinator.actions.FreezeSessionsAction"));
        toolbar.add(((Presenter.Toolbar)Actions.forID((String)"IGV", (String)"org.graalvm.visualizer.coordinator.actions.AutoFreezeSessionsAction")).getToolbarPresenter());
    }

    public void clear() {
        this.document.clear();
        SessionManagerImpl mgr = SessionManagerImpl.getInstance();
        for (GraphDocument gd : mgr.getSessions()) {
            mgr.removeElement((FolderElement)gd);
        }
        this.resetFolderRoot();
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public GraphDocument getDocument() {
        return this.document;
    }

    public static synchronized OutlineTopComponent getDefault() {
        if (instance == null) {
            instance = new OutlineTopComponent();
        }
        return instance;
    }

    public static synchronized OutlineTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            ErrorManager.getDefault().log(16, "Cannot find Outline component. It will not be located properly in the window system.");
            return OutlineTopComponent.getDefault();
        }
        if (win instanceof OutlineTopComponent) {
            return (OutlineTopComponent)win;
        }
        ErrorManager.getDefault().log(16, "There seem to be multiple components with the 'OutlineTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return OutlineTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
        this.requestActive();
    }

    public void componentClosed() {
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public void requestActive() {
        super.requestActive();
        this.treeView.requestFocus();
    }

    public boolean requestFocus(boolean temporary) {
        this.treeView.requestFocus();
        return super.requestFocus(temporary);
    }

    protected boolean requestFocusInWindow(boolean temporary) {
        this.treeView.requestFocus();
        return super.requestFocusInWindow(temporary);
    }

    public void resultChanged(LookupEvent lookupEvent) {
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        ((BeanTreeView)this.treeView).setRootVisible(false);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
    }

    private void initComponents() {
        this.treeView = new BeanTreeView();
        this.setLayout(new BorderLayout());
        this.add(this.treeView, "Center");
    }

    private class DiagramOutlineSynchronized
    implements ChangeListener,
    DiagramViewerListener {
        private final GraphViewer viewerService;
        private DiagramViewer viewer;
        private DiagramViewerListener viewerL;

        public DiagramOutlineSynchronized(GraphViewer viewerService) {
            this.viewerService = viewerService;
            viewerService.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)viewerService));
        }

        private void syncViewer(DiagramViewer vwr) {
            if (this.viewer == vwr) {
                return;
            }
            if (this.viewer != null && this.viewerL != null) {
                this.viewer.removeDiagramViewerListener(this.viewerL);
            }
            this.viewer = vwr;
            if (vwr != null) {
                this.viewerL = (DiagramViewerListener)WeakListeners.create(DiagramViewerListener.class, (EventListener)this, (Object)vwr);
                vwr.addDiagramViewerListener(this.viewerL);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            InputGraphProvider provider = this.viewerService.getActiveViewer();
            if (provider == null) {
                return;
            }
            DiagramViewer vwr = (DiagramViewer)provider.getLookup().lookup(DiagramViewer.class);
            this.syncViewer(vwr);
            if (vwr == null) {
                return;
            }
            this.updateToGraph(vwr.getGraph());
        }

        private void updateToGraph(InputGraph graph) {
            LinkedList<FolderElement> path = new LinkedList<FolderElement>();
            for (InputGraph p = graph; p != null; p = p.getParent()) {
                path.addFirst((FolderElement)p);
            }
            OutlineTopComponent.this.selectPathOrIgnore(graph, path);
        }

        public void stateChanged(DiagramViewerEvent ev) {
        }

        public void interactionChanged(DiagramViewerEvent ev) {
        }

        public void displayChanged(DiagramViewerEvent ev) {
        }

        public void diagramChanged(DiagramViewerEvent ev) {
            this.updateToGraph(ev.getModel().getGraphToView());
        }

        public void diagramReady(DiagramViewerEvent ev) {
        }
    }

    private static class SessionChildren
    extends Children.Keys
    implements ChangedListener<SessionManagerImpl> {
        private final SessionManagerImpl impl;

        public SessionChildren(SessionManagerImpl impl) {
            this.impl = impl;
        }

        protected void removeNotify() {
            this.impl.getChangedEvent().removeListener((Object)this);
            super.removeNotify();
        }

        protected void addNotify() {
            super.addNotify();
            this.impl.getChangedEvent().addListener((Object)this);
            this.changed(null);
        }

        public void changed(SessionManagerImpl source) {
            SwingUtilities.invokeLater(() -> this.setKeys(this.impl.getSessions()));
        }

        protected Node[] createNodes(Object t) {
            assert (t instanceof GraphDocument);
            return new Node[]{new SessionNode((Folder)((GraphDocument)t))};
        }
    }

    class NewDataExpander
    extends NodeAdapter {
        NewDataExpander() {
        }

        public void childrenAdded(NodeMemberEvent ev) {
            OutlineTopComponent.this.requestAttention(true);
            Node[] ns = ev.getDelta();
            if (ns.length == 0) {
                return;
            }
            if (ev.getNode() == OutlineTopComponent.this.root) {
                BeanTreeView btv = (BeanTreeView)OutlineTopComponent.this.treeView;
                btv.expandNode(ns[0]);
            } else if (ev.getNode().getParentNode() != OutlineTopComponent.this.root) {
                return;
            }
            ns[0].addNodeListener((NodeListener)this);
        }
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return OutlineTopComponent.getDefault();
        }
    }
}

