/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.coordinator.actions;

import java.util.List;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import org.graalvm.visualizer.coordinator.actions.GraphCloneCookie;
import org.graalvm.visualizer.data.services.GraphViewer;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.CookieAction;

public final class CloneGraphAction
extends CookieAction {
    protected void performAction(Node[] activatedNodes) {
        GraphCloneCookie c = (GraphCloneCookie)activatedNodes[0].getLookup().lookup(GraphCloneCookie.class);
        assert (c != null);
        c.openClone();
    }

    protected int mode() {
        return 8;
    }

    protected boolean enable(Node[] activatedNodes) {
        boolean b = super.enable(activatedNodes);
        if (b) {
            assert (activatedNodes.length == 1);
            GraphCloneCookie c = (GraphCloneCookie)activatedNodes[0].getLookup().lookup(GraphCloneCookie.class);
            InputGraph g = (InputGraph)activatedNodes[0].getLookup().lookup(InputGraph.class);
            if (c == null || g == null) {
                return false;
            }
            GraphViewer gv = (GraphViewer)Lookup.getDefault().lookup(GraphViewer.class);
            List viewers = gv.findCompatible(g);
            return !viewers.isEmpty();
        }
        return false;
    }

    public String getName() {
        return "Open clone";
    }

    protected Class<?>[] cookieClasses() {
        return new Class[]{GraphCloneCookie.class};
    }

    protected String iconResource() {
        return "org/graalvm/visualizer/coordinator/images/graph.png";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }
}

