/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.coordinator.actions;

import org.graalvm.visualizer.coordinator.actions.DiffGraphCookie;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;

public final class DiffGraphAction
extends CookieAction {
    protected void performAction(Node[] activatedNodes) {
        DiffGraphCookie c = (DiffGraphCookie)activatedNodes[0].getCookie(DiffGraphCookie.class);
        assert (c != null);
        c.openDiff();
    }

    protected int mode() {
        return 8;
    }

    protected boolean enable(Node[] activatedNodes) {
        boolean b = super.enable(activatedNodes);
        if (b) {
            assert (activatedNodes.length == 1);
            DiffGraphCookie c = (DiffGraphCookie)activatedNodes[0].getCookie(DiffGraphCookie.class);
            assert (c != null);
            return c.isPossible();
        }
        return false;
    }

    public String getName() {
        return NbBundle.getMessage(DiffGraphAction.class, (String)"CTL_DiffGraphAction");
    }

    protected Class<?>[] cookieClasses() {
        return new Class[]{DiffGraphCookie.class};
    }

    protected String iconResource() {
        return "org/graalvm/visualizer/coordinator/images/diff.png";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }
}

