/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.coordinator.actions;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import jdk.graal.compiler.graphio.parsing.DataBinaryWriter;
import jdk.graal.compiler.graphio.parsing.model.Folder;
import jdk.graal.compiler.graphio.parsing.model.FolderElement;
import jdk.graal.compiler.graphio.parsing.model.GraphDocument;
import jdk.graal.compiler.graphio.parsing.model.Group;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.Properties;
import org.graalvm.visualizer.coordinator.actions.Bundle;
import org.graalvm.visualizer.coordinator.impl.SessionManagerImpl;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;

class SaveOperation {
    private final SessionManagerImpl sessionMgr;
    private final boolean saveAs;
    private final Collection<Folder> folders = new ArrayList<Folder>();
    private final Map<GraphDocument, List<Folder>> sessionData = new LinkedHashMap<GraphDocument, List<Folder>>();
    private final Set<GraphDocument> selectedSessions = new HashSet<GraphDocument>();
    private final Map<GraphDocument, FileObject> files = new HashMap<GraphDocument, FileObject>();
    private boolean nonSessionsSelected;
    private boolean prepared;
    private Path userPath;
    private Path lastPath;
    private Path userFolder;
    private Style saveStyle = Style.FILES;
    private String userTitle;
    private final List<GraphDocument> documentOrder = new ArrayList<GraphDocument>();
    private final Map<GraphDocument, GraphDocument> documentOrigins = new HashMap<GraphDocument, GraphDocument>();
    private final List<GraphDocument> documentsToSave = new ArrayList<GraphDocument>();
    private DocumentPathProvider pathProvider = new IncrementPathProvider();
    private int documentsSaved;
    private static final int PROGRESS_THRESHOLD = 500;

    public SaveOperation(boolean saveAs, Collection<Folder> initial, SessionManagerImpl sessionImpl) {
        if (initial != null) {
            this.folders.addAll(initial);
        }
        this.saveAs = saveAs;
        this.sessionMgr = sessionImpl;
    }

    public void addFolders(Collection<Folder> toAdd) {
        this.folders.addAll(toAdd);
    }

    public boolean hasMultipleSessions() {
        return this.sessionData.size() > 1;
    }

    public boolean isSaveAs() {
        return this.saveAs;
    }

    public boolean hasGroups() {
        return this.nonSessionsSelected;
    }

    public Style getSaveStyle() {
        if (this.saveAs) {
            return this.saveStyle;
        }
        return Style.FILES;
    }

    public void setSaveStyle(Style saveStyle) {
        this.saveStyle = saveStyle;
    }

    public DocumentPathProvider getPathProvider() {
        return this.pathProvider;
    }

    public void setPathProvider(DocumentPathProvider pathProvider) {
        this.pathProvider = pathProvider;
    }

    public String getInitialFileComment() {
        if (this.sessionData.isEmpty()) {
            return null;
        }
        GraphDocument first = this.sessionData.keySet().iterator().next();
        return first.getProperties().getString("igv.userLabel", null);
    }

    public Path getUserPath() {
        return this.userPath;
    }

    public Path getUserFolder() {
        return this.userFolder;
    }

    public void setUserPath(Path userPath) {
        this.userPath = userPath;
        this.userFolder = userPath.getParent();
    }

    public String getUserTitle() {
        return this.userTitle;
    }

    public void setUserTitle(String userTitle) {
        this.userTitle = userTitle != null && userTitle.isEmpty() ? null : userTitle;
    }

    public int getDocumentsSaved() {
        return this.documentsSaved;
    }

    private void retainJustParents(List<Folder> folders) {
        Iterator<Folder> it = folders.iterator();
        block0: while (it.hasNext()) {
            Folder item = it.next();
            for (Folder candidate : folders) {
                if (candidate == item || !candidate.isParentOf((FolderElement)item)) continue;
                it.remove();
                continue block0;
            }
        }
    }

    private boolean savingEntireDocument(GraphDocument doc) {
        List<Folder> items = this.sessionData.get(doc);
        if (items == null || items.size() != 1) {
            return false;
        }
        return doc == items.get(0);
    }

    public boolean isFinished() {
        return this.documentOrder.isEmpty();
    }

    public void saveFileBoundSessions() {
        if (this.saveAs || this.nonSessionsSelected) {
            return;
        }
        ArrayList<GraphDocument> saved = new ArrayList<GraphDocument>();
        for (GraphDocument d : new ArrayList<GraphDocument>(this.documentOrder)) {
            FileObject f;
            if (!this.savingEntireDocument(d) || (f = this.getFile(d)) == null || !f.isValid()) continue;
            if (d.isModified()) {
                File jf = FileUtil.toFile((FileObject)f);
                DocumentSaver saver = new DocumentSaver(d, jf.toPath(), this.saveAs);
                saver.save();
                ++this.documentsSaved;
                this.sessionMgr.attachFile(d, f);
            }
            saved.add(d);
        }
        this.documentOrder.removeAll(saved);
        this.sessionData.keySet().removeAll(saved);
    }

    public GraphDocument firstDocumentToSave() {
        if (this.documentOrder.isEmpty()) {
            return null;
        }
        return this.documentOrder.get(0);
    }

    private void registerDocumentToSave(GraphDocument toSave, GraphDocument origin) {
        this.documentsToSave.add(toSave);
        this.documentOrigins.put(toSave, origin);
    }

    private synchronized void doPrepare() {
        if (this.prepared) {
            return;
        }
        for (Folder folder : this.folders) {
            GraphDocument gd = folder.getOwner();
            if (gd == null && folder instanceof GraphDocument) {
                gd = (GraphDocument)folder;
                this.selectedSessions.add(gd);
            } else {
                this.nonSessionsSelected = true;
            }
            this.sessionData.computeIfAbsent(gd, d -> new ArrayList()).add(folder);
        }
        for (List list : this.sessionData.values()) {
            this.retainJustParents(list);
        }
        for (GraphDocument graphDocument : this.sessionData.keySet()) {
            if (!(graphDocument instanceof Lookup.Provider)) continue;
            Lookup.Provider lp = (Lookup.Provider)graphDocument;
            FileObject storage = (FileObject)lp.getLookup().lookup(FileObject.class);
            this.files.put(graphDocument, storage);
        }
        this.documentOrder.addAll(this.sessionMgr.getSessions());
        this.documentOrder.retainAll(this.sessionData.keySet());
        if (!this.sessionData.isEmpty()) {
            this.sessionMgr.getSessionName(this.sessionData.keySet().iterator().next(), false);
        }
        this.prepared = true;
    }

    public boolean hasFile(GraphDocument gd) {
        return this.files.containsKey(gd);
    }

    public Set<GraphDocument> getSessions() {
        return new HashSet<GraphDocument>(this.sessionData.keySet());
    }

    public FileObject getFile(GraphDocument d) {
        if (d == null) {
            return null;
        }
        return this.files.get(d);
    }

    public void prepare() {
        this.doPrepare();
    }

    public void execute() {
        this.doPrepare();
        switch (this.saveStyle) {
            case GROUPS: {
                this.createFlatDocument();
                break;
            }
            case SESSIONS: {
                this.createStructuredDocument();
                break;
            }
            case FILES: {
                this.cloneSessions();
            }
        }
        boolean first = true;
        Path pathToSave = this.userPath;
        try {
            for (GraphDocument d : this.documentsToSave) {
                this.lastPath = pathToSave;
                if (first) {
                    this.setLabel((Folder)d, this.userTitle);
                    first = false;
                } else {
                    GraphDocument org = this.documentOrigins.get(d);
                    FileObject curFile = this.getFile(org);
                    pathToSave = null;
                    Path lp = this.lastPath;
                    if (curFile == null) {
                        lp = Paths.get(SessionManagerImpl.getInstance().getSessionName(org, false), new String[0]);
                        Path parent = this.lastPath == null ? null : this.lastPath.getParent();
                        pathToSave = this.getUsableFileName(parent == null ? lp : parent.resolve(lp), true);
                    }
                    if (this.pathProvider instanceof IncrementPathProvider) {
                        if (pathToSave == null) {
                            pathToSave = this.pathProvider.createPath(lp, d);
                        }
                    } else {
                        if (pathToSave == null) {
                            IncrementPathProvider ipp = new IncrementPathProvider();
                            pathToSave = ipp.createPath(this.lastPath, d);
                        }
                        pathToSave = this.pathProvider.createPath(pathToSave, d);
                    }
                }
                if (pathToSave == null) {
                    return;
                }
                boolean shouldPrompt = true;
                FileObject f = this.getFile(d);
                if (f != null && pathToSave.toFile().equals(FileUtil.toFile((FileObject)f))) {
                    shouldPrompt = this.saveAs;
                }
                DocumentSaver saver = new DocumentSaver(d, pathToSave, shouldPrompt);
                saver.save();
                ++this.documentsSaved;
                if (!this.selectedSessions.contains(d)) continue;
                FileObject fo = FileUtil.toFileObject((File)pathToSave.toFile());
                this.sessionMgr.attachFile(d, fo);
            }
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    private void cloneSessions() {
        for (GraphDocument origin : this.sessionData.keySet()) {
            GraphDocument nd = new GraphDocument();
            nd.getProperties().add(origin.getProperties());
            List<Folder> groups = this.sessionData.get(origin);
            if (groups.get(0) == origin) {
                nd = origin;
            } else {
                for (Folder f : groups) {
                    nd.addElement((FolderElement)f);
                }
            }
            this.registerDocumentToSave(nd, origin);
        }
    }

    void setLabel(Folder f, String label) {
        if (label == null || label.isEmpty()) {
            return;
        }
        if (!(f instanceof Properties.MutableOwner)) {
            return;
        }
        Properties.MutableOwner mo = (Properties.MutableOwner)f;
        Properties p = mo.writableProperties();
        p.setProperty("igv.userLabel", (Object)label);
        mo.updateProperties(p);
    }

    private void createFlatDocument() {
        GraphDocument singleDoc;
        GraphDocument nd = new GraphDocument();
        this.setLabel((Folder)nd, this.userTitle);
        if (!this.hasMultipleSessions() && this.savingEntireDocument(singleDoc = this.sessionData.keySet().iterator().next())) {
            this.registerDocumentToSave(singleDoc, singleDoc);
            return;
        }
        for (GraphDocument doc : this.documentOrder) {
            for (Folder g : this.sessionData.get(doc)) {
                if (g instanceof GraphDocument) {
                    GraphDocument gd = (GraphDocument)g;
                    g.getElements().forEach(item -> {
                        if (item instanceof Folder) {
                            nd.addElement(item);
                        }
                    });
                    continue;
                }
                nd.addElement((FolderElement)g);
            }
        }
        if (!this.hasMultipleSessions()) {
            GraphDocument original = this.sessionData.keySet().iterator().next();
            nd.getProperties().add(original.getProperties());
            this.registerDocumentToSave(nd, original);
        } else {
            this.registerDocumentToSave(nd, nd);
        }
    }

    private void createStructuredDocument() {
        boolean first = true;
        GraphDocument nd = new GraphDocument();
        for (GraphDocument origin : this.documentOrder) {
            List<Folder> groups = this.sessionData.get(origin);
            if (groups.size() == 1 && groups.get(0) == origin) {
                groups = new ArrayList<Folder>();
                for (FolderElement fe : origin.getElements()) {
                    if (!(fe instanceof Folder)) continue;
                    groups.add((Folder)fe);
                }
            }
            Group container = new Group((Folder)nd);
            nd.addElement((FolderElement)container);
            container.getProperties().add(origin.getProperties());
            container.addElements(groups);
            this.setLabel((Folder)container, this.sessionMgr.getSessionName(origin, true));
            if (!first) continue;
            first = false;
            nd.getProperties().add(container.getProperties());
        }
        this.setLabel((Folder)nd, this.userTitle);
        this.registerDocumentToSave(nd, nd);
    }

    File getUsableFileName(File file) {
        return this.getUsableFileName(file.toPath(), true).toFile();
    }

    Path getUsableFileName(Path path, boolean mustNotExist) {
        IncrementPathProvider provider = new IncrementPathProvider();
        provider.initFilename(path);
        Path p = provider.getInitialFile();
        if (!mustNotExist) {
            return p;
        }
        while (Files.exists(p, new LinkOption[0])) {
            p = provider.createPath(null, null);
        }
        return p;
    }

    public static enum Style {
        SESSIONS,
        GROUPS,
        FILES;

    }

    final class IncrementPathProvider
    implements DocumentPathProvider {
        private int counter;
        private String baseFilename;
        private String initialBasename;
        private String initialFilename;
        private Path folder;

        public Path getCurrentPath() {
            return this.folder.resolve(Paths.get(this.initialFilename, new String[0]));
        }

        void initFilename(Path suggested) {
            char c;
            int index;
            if (suggested == null) {
                suggested = SaveOperation.this.lastPath;
            }
            this.folder = suggested.getParent();
            if (this.folder == null) {
                this.folder = Paths.get("", new String[0]);
            }
            Path p = suggested.getFileName();
            assert (p != null);
            String s = p.toString();
            boolean digitsFound = false;
            this.initialBasename = s.toLowerCase(Locale.ENGLISH).endsWith(".bgv") ? (s = s.substring(0, s.length() - 4)) : s;
            this.initialFilename = this.initialBasename + ".bgv";
            for (index = s.length(); index > 0 && Character.isDigit(c = s.charAt(index - 1)); --index) {
                digitsFound = true;
            }
            this.counter = digitsFound ? Integer.parseInt(s.substring(index)) : 0;
            if (index > 1 && s.charAt(index - 1) == '-') {
                --index;
            }
            this.baseFilename = s.substring(0, index);
        }

        Path getInitialFile() {
            return this.folder.resolve(this.initialFilename);
        }

        @Override
        public Path createPath(Path suggestedPath, GraphDocument document) {
            Path fn;
            Path path = fn = suggestedPath == null ? null : suggestedPath.getFileName();
            if (this.baseFilename == null || fn != null && !fn.toString().startsWith(this.initialFilename)) {
                this.initFilename(suggestedPath);
            }
            if (document != null) {
                SaveOperation.this.setLabel((Folder)document, SaveOperation.this.userTitle);
            }
            return this.folder.resolve(this.baseFilename + "-" + ++this.counter + ".bgv");
        }
    }

    public static interface DocumentPathProvider {
        public Path createPath(Path var1, GraphDocument var2);
    }

    private static class DocumentSaver {
        private final GraphDocument doc;
        private final Path toFile;
        private final boolean toNewFile;

        public DocumentSaver(GraphDocument doc, Path toFile, boolean toNewFile) {
            this.doc = doc;
            this.toFile = toFile;
            this.toNewFile = toNewFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void save() {
            try {
                boolean exists = Files.exists(this.toFile, new LinkOption[0]);
                if (exists && this.toNewFile) {
                    NotifyDescriptor.Confirmation dd = new NotifyDescriptor.Confirmation((Object)Bundle.TEXT_FileExistsOverwrite(this.toFile.toString()), Bundle.TITLE_FileExistsOverwrite(), 1);
                    Object outcome = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
                    if (outcome != DialogDescriptor.YES_OPTION) {
                        if (outcome != DialogDescriptor.NO_OPTION) {
                            throw new CancellationException();
                        }
                        return;
                    }
                }
                Path target = this.toFile;
                try {
                    if (exists) {
                        Path fn = this.toFile.getFileName();
                        Path parent = this.toFile.getParent();
                        assert (fn != null);
                        assert (parent != null);
                        target = Files.createTempFile(parent, "temp_", fn.toString(), new FileAttribute[0]);
                    }
                    this.performSave(target.toFile());
                    if (this.toFile != target) {
                        Files.move(target, this.toFile, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                    }
                }
                finally {
                    if (target != this.toFile) {
                        Files.deleteIfExists(target);
                    }
                }
            }
            catch (InterruptedIOException exists) {
            }
            catch (IOException ex) {
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.ERR_Save(ex.toString()), 0));
            }
        }

        void performSave(final File f) throws IOException {
            final AtomicBoolean cHandle = new AtomicBoolean();
            List allItems = this.doc.getElements();
            final ProgressBridge bridge = new ProgressBridge(allItems, cHandle);
            String msg = allItems.isEmpty() ? Bundle.MSG_SavingEmpty() : Bundle.MSG_Saving(allItems.size(), ((FolderElement)allItems.get(0)).getName());
            final ProgressHandle handle = ProgressHandle.createHandle((String)msg, (Cancellable)bridge);
            final AtomicReference reportException = new AtomicReference();
            BaseProgressUtils.showProgressDialogAndRun((Runnable)new CancellableRunnable(){

                @Override
                public void run() {
                    bridge.setHandle(handle);
                    try {
                        DataBinaryWriter.export((File)f, (GraphDocument)doc, (Consumer)bridge, (AtomicBoolean)cHandle);
                    }
                    catch (IOException e) {
                        reportException.set(e);
                    }
                    catch (CancellationException e) {
                        reportException.set(new InterruptedIOException());
                        if (cHandle.get()) {
                            f.delete();
                        }
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.ERR_Save(e.toString()), 0));
                    }
                }

                public boolean cancel() {
                    return bridge.cancel();
                }
            }, (ProgressHandle)handle, (boolean)true);
            if (reportException.get() != null) {
                throw (IOException)reportException.get();
            }
        }
    }

    private static class ProgressBridge
    implements Consumer<FolderElement>,
    Cancellable {
        private ProgressHandle handle;
        private final Collection<? extends FolderElement> allItems;
        private int graphsCount;
        private final AtomicBoolean cancelHandle;
        private int counter;
        private final Deque<Group> parentGroups = new ArrayDeque<Group>();
        private long lastTimeRepored;

        public ProgressBridge(Collection<? extends FolderElement> allItems, AtomicBoolean cancelHandle) {
            this.allItems = allItems;
            this.cancelHandle = cancelHandle;
        }

        void setHandle(ProgressHandle handle) {
            this.handle = handle;
            handle.setDisplayName(Bundle.PROGRESS_CountingGraphs());
            handle.start();
            this.graphsCount = this.countGraphs();
            handle.switchToDeterminate(this.graphsCount);
        }

        @Override
        public void accept(FolderElement t) {
            if (this.handle == null) {
                return;
            }
            ++this.counter;
            long now = System.currentTimeMillis();
            if (this.lastTimeRepored + 500L < now) {
                this.lastTimeRepored = now;
                this.handle.progress(this.makeInfo((InputGraph)t), this.counter);
                this.handle.setDisplayName(Bundle.PROGRESS_SaveGraph(this.counter, this.graphsCount, t.getName(), ""));
            }
        }

        public boolean cancel() {
            this.cancelHandle.set(true);
            return true;
        }

        public AtomicBoolean getCancelHandle() {
            return this.cancelHandle;
        }

        public int countGraphs() {
            int count = 0;
            ArrayDeque<? extends FolderElement> toProcess = new ArrayDeque<FolderElement>(this.allItems);
            while (!toProcess.isEmpty()) {
                FolderElement el = (FolderElement)toProcess.poll();
                if (!(el instanceof Group)) continue;
                Group g = (Group)el;
                count += g.getGraphsCount();
                toProcess.addAll(g.getElements());
            }
            return count;
        }

        private String makeInfo(InputGraph g) {
            List elms;
            Folder f = g.getParent();
            while (!(f instanceof GraphDocument)) {
                this.parentGroups.push((Group)f);
                f = this.parentGroups.peek().getParent();
            }
            StringBuilder sb = new StringBuilder("<html><nobr>");
            Object spacing = "";
            Group actual = this.parentGroups.peek();
            assert (actual != null);
            while (!this.parentGroups.isEmpty()) {
                actual = this.parentGroups.pop();
                elms = actual.getParent().getElements();
                sb.append(Bundle.PROGRESS_SaveGroup(elms.indexOf(actual) + 1, elms.size(), actual.getName(), spacing)).append("<br>");
                spacing = (String)spacing + "&emsp;";
            }
            elms = actual.getElements();
            sb.append(Bundle.PROGRESS_SaveGraph(elms.indexOf(g) + 1, elms.size(), g.getName(), spacing));
            sb.append("</nobr></html>");
            return sb.toString();
        }
    }

    public static interface CancellableRunnable
    extends Runnable,
    Cancellable {
    }
}

