/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.coordinator.impl;

import java.util.Arrays;
import javax.swing.Action;
import jdk.graal.compiler.graphio.parsing.model.FolderElement;
import jdk.graal.compiler.graphio.parsing.model.Properties;
import org.openide.actions.RenameAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.Lookup;

public class AbstractOutlineNode
extends AbstractNode {
    private final FolderElement item;

    public AbstractOutlineNode(FolderElement item, Children children, Lookup lookup) {
        super(children, lookup);
        this.item = item;
        super.setName(this.getUserName());
    }

    protected String getUserName() {
        if (!(this.item instanceof Properties.Entity)) {
            return this.item.getName();
        }
        Properties.Entity entity = (Properties.Entity)this.item;
        String p = (String)entity.getProperties().get("igv.userLabel", String.class);
        if (p == null) {
            return this.item.getName();
        }
        return p;
    }

    public boolean canRename() {
        return this.item instanceof Properties.MutableOwner;
    }

    public void setName(String s) {
        super.setName(s);
        if (!this.canRename()) {
            throw new IllegalStateException();
        }
        Properties.MutableOwner mutableEntity = (Properties.MutableOwner)this.item;
        Properties props = mutableEntity.writableProperties();
        props.setProperty("igv.userLabel", (Object)s);
        mutableEntity.updateProperties(props);
    }

    public Action[] getActions(boolean context) {
        Action[] actions = super.getActions(context);
        actions = Arrays.copyOf(actions, actions.length + 1);
        actions[actions.length - 1] = RenameAction.get(RenameAction.class);
        return actions;
    }
}

