/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.coordinator.impl;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import jdk.graal.compiler.graphio.parsing.model.ChangedEvent;
import jdk.graal.compiler.graphio.parsing.model.ChangedEventProvider;
import jdk.graal.compiler.graphio.parsing.model.ChangedListener;
import jdk.graal.compiler.graphio.parsing.model.Folder;
import jdk.graal.compiler.graphio.parsing.model.FolderElement;
import jdk.graal.compiler.graphio.parsing.model.GraphClassifier;
import jdk.graal.compiler.graphio.parsing.model.GraphDocument;
import jdk.graal.compiler.graphio.parsing.model.Group;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.Properties;
import jdk.graal.compiler.graphio.parsing.model.Property;
import org.graalvm.visualizer.coordinator.actions.RemoveCookie;
import org.graalvm.visualizer.coordinator.impl.AbstractOutlineNode;
import org.graalvm.visualizer.coordinator.impl.Bundle;
import org.graalvm.visualizer.coordinator.impl.GraphNode;
import org.graalvm.visualizer.coordinator.impl.SessionManagerImpl;
import org.graalvm.visualizer.data.serialization.lazy.ReaderErrors;
import org.graalvm.visualizer.util.ListenerSupport;
import org.graalvm.visualizer.util.PropertiesSheet;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.awt.StatusDisplayer;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Cancellable;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class FolderNode
extends AbstractOutlineNode {
    private static final int PROGRESS_TIMEOUT = Integer.getInteger(FolderNode.class.getName() + ".progressTimeout", 5000);
    private static final int POOL_THRESHOLD = Integer.getInteger(FolderNode.class.getName() + ".poolThreshold", 200);
    private static final RequestProcessor REFRESH_RP = new RequestProcessor(FolderNode.class);
    private final InstanceContent content;
    protected final Folder folder;
    private boolean error;
    private final ChangedListener<FolderElement> l = new ChangedListener<FolderElement>(){

        public void changed(FolderElement source) {
            SwingUtilities.invokeLater(FolderNode.this::refreshError);
        }
    };
    private static final FolderElement WAIT_KEY = new FolderElement(){
        private final ChangedEvent<FolderElement> silentEvent = new ChangedEvent<FolderElement>((FolderElement)this){

            public void removeListener(ChangedListener<FolderElement> l) {
            }

            public void addListener(ChangedListener<FolderElement> l) {
            }
        };

        public Folder getParent() {
            return null;
        }

        public String getName() {
            return "(wait)";
        }

        public void setParent(Folder parent) {
        }

        public Object getID() {
            return this;
        }
    };
    private static final String PREFIX_VERSION = "version.";

    protected Sheet createSheet() {
        Sheet s = super.createSheet();
        if (this.folder instanceof Properties.Entity) {
            Properties.Entity pen = (Properties.Entity)this.folder;
            Sheet.Set props = Sheet.createPropertiesSet();
            Sheet.Set versions = new Sheet.Set();
            versions.setName("versions");
            versions.setDisplayName(Bundle.TITLE_Versions());
            ArrayList versionProps = new ArrayList();
            pen.getProperties().forEach(p -> {
                if (p.getName().startsWith("igv.")) {
                    return;
                }
                if (p.getName().startsWith(PREFIX_VERSION)) {
                    versionProps.add(p);
                } else {
                    props.put(PropertiesSheet.createSheetProperty((String)p.getName(), (Properties)pen.getProperties()));
                }
            });
            s.put(props);
            if (!versionProps.isEmpty()) {
                Collections.sort(versionProps, (a, b) -> a.getName().compareTo(b.getName()));
                for (Property p2 : versionProps) {
                    versions.put(PropertiesSheet.createSheetProperty((String)p2.getName(), (String)p2.getName().substring(PREFIX_VERSION.length()), (Properties)pen.getProperties()));
                }
                versions.setExpert(true);
                s.put(versions);
            }
        }
        return s;
    }

    public Image getIcon(int i) {
        if (this.error) {
            return ImageUtilities.mergeImages((Image)super.getIcon(i), (Image)ImageUtilities.loadImage((String)"org/graalvm/visualizer/coordinator/images/error-glyph.gif"), (int)10, (int)6);
        }
        return super.getIcon(i);
    }

    public FolderNode(Folder folder) {
        this(folder, (Children)new FolderChildren(folder), new InstanceContent());
    }

    public FolderNode(Folder folder, Children ch) {
        this(folder, ch, new InstanceContent());
    }

    private FolderNode(Folder folder, Children children, InstanceContent content) {
        super((FolderElement)folder, children, (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        this.folder = folder;
        this.content = content;
        if (folder != null) {
            Folder folderElement = folder;
            content.add((Object)new RemoveCookie(){
                final /* synthetic */ FolderElement val$folderElement;
                {
                    this.val$folderElement = folderElement;
                }

                @Override
                public void remove() {
                    if (this.val$folderElement instanceof GraphDocument) {
                        SessionManagerImpl.getInstance().removeElement(this.val$folderElement);
                    } else {
                        this.val$folderElement.getParent().removeElement(this.val$folderElement);
                    }
                }
            });
            content.add((Object)folder);
        }
        if (folder instanceof ChangedEventProvider) {
            ChangedEvent ev = ((ChangedEventProvider)folder).getChangedEvent();
            ListenerSupport.addWeakListener(this.l, (ChangedEvent)ev);
        }
        this.setIconBaseWithExtension("org/graalvm/visualizer/coordinator/images/folder.png");
        this.refreshError();
    }

    private void refreshError() {
        if (!(this.folder instanceof FolderElement)) {
            return;
        }
        Folder el = this.folder;
        boolean newError = ReaderErrors.containsError((FolderElement)el, (boolean)true);
        if (this.error != newError) {
            this.error = newError;
            this.fireIconChange();
        }
    }

    public Image getOpenedIcon(int i) {
        return this.getIcon(i);
    }

    static class FolderChildren
    extends Children.Keys<FolderElement>
    implements ChangedListener<Folder> {
        private final Folder folder;
        private ChangedListener l;
        private RequestProcessor.Task refreshTask;
        private boolean feedbackGone;

        public FolderChildren(Folder folder) {
            this.folder = folder;
        }

        protected Node[] createNodes(FolderElement e) {
            AbstractNode n;
            Node[] ret = new Node[1];
            if (e == WAIT_KEY) {
                n = new WaitNode();
            } else if (e instanceof InputGraph && GraphClassifier.DEFAULT_CLASSIFIER.knownGraphTypes().contains(((InputGraph)e).getGraphType())) {
                n = new GraphNode((InputGraph)e);
            } else if (e instanceof Folder) {
                n = new FolderNode((Folder)e);
            } else {
                return null;
            }
            ret[0] = n;
            return ret;
        }

        public void addNotify() {
            this.l = ListenerSupport.addWeakListener((ChangedListener)this, (ChangedEvent)this.folder.getChangedEvent());
            this.refreshKeys();
        }

        protected void removeNotify() {
            if (this.l != null) {
                this.folder.getChangedEvent().removeListener((Object)this.l);
            }
            this.setKeys(Collections.emptyList());
            super.removeNotify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void changed(Folder source) {
            FolderChildren folderChildren = this;
            synchronized (folderChildren) {
                if (this.refreshTask == null) {
                    this.refreshTask = REFRESH_RP.post(this::refreshKeys, POOL_THRESHOLD);
                }
            }
        }

        private synchronized void refreshKeys() {
            ArrayList<FolderElement> elements;
            this.refreshTask = null;
            if (this.folder instanceof Group.LazyContent) {
                Group.LazyContent lazyFolder = (Group.LazyContent)this.folder;
                Feedback feedback = new Feedback();
                Future fContents = lazyFolder.completeContents((Group.Feedback)feedback);
                if (!fContents.isDone()) {
                    feedback.setFuture(fContents);
                    elements = new ArrayList<FolderElement>((Collection)lazyFolder.partialData());
                    if (!this.feedbackGone) {
                        elements.add(WAIT_KEY);
                    }
                } else {
                    try {
                        elements = (List)fContents.get();
                    }
                    catch (InterruptedException | CancellationException | ExecutionException ex) {
                        return;
                    }
                }
            } else {
                elements = this.folder.getElements();
            }
            this.setKeys(elements);
        }

        class Feedback
        implements Group.Feedback,
        Cancellable,
        Runnable {
            final AtomicBoolean cancelled = new AtomicBoolean();
            ProgressHandle handle;
            Future f;
            boolean indeterminate;
            RequestProcessor.Task cancelIndeterminate = REFRESH_RP.create((Runnable)this, true);
            boolean removed;
            int lastTotal;

            Feedback() {
            }

            String name() {
                return FolderChildren.this.folder.getName();
            }

            void setFuture(Future f) {
                this.f = f;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = this;
                synchronized (object) {
                    if (!this.indeterminate) {
                        return;
                    }
                    this.init(1);
                    this.handle.finish();
                    this.removed = true;
                }
                object = FolderChildren.this;
                synchronized (object) {
                    FolderChildren.this.feedbackGone = true;
                }
                FolderChildren.this.refreshKeys();
            }

            private void init(int total) {
                if (this.removed) {
                    return;
                }
                if (this.handle == null) {
                    this.handle = ProgressHandle.createHandle((String)Bundle.MSG_Loading(this.name()), (Cancellable)this);
                    if (total > 0) {
                        this.handle.start(total);
                    } else {
                        this.handle.start();
                        this.handle.switchToIndeterminate();
                        this.indeterminate = true;
                    }
                    this.lastTotal = total;
                } else if (this.indeterminate && total > 0) {
                    this.handle.switchToDeterminate(total);
                    this.lastTotal = total;
                } else if (this.lastTotal < total) {
                    this.handle.switchToDeterminate(total);
                    this.lastTotal = total;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void reportProgress(int workDone, int totalWork, String description) {
                Feedback feedback = this;
                synchronized (feedback) {
                    this.init(totalWork);
                    if (this.removed) {
                        return;
                    }
                }
                if (description != null) {
                    if (totalWork > 0) {
                        this.handle.progress(description, Math.min(this.lastTotal, workDone));
                    } else {
                        this.handle.progress(description);
                    }
                } else if (totalWork > 0) {
                    this.handle.progress(Math.min(this.lastTotal, workDone));
                }
                if (this.indeterminate) {
                    this.cancelIndeterminate.schedule(PROGRESS_TIMEOUT);
                }
            }

            public boolean isCancelled() {
                return this.cancelled.get();
            }

            public boolean cancel() {
                this.f.cancel(true);
                return !this.cancelled.getAndSet(true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void finish() {
                Object object = this;
                synchronized (object) {
                    if (this.removed) {
                        return;
                    }
                    this.init(1);
                    this.handle.finish();
                }
                object = FolderChildren.this;
                synchronized (object) {
                    if (!this.f.isDone()) {
                        StatusDisplayer.getDefault().setStatusText(Bundle.MSG_ExpansionFailed(this.name()), 1000);
                    } else if (this.f.isCancelled()) {
                        StatusDisplayer.getDefault().setStatusText(Bundle.MSG_ExpansionCancelled(this.name()), 1000);
                    }
                }
            }

            public void reportError(List<FolderElement> parents, List<String> parentNames, String name, String errorMessage) {
                SessionManagerImpl.reportLoadingError(parents, parentNames, name, errorMessage);
            }
        }
    }

    static class WaitNode
    extends AbstractNode {
        public WaitNode() {
            super(Children.LEAF);
            this.setDisplayName(Bundle.TITLE_PleaseWait());
            this.setIconBaseWithExtension("org/graalvm/visualizer/coordinator/images/wait.gif");
        }
    }
}

