/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.coordinator.impl;

import java.awt.Image;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import jdk.graal.compiler.graphio.parsing.model.ChangedListener;
import jdk.graal.compiler.graphio.parsing.model.FolderElement;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.Properties;
import org.graalvm.visualizer.coordinator.actions.CloneGraphAction;
import org.graalvm.visualizer.coordinator.actions.DiffGraphAction;
import org.graalvm.visualizer.coordinator.actions.DiffGraphCookie;
import org.graalvm.visualizer.coordinator.actions.GraphCloneCookie;
import org.graalvm.visualizer.coordinator.actions.GraphOpenCookie;
import org.graalvm.visualizer.coordinator.actions.GraphRemoveCookie;
import org.graalvm.visualizer.data.serialization.lazy.ReaderErrors;
import org.graalvm.visualizer.data.services.GraphViewer;
import org.graalvm.visualizer.util.GraphTypes;
import org.graalvm.visualizer.util.PropertiesSheet;
import org.openide.actions.OpenAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.Sheet;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class GraphNode
extends AbstractNode {
    private InputGraph graph;
    private boolean error;
    private Image baseIcon;
    private final ChangedListener l = new ChangedListener(){

        public void changed(Object source) {
            SwingUtilities.invokeLater(GraphNode.this::refreshError);
        }
    };
    private static final int DISPLAY_NAME_LIMIT = 2000;

    public GraphNode(InputGraph graph) {
        this(graph, new InstanceContent());
    }

    private GraphNode(InputGraph graph, InstanceContent content) {
        super(Children.LEAF, (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        this.graph = graph;
        Object name = graph.getName();
        if (((String)name).length() > 2000) {
            name = ((String)name).substring(0, 2000) + "...";
        }
        this.setDisplayName((String)name);
        content.add((Object)graph);
        GraphViewer viewer = (GraphViewer)Lookup.getDefault().lookup(GraphViewer.class);
        if (viewer != null) {
            content.add((Object)new GraphOpenCookie(viewer, graph));
        }
        content.add((Object)new GraphRemoveCookie(graph));
        content.add((Object)new DiffGraphCookie(graph));
        content.add((Object)new GraphCloneCookie(viewer, graph));
        this.addNodeListener((NodeListener)new NodeAdapter(){

            public void childrenRemoved(NodeMemberEvent ev) {
                GraphNode.this.graph = null;
            }
        });
        this.refreshError();
    }

    private void refreshError() {
        boolean newError = ReaderErrors.containsError((FolderElement)this.graph, (boolean)false);
        if (this.error != newError) {
            this.error = newError;
            this.fireIconChange();
        }
    }

    protected Sheet createSheet() {
        Sheet s = super.createSheet();
        Properties p = Properties.newProperties();
        p.add(this.graph.getProperties());
        p.setProperty("nodeCount", (Object)Integer.toString(this.graph.getNodeCount()));
        p.setProperty("edgeCount", (Object)Integer.toString(this.graph.getEdgeCount()));
        PropertiesSheet.initializeSheet((Properties)p, (Sheet)s);
        return s;
    }

    public Image getIcon(int i) {
        if (this.baseIcon == null) {
            GraphTypes tt = (GraphTypes)Lookup.getDefault().lookup(GraphTypes.class);
            Node n = tt.getTypeNode(this.graph.getGraphType());
            this.baseIcon = n.getIcon(i);
        }
        if (this.error) {
            return ImageUtilities.mergeImages((Image)this.baseIcon, (Image)ImageUtilities.loadImage((String)"org/graalvm/visualizer/coordinator/images/error-glyph.gif"), (int)10, (int)6);
        }
        return this.baseIcon;
    }

    public Image getOpenedIcon(int i) {
        return this.getIcon(i);
    }

    public Action[] getActions(boolean b) {
        return new Action[]{(Action)DiffGraphAction.findObject(DiffGraphAction.class, (boolean)true), (Action)CloneGraphAction.findObject(CloneGraphAction.class, (boolean)true), (Action)OpenAction.findObject(OpenAction.class, (boolean)true)};
    }

    public Action getPreferredAction() {
        return (Action)OpenAction.findObject(OpenAction.class, (boolean)true);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof GraphNode) {
            return this.graph == ((GraphNode)((Object)obj)).graph;
        }
        return false;
    }

    public int hashCode() {
        return this.graph.hashCode();
    }
}

