/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.coordinator.impl;

import jdk.graal.compiler.graphio.parsing.model.GraphDocument;
import jdk.graal.compiler.graphio.parsing.model.Properties;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class ManagedSessionImpl
extends GraphDocument
implements Lookup.Provider {
    private final InstanceContent ic = new InstanceContent();
    private final Lookup lkp = new AbstractLookup((AbstractLookup.Content)this.ic);
    private FileObject savedAs;

    public ManagedSessionImpl(Object id, Properties initialValues) {
        this(id, (FileObject)null);
        initialValues.iterator().forEachRemaining(p -> {
            if (!"name".equals(p.getName())) {
                this.getProperties().setProperty(p.getName(), p.getValue());
            }
        });
    }

    public ManagedSessionImpl(FileObject file) {
        this(null, file);
    }

    private ManagedSessionImpl(Object id, FileObject file) {
        this.setDocumentId(id);
        this.savedAs = file;
        if (file != null) {
            this.ic.add((Object)file);
        } else {
            this.setModified(true);
        }
    }

    void setSaveAs(FileObject f) {
        FileObject prev = this.savedAs;
        this.savedAs = f;
        if (prev != null) {
            this.ic.remove((Object)prev);
        }
        if (f != null) {
            this.ic.add((Object)f);
        }
        boolean wasModified = this.isModified();
        this.setModified(false);
        if (!wasModified) {
            this.getChangedEvent().fire();
        }
    }

    public Lookup getLookup() {
        return this.lkp;
    }
}

