/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jumpto.common;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.jumpto.common.AbstractModelFilter;
import org.netbeans.modules.jumpto.common.Models;
import org.netbeans.modules.jumpto.common.Utils;
import org.netbeans.spi.jumpto.type.SearchType;
import org.openide.util.Parameters;

public final class CurrentSearch<T> {
    private final Callable<AbstractModelFilter<T>> filterFactory;
    private String currentText;
    private SearchType currentType;
    private String currentScope;
    private AbstractModelFilter<T> filter;
    private final Map<Class<?>, Object> attrs;

    public CurrentSearch(@NonNull Callable<AbstractModelFilter<T>> filterFactory) {
        Parameters.notNull((CharSequence)"filterFactory", filterFactory);
        this.filterFactory = filterFactory;
        this.attrs = new HashMap();
        this.resetFilter();
    }

    public synchronized boolean isNarrowing(@NonNull SearchType searchType, @NonNull String searchText, @NullAllowed String searchScope, boolean correctCase) {
        if (this.currentType == null || this.currentText == null) {
            return false;
        }
        return Objects.equals(this.currentScope, searchScope) && (correctCase || Utils.isCaseSensitive(this.currentType) == Utils.isCaseSensitive(searchType)) && Utils.isNarrowing(this.currentType, searchType, this.currentText, searchText);
    }

    public synchronized void filter(@NonNull SearchType searchType, @NonNull String searchText, @NullAllowed Map<String, Object> options) {
        this.filter.configure(searchType, searchText, options);
    }

    @NonNull
    public synchronized Models.Filter<T> resetFilter() {
        this.currentType = null;
        this.currentText = null;
        try {
            this.filter = this.filterFactory.call();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.filter;
    }

    public synchronized void searchCompleted(@NonNull SearchType searchType, @NonNull String searchText, @NullAllowed String searchScope) {
        this.currentType = searchType;
        this.currentText = searchText;
        this.currentScope = searchScope;
    }

    @CheckForNull
    public synchronized <T> T setAttribute(@NonNull Class<T> clz, @NullAllowed T instance) {
        Parameters.notNull((CharSequence)"cls", clz);
        if (instance == null) {
            return clz.cast(this.attrs.remove(clz));
        }
        return clz.cast(this.attrs.put(clz, instance));
    }

    @CheckForNull
    public synchronized <T> T getAttribute(@NonNull Class<T> clz) {
        Parameters.notNull((CharSequence)"clz", clz);
        return clz.cast(this.attrs.get(clz));
    }
}

