/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.graphio.parsing.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import jdk.graal.compiler.graphio.parsing.model.Properties;

public class GraphClassifier {
    public static final String STRUCTURED_GRAPH = "StructuredGraph";
    public static final String CALL_GRAPH = "CallGraph";
    public static final String DEFAULT_TYPE = "defaultType";
    public static final GraphClassifier DEFAULT_CLASSIFIER = new GraphClassifier();
    private static final Set<String> KNOWN_TYPES = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("StructuredGraph", "CallGraph", "defaultType")));

    public String classifyGraphType(Properties properties) {
        String g = properties.get("graph", String.class);
        if (g != null) {
            if (g.startsWith(STRUCTURED_GRAPH)) {
                return STRUCTURED_GRAPH;
            }
            if (g.contains("inline")) {
                return CALL_GRAPH;
            }
        }
        return DEFAULT_TYPE;
    }

    public Set<String> knownGraphTypes() {
        return KNOWN_TYPES;
    }
}

