/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import jdk.graal.compiler.graphio.parsing.model.Folder;
import jdk.graal.compiler.graphio.parsing.model.FolderElement;
import jdk.graal.compiler.graphio.parsing.model.GraphDocument;
import jdk.graal.compiler.graphio.parsing.model.Group;

public class DataElementHandle {
    private final GraphDocument document;
    private final List<Object> path;

    DataElementHandle(GraphDocument document, List<Object> path) {
        this.document = document;
        this.path = new ArrayList<Object>(path);
    }

    DataElementHandle(GraphDocument document, FolderElement fe) {
        this.document = document;
        ArrayList<Object> ll = new ArrayList<Object>();
        ll.add(fe.getID());
        Folder ff = fe.getParent();
        while (ff != null && ff != document) {
            Folder fc = ff;
            ll.add(0, fc.getID());
            ff = fc.getParent();
        }
        this.path = ll;
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + Objects.hashCode(this.document);
        hash = 79 * hash + Objects.hashCode(this.path);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataElementHandle other = (DataElementHandle)obj;
        if (!Objects.equals(this.document, other.document)) {
            return false;
        }
        return Objects.equals(this.path, other.path);
    }

    public GraphDocument getOwner() {
        return this.document;
    }

    public Object getID() {
        return this.path.get(this.path.size() - 1);
    }

    public static DataElementHandle create(GraphDocument document, List<Object> path) {
        return new DataElementHandle(document, path);
    }

    public static DataElementHandle create(GraphDocument document, FolderElement e) {
        if (!document.isParentOf(e)) {
            throw new IllegalArgumentException(e + " is not owned by " + document);
        }
        return new DataElementHandle(document, e);
    }

    public CompletableFuture<FolderElement> resolve(Group.Feedback feedback) {
        GraphDocument f = this.document;
        return CompletableFuture.supplyAsync(() -> {
            Folder c = f;
            FolderElement result = null;
            block2: for (Object s : this.path) {
                if (c instanceof Group.LazyContent) {
                    Group.LazyContent lazy = (Group.LazyContent)((Object)c);
                    Future future = lazy.completeContents(feedback);
                    try {
                        for (FolderElement fe : (Collection)future.get()) {
                            if (!s.equals(fe.getID())) continue;
                            if (fe instanceof Folder) {
                                c = (Folder)fe;
                                continue block2;
                            }
                            result = fe;
                            break block2;
                        }
                    }
                    catch (InterruptedException | ExecutionException ex) {
                        throw new CompletionException(ex);
                    }
                } else {
                    for (FolderElement folderElement : c.getElements()) {
                        if (!s.equals(folderElement.getID())) continue;
                        result = folderElement;
                        break;
                    }
                }
                if (!(result instanceof Folder)) break;
                c = (Folder)result;
            }
            if (result == null) {
                return c;
            }
            return result;
        });
    }
}

