/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.data.serialization.lazy;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.graalvm.visualizer.data.serialization.lazy.CachedContent;

public class FileContent
implements ReadableByteChannel,
CachedContent,
AutoCloseable {
    private final Path filePath;
    private FileChannel ioDelegate;
    private boolean eof;
    private boolean selfOpened;
    private final AtomicInteger subchannelCount = new AtomicInteger();

    public FileContent(Path filePath, FileChannel channel) {
        this.filePath = filePath;
        this.ioDelegate = channel;
    }

    @Override
    public String id() {
        return this.filePath.toString();
    }

    private synchronized void openDelegate() throws IOException {
        if (this.ioDelegate == null || !this.ioDelegate.isOpen()) {
            this.ioDelegate = FileChannel.open(this.filePath, StandardOpenOption.READ);
            this.selfOpened = true;
        }
    }

    @Override
    public boolean resetCache(long offset) {
        return false;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (this.eof) {
            throw new EOFException();
        }
        this.openDelegate();
        int count = this.ioDelegate.read(dst);
        if (count < 0) {
            this.eof = true;
            return count;
        }
        return count;
    }

    @Override
    public boolean isOpen() {
        return this.ioDelegate.isOpen();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.selfOpened) {
            this.ioDelegate.close();
        }
        this.ioDelegate = null;
    }

    private Void subchannelClosed() throws IOException {
        if (this.subchannelCount.decrementAndGet() == 0) {
            this.close();
        }
        return null;
    }

    private ReadableByteChannel createLargeChannel(long start, long end) throws IOException {
        ArrayList<MappedByteBuffer> buffers = new ArrayList<MappedByteBuffer>();
        while (end - start >= Integer.MAX_VALUE) {
            MappedByteBuffer mbb = this.ioDelegate.map(FileChannel.MapMode.READ_ONLY, start, Integer.MAX_VALUE);
            buffers.add(mbb);
            start += Integer.MAX_VALUE;
        }
        if (end > start) {
            buffers.add(this.ioDelegate.map(FileChannel.MapMode.READ_ONLY, start, end - start));
        }
        return new BufferListChannel(buffers.iterator(), this::subchannelClosed);
    }

    @Override
    public ReadableByteChannel subChannel(long start, long end) throws IOException {
        this.openDelegate();
        if (end == -1L) {
            end = this.ioDelegate.size();
        }
        if (end - start >= Integer.MAX_VALUE) {
            return this.createLargeChannel(start, end);
        }
        final MappedByteBuffer mbb = this.ioDelegate.map(FileChannel.MapMode.READ_ONLY, start, end - start);
        this.subchannelCount.incrementAndGet();
        return new ReadableByteChannel(){
            private boolean closed;
            private boolean eof;

            @Override
            public int read(ByteBuffer dst) throws IOException {
                if (mbb.remaining() == 0) {
                    this.eof = true;
                    return -1;
                }
                if (this.eof) {
                    throw new EOFException();
                }
                if (this.closed) {
                    throw new ClosedChannelException();
                }
                if (dst.remaining() < mbb.remaining()) {
                    MappedByteBuffer b = mbb.duplicate();
                    int count = dst.remaining();
                    int pos = mbb.position() + count;
                    ((ByteBuffer)b).limit(pos);
                    dst.put(b);
                    mbb.position(pos);
                    return count;
                }
                int count = mbb.remaining();
                dst.put(mbb);
                return count;
            }

            @Override
            public boolean isOpen() {
                return !this.closed;
            }

            @Override
            public void close() throws IOException {
                boolean c = this.closed;
                this.closed = true;
                if (!this.closed) {
                    FileContent.this.subchannelClosed();
                }
            }
        };
    }

    public static final class BufferListChannel
    implements ReadableByteChannel {
        private final Callable<Void> closeHandler;
        private Iterator<ByteBuffer> buffers;
        private ByteBuffer current;
        private boolean eof;

        public BufferListChannel(Iterator<ByteBuffer> buffers, Callable<Void> closeHandler) {
            this.buffers = buffers;
            this.current = buffers.next();
            this.closeHandler = closeHandler;
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            if (this.eof) {
                throw new EOFException();
            }
            do {
                if (this.current != null && this.current.remaining() != 0) continue;
                if (!this.buffers.hasNext()) {
                    this.eof = true;
                    this.buffers = null;
                    this.current = null;
                    return -1;
                }
                this.current = this.buffers.next();
            } while (this.current.remaining() == 0);
            int cnt = 0;
            if (this.current.remaining() <= dst.remaining()) {
                cnt = this.current.remaining();
                dst.put(this.current);
                this.current = null;
                return cnt;
            }
            cnt = dst.remaining();
            ByteBuffer from = this.current.duplicate();
            from.limit(from.position() + dst.remaining());
            dst.put(from);
            this.current.position(from.limit());
            return cnt;
        }

        @Override
        public boolean isOpen() {
            return !this.eof;
        }

        @Override
        public void close() throws IOException {
            this.eof = true;
            if (this.closeHandler != null) {
                try {
                    this.closeHandler.call();
                }
                catch (IOException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new IOException(ex);
                }
            }
        }
    }
}

