/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.data.serialization.lazy;

import java.util.Objects;
import jdk.graal.compiler.graphio.parsing.Builder;
import jdk.graal.compiler.graphio.parsing.ConstantPool;
import jdk.graal.compiler.graphio.parsing.ModelBuilder;
import jdk.graal.compiler.graphio.parsing.ParseMonitor;
import jdk.graal.compiler.graphio.parsing.model.Folder;
import jdk.graal.compiler.graphio.parsing.model.FolderElement;
import jdk.graal.compiler.graphio.parsing.model.GraphDocument;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import jdk.graal.compiler.graphio.parsing.model.Properties;
import org.graalvm.visualizer.data.serialization.lazy.LazyGraph;
import org.graalvm.visualizer.data.serialization.lazy.LazyModelBuilder;
import org.graalvm.visualizer.data.serialization.lazy.StreamEntry;
import org.netbeans.api.annotations.common.NonNull;

final class GraphBuilder
extends LazyModelBuilder {
    private final InputGraph toComplete;
    private final DG dummyGraph = new DG(null, -1, "dummy", new Object[0]);
    private final Object keepData;
    private final ConstantPool pool;
    private final StreamEntry graphEntry;

    public GraphBuilder(GraphDocument rootDocument, InputGraph toComplete, Object keepData, StreamEntry entry, ParseMonitor monitor) {
        super(rootDocument, monitor);
        this.keepData = keepData;
        this.toComplete = toComplete;
        this.graphEntry = entry;
        this.pool = entry.getInitialPool().copy();
        this.pushGroup(toComplete.getGroup(), false);
    }

    @Override
    @NonNull
    public ConstantPool getConstantPool() {
        return this.pool;
    }

    @Override
    protected InputGraph createGraph(Properties.Entity parent, int dumpId, String format, Object[] args) {
        if (parent == this.toComplete.getGroup() && this.toComplete.getName().equals(ModelBuilder.makeGraphName(dumpId, format, args))) {
            return this.dummyGraph;
        }
        if (parent instanceof InputNode) {
            return super.doCreateGraph(parent, new NestedGraphId(this.graphEntry, dumpId, format), dumpId, format, args);
        }
        return super.createGraph(parent, dumpId, format, args);
    }

    public InputGraph.GraphData data() {
        return this.dummyGraph.data();
    }

    @Override
    protected InputNode createNode(int id, Builder.NodeClass nodeClass) {
        this.reportProgress();
        return new InputNode(id, nodeClass, this.keepData);
    }

    @Override
    protected void registerToParent(Folder parent, FolderElement item) {
        if (item == this.dummyGraph || parent == this.toComplete.getGroup()) {
            return;
        }
        super.registerToParent(parent, item);
    }

    @Override
    public void end() {
        super.end();
    }

    static class DG
    extends InputGraph {
        public DG(Object id, int dumpId, String format, Object[] args) {
            super(id, dumpId, format, args);
        }

        @Override
        protected InputGraph.GraphData data() {
            return super.data();
        }

        void copyData(LazyGraph target) {
        }
    }

    static final class NestedGraphId {
        private final Object outerGraph;
        private final int nodeId;
        private final String property;

        public NestedGraphId(Object outerGraph, int nodeId, String property) {
            this.outerGraph = outerGraph;
            this.nodeId = nodeId;
            this.property = property;
        }

        public int hashCode() {
            int hash = 7;
            hash = 67 * hash + Objects.hashCode(this.outerGraph);
            hash = 67 * hash + this.nodeId;
            hash = 67 * hash + Objects.hashCode(this.property);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NestedGraphId other = (NestedGraphId)obj;
            if (this.nodeId != other.nodeId) {
                return false;
            }
            if (!Objects.equals(this.property, other.property)) {
                return false;
            }
            return Objects.equals(this.outerGraph, other.outerGraph);
        }
    }
}

