/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.data.serialization.lazy;

import java.util.BitSet;

final class GraphMetadata {
    final BitSet nodeIds = new BitSet();
    final BitSet changedNodeIds = new BitSet();
    private int highestNodeId = -1;
    private int edgeCount;
    private int nodeCount;
    private boolean duplicate;

    GraphMetadata() {
    }

    void addEdge(int from, int to) {
        ++this.edgeCount;
    }

    void addNode(int id) {
        this.nodeIds.set(id);
        if (this.highestNodeId < id) {
            this.highestNodeId = id;
        }
        ++this.nodeCount;
    }

    public BitSet getNodeIds() {
        return this.nodeIds;
    }

    void markDuplicate() {
        this.duplicate = true;
    }

    public boolean isDuplicate() {
        return this.duplicate;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public int getEdgeCount() {
        return this.edgeCount;
    }

    public void nodeChanged(int id) {
        this.changedNodeIds.set(id);
    }

    public int getHighestNodeId() {
        return this.highestNodeId;
    }
}

