/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.data.serialization.lazy;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import jdk.graal.compiler.graphio.parsing.model.Group;
import org.graalvm.visualizer.data.serialization.lazy.Completer;

class LoadSupport<T>
implements Group.LazyContent<T> {
    private static final Logger LOG = Logger.getLogger(LoadSupport.class.getName());
    private static final Reference EMPTY = new WeakReference<Object>(null);
    final Completer<T> completer;
    static boolean _testUseWeakRefs;
    private volatile Reference<Future<T>> processing = EMPTY;
    private String name;
    private Reference<Future> getContentsRef = new WeakReference<Object>(null);

    public LoadSupport(Completer<T> completer) {
        this.completer = completer;
    }

    void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isComplete() {
        if (this.completer == null) {
            return true;
        }
        if (!this.completer.canComplete()) {
            return true;
        }
        Future<T> f = this.processing.get();
        return f != null && f.isDone();
    }

    @Override
    public T partialData() {
        T data;
        Future<T> f = this.processing.get();
        if (this.completer == null) {
            data = this.emptyData();
        } else {
            data = this.completer.partialData();
            if (data == null) {
                data = this.emptyData();
            }
        }
        if (f != null && f.isDone()) {
            try {
                return f.get();
            }
            catch (InterruptedException | CancellationException | ExecutionException ex) {
                Logger.getLogger(LoadSupport.class.getName()).log(Level.SEVERE, null, ex);
                return this.emptyData();
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getContents() {
        try {
            Future<T> wait;
            LoadSupport loadSupport = this;
            synchronized (loadSupport) {
                T x;
                if (this.completer != null && !this.completer.canComplete()) {
                    T x2 = this.completer.partialData();
                    if (x2 != null) {
                        return x2;
                    }
                    return this.emptyData();
                }
                Future<T> cur = this.processing.get();
                wait = this.completeContents(null);
                if (!wait.isDone() && cur == wait && this.completer != null && (x = this.completer.partialData()) != null) {
                    return x;
                }
            }
            return wait.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            LOG.log(Level.WARNING, "Exception during expansion of group " + this.name, ex);
            LOG.log(Level.FINE, "Group " + this.name + " contents incomplete, return empty");
            return this.emptyData();
        }
    }

    @Override
    public synchronized Future<T> completeContents(Group.Feedback feedback) {
        Future<T> f = this.processing.get();
        if (f == null) {
            if (this.completer == null) {
                final CompletableFuture<T> c = new CompletableFuture<T>();
                c.complete(this.emptyData());
                f = c;
                this.processing = new SoftReference(this.processing){
                    Future x;
                    {
                        super(referent);
                        this.x = c;
                    }
                };
                LOG.log(Level.FINE, "No completer, provide empty contents");
            } else if (this.completer.canComplete()) {
                f = this.completer.completeContents(feedback);
            } else {
                CompletableFuture<T> c = new CompletableFuture<T>();
                c.complete(this.emptyData());
                return c;
            }
            LOG.log(Level.FINE, "Contents of group " + this.name + " not available, scheduling fetch");
            this.processing = _testUseWeakRefs ? new WeakReference<Future<T>>(f) : new SoftReference<Future<T>>(f);
        }
        return f;
    }

    protected T emptyData() {
        return null;
    }
}

