/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.MissingResourceException;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.graalvm.visualizer.search.Bundle;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class SearchResultColumns {
    private static final String PROPNAME_VISIBLE_COLUMNS = "visibleColumns";
    private static final String NODE_COLUMN_WEIGHT = "weights";
    private static final float DEFAULT_WEIGHT = 20.0f;
    private final Preferences prefs = NbPreferences.forModule(SearchResultColumns.class);

    public List<String> getInitialVisibleColumns() {
        String s = Bundle.DEFAULT_VisibleColumnsAndPositions();
        return Arrays.asList(s.split(", *"));
    }

    public List<String> getDefaultVisibleColumns() {
        String s = this.prefs.get(PROPNAME_VISIBLE_COLUMNS, "");
        return s.isEmpty() ? this.getInitialVisibleColumns() : Arrays.asList(s.split(", *"));
    }

    public void setDefaultVisibleColumns(List<String> cols) {
        this.prefs.put(PROPNAME_VISIBLE_COLUMNS, String.join((CharSequence)", ", cols));
    }

    public void removeVisibleColumn(String colId) {
        List<String> visCols = this.getDefaultVisibleColumns();
        if (!visCols.remove(colId)) {
            return;
        }
        this.setDefaultVisibleColumns(visCols);
    }

    public void addVisibleColumn(String colId) {
        List<String> visCols = this.getDefaultVisibleColumns();
        if (visCols.contains(colId)) {
            return;
        }
        visCols = new ArrayList<String>(visCols);
        visCols.add(colId);
        this.setDefaultVisibleColumns(visCols);
    }

    public float getColumnRelativeSize(String col) {
        float w = this.prefs.node(NODE_COLUMN_WEIGHT).getFloat(col, -1.0f);
        if (w >= 0.0f) {
            return w;
        }
        try {
            String s = NbBundle.getBundle(SearchResultColumns.class).getString("DEFAULT_RelativeColumnSize." + col);
            return Float.parseFloat(s);
        }
        catch (MissingResourceException ex) {
            return 20.0f;
        }
    }

    public void setColumnRelativeSize(String col, float size) {
        this.prefs.node(NODE_COLUMN_WEIGHT).putFloat(col, size);
    }

    public void resetSizes() {
        try {
            this.prefs.node(NODE_COLUMN_WEIGHT).removeNode();
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

