/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.graalvm.visualizer.search.GraphItem;
import org.graalvm.visualizer.search.NodeResultItem;
import org.graalvm.visualizer.search.SearchResultsEvent;
import org.graalvm.visualizer.search.SearchResultsListener;

public class SearchResultsModel {
    private Set<String> allPropertyNames = new HashSet<String>();
    private Map<GraphItem, List<NodeResultItem>> owners = new HashMap<GraphItem, List<NodeResultItem>>();
    private List<NodeResultItem> items = new ArrayList<NodeResultItem>();
    private List<SearchResultsListener> listeners = new ArrayList<SearchResultsListener>();
    private Map<GraphItem, List<SearchResultsListener>> graphListeners = new HashMap<GraphItem, List<SearchResultsListener>>();

    public void addSearchResultsListener(SearchResultsListener l) {
        this.listeners.add(l);
    }

    public void removeSearchResultsListener(SearchResultsListener l) {
        this.listeners.add(l);
    }

    public void addParentListener(GraphItem item, SearchResultsListener l) {
        this.graphListeners.computeIfAbsent(item, i -> new ArrayList()).add(l);
    }

    public void removeParentListener(GraphItem item, SearchResultsListener l) {
        List<SearchResultsListener> ll = this.graphListeners.get(item);
        if (ll == null) {
            return;
        }
        ll.remove(l);
    }

    public void clear() {
        this.items.clear();
        this.owners.clear();
    }

    public int getSize() {
        return this.items.size();
    }

    public void add(NodeResultItem item) {
        this.addAll(Collections.singleton(item));
    }

    public Set<String> getAllPropertyNames() {
        return Collections.unmodifiableSet(this.allPropertyNames);
    }

    private void fireSingleEvent(GraphItem owner, NodeResultItem item, boolean oChanged, BiConsumer<SearchResultsListener, SearchResultsEvent> callback) {
        List<Object> gl;
        SearchResultsEvent f = new SearchResultsEvent(Collections.singleton(owner), Collections.singleton(item), this);
        ArrayList<SearchResultsListener> ll = new ArrayList<SearchResultsListener>(this.listeners);
        List<SearchResultsListener> ol = this.graphListeners.get(owner);
        ol = ol == null ? Collections.emptyList() : new ArrayList<SearchResultsListener>(ol);
        gl = oChanged ? ((gl = this.graphListeners.get(GraphItem.ROOT)) == null ? Collections.emptyList() : new ArrayList(gl)) : Collections.emptyList();
        ll.forEach(l -> callback.accept((SearchResultsListener)l, f));
        ol.forEach(l -> callback.accept((SearchResultsListener)l, f));
        gl.forEach(l -> callback.accept((SearchResultsListener)l, f));
    }

    public void addAll(Collection<NodeResultItem> toAdd) {
        List<Object> gl;
        if (toAdd.isEmpty()) {
            return;
        }
        ArrayList<NodeResultItem> newItems = new ArrayList<NodeResultItem>(this.items);
        HashSet<String> names = new HashSet<String>();
        HashSet<String> newNames = new HashSet<String>(this.allPropertyNames);
        HashMap<GraphItem, SearchResultsEvent> added = new HashMap<GraphItem, SearchResultsEvent>();
        ArrayList<GraphItem> newOwners = new ArrayList<GraphItem>();
        newItems.addAll(toAdd);
        for (NodeResultItem item : toAdd) {
            GraphItem owner = item.getOwner();
            if (owner == null) {
                throw new IllegalArgumentException("not supported yet");
            }
            List<NodeResultItem> children = this.owners.get(owner);
            if (children == null) {
                newOwners.add(owner);
                children = new ArrayList<NodeResultItem>();
                this.owners.put(owner, children);
            }
            children.add(item);
            item.getItemProperties().forEach(p -> names.add(p.getName()));
            SearchResultsEvent e = (SearchResultsEvent)added.get(owner);
            if (e == null) {
                e = new SearchResultsEvent(Collections.singleton(owner), new ArrayList<NodeResultItem>(), this);
                added.put(owner, e);
            }
            e.getItems().add(item);
        }
        this.items = newItems;
        boolean namesChanged = newNames.addAll(names);
        if (namesChanged) {
            this.allPropertyNames = newNames;
        }
        SearchResultsEvent f = new SearchResultsEvent(added.keySet(), toAdd, this);
        SearchResultsEvent g = null;
        ArrayList<SearchResultsListener> ll = new ArrayList<SearchResultsListener>(this.listeners);
        if (!newOwners.isEmpty()) {
            gl = this.graphListeners.get(GraphItem.ROOT);
            if (gl == null) {
                gl = Collections.emptyList();
            } else {
                gl = new ArrayList(gl);
                g = new SearchResultsEvent(newOwners, toAdd, this);
            }
        } else {
            gl = Collections.emptyList();
        }
        ll.forEach(l -> l.itemsAdded(f));
        SearchResultsEvent fg = g;
        gl.forEach(l -> l.parentsChanged(fg));
        if (!newOwners.isEmpty()) {
            ll.forEach(l -> l.parentsChanged(fg));
        }
        for (GraphItem parent : added.keySet()) {
            gl = this.graphListeners.get(parent);
            if (gl == null) continue;
            SearchResultsEvent f2 = (SearchResultsEvent)added.get(parent);
            gl.forEach(l -> l.itemsAdded(f2));
        }
        if (namesChanged) {
            SearchResultsEvent e = new SearchResultsEvent(this, names);
            ll.forEach(l -> l.propertiesChanged(e));
        }
    }

    public void remove(NodeResultItem item) {
        boolean ownersChanged = false;
        this.items.remove(item);
        GraphItem owner = item.getOwner();
        Collection ch = this.owners.get(owner);
        if (ch != null) {
            ch.remove(item);
            if (ch.isEmpty()) {
                ownersChanged = true;
                this.owners.remove(owner);
            }
        }
        this.fireSingleEvent(owner, item, ownersChanged, SearchResultsListener::itemsRemoved);
    }

    public void removeAll(Collection<NodeResultItem> toRemove) {
        List<Object> gl;
        if (toRemove.isEmpty()) {
            return;
        }
        HashMap<GraphItem, SearchResultsEvent> removed = new HashMap<GraphItem, SearchResultsEvent>();
        ArrayList<NodeResultItem> newItems = new ArrayList<NodeResultItem>(this.items);
        ArrayList<GraphItem> oldOwners = new ArrayList<GraphItem>();
        newItems.removeAll(toRemove);
        for (NodeResultItem item : toRemove) {
            SearchResultsEvent e;
            GraphItem p = item.getOwner();
            List<NodeResultItem> children = this.owners.get(p);
            children.remove(item);
            if (children.isEmpty()) {
                this.owners.remove(p);
                oldOwners.add(p);
            }
            if ((e = (SearchResultsEvent)removed.get(p)) == null) {
                ArrayList<NodeResultItem> items = new ArrayList<NodeResultItem>();
                e = new SearchResultsEvent(Collections.singleton(p), items, this);
                removed.put(p, e);
            }
            e.getItems().add(item);
        }
        this.items = newItems;
        SearchResultsEvent f = new SearchResultsEvent(removed.keySet(), toRemove, this);
        SearchResultsEvent g = null;
        ArrayList<SearchResultsListener> ll = new ArrayList<SearchResultsListener>(this.listeners);
        if (!oldOwners.isEmpty()) {
            gl = this.graphListeners.get(GraphItem.ROOT);
            if (gl == null) {
                gl = Collections.emptyList();
            } else {
                gl = new ArrayList(gl);
                g = new SearchResultsEvent(oldOwners, toRemove, this);
            }
        } else {
            gl = Collections.emptyList();
        }
        ll.forEach(l -> l.itemsRemoved(f));
        SearchResultsEvent fg = g;
        gl.forEach(l -> l.parentsChanged(fg));
        if (!oldOwners.isEmpty()) {
            ll.forEach(l -> l.parentsChanged(fg));
        }
        for (GraphItem parent : removed.keySet()) {
            gl = this.graphListeners.get(parent);
            if (gl == null) continue;
            SearchResultsEvent f2 = (SearchResultsEvent)removed.get(parent);
            gl.forEach(l -> l.itemsRemoved(f2));
        }
    }

    public void removeParents(Collection<GraphItem> toRemove) {
        if (toRemove.isEmpty()) {
            return;
        }
        ArrayList allItems = new ArrayList();
        toRemove.stream().flatMap(o -> this.owners.getOrDefault(o, Collections.emptyList()).stream()).forEach(allItems::add);
        SearchResultsEvent oe = new SearchResultsEvent(toRemove, this);
        List<SearchResultsListener> gl = this.graphListeners.getOrDefault(GraphItem.ROOT, Collections.emptyList());
        gl.forEach(l -> l.parentsChanged(oe));
    }

    public Collection<NodeResultItem> getItems() {
        return new ArrayList<NodeResultItem>(this.items);
    }

    public Collection<NodeResultItem> getChildren(GraphItem owner) {
        return new ArrayList<NodeResultItem>(this.owners.getOrDefault(owner, Collections.emptyList()));
    }

    public Collection<GraphItem> getParents() {
        return new ArrayList<GraphItem>(this.owners.keySet());
    }

    public String toString() {
        return "GraphSearch[nodes = " + this.items.size() + " graphs = " + this.owners.keySet().size() + "]";
    }
}

