/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.nodes;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.gradle.NbGradleProjectImpl;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.nodes.AnnotatedAbstractNode;
import org.netbeans.modules.gradle.nodes.Bundle;
import org.netbeans.modules.gradle.nodes.SubProjectsNode;
import org.netbeans.modules.gradle.spi.GradleFiles;
import org.netbeans.modules.gradle.spi.GradleSettings;
import org.netbeans.modules.gradle.spi.nodes.NodeUtils;
import org.netbeans.spi.project.ui.PathFinder;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Pair;
import org.openide.util.lookup.Lookups;

public final class BuildScriptsNode
extends AnnotatedAbstractNode {
    private static final Logger LOG = Logger.getLogger(BuildScriptsNode.class.getName());
    private static final String BS_BADGE = "org/netbeans/modules/gradle/resources/buildscripts-badge.png";
    private static final GradleFiles.Kind[] SCRIPTS = new GradleFiles.Kind[]{GradleFiles.Kind.BUILD_SRC, GradleFiles.Kind.VERSION_CATALOG, GradleFiles.Kind.USER_PROPERTIES, GradleFiles.Kind.SETTINGS_SCRIPT, GradleFiles.Kind.ROOT_SCRIPT, GradleFiles.Kind.ROOT_PROPERTIES, GradleFiles.Kind.BUILD_SCRIPT, GradleFiles.Kind.PROJECT_PROPERTIES};

    public BuildScriptsNode(NbGradleProjectImpl prj) {
        super(Children.create((ChildFactory)new ProjectFilesChildren(prj), (boolean)true), Lookups.fixed((Object[])new Object[]{prj.getProjectDirectory(), new Finder(prj)}));
        this.setName("buildscripts");
        this.setDisplayName(Bundle.LBL_Build_Scripts());
    }

    @Override
    protected Image getIconImpl(int param) {
        return this.getIcon(false);
    }

    @Override
    protected Image getOpenedIconImpl(int param) {
        return this.getIcon(true);
    }

    private Image getIcon(boolean opened) {
        Image badge = ImageUtilities.loadImage((String)BS_BADGE, (boolean)true);
        Image img = ImageUtilities.mergeImages((Image)NodeUtils.getTreeFolderIcon(opened), (Image)badge, (int)8, (int)8);
        return img;
    }

    private static class ProjectFilesChildren
    extends ChildFactory.Detachable<Pair<FileObject, GradleFiles.Kind>>
    implements PropertyChangeListener {
        private final NbGradleProjectImpl project;
        private final FileChangeAdapter fileChangeListener;
        private final PreferenceChangeListener prefChangeListener;

        ProjectFilesChildren(NbGradleProjectImpl proj) {
            this.project = proj;
            this.fileChangeListener = new FileChangeAdapter(){

                public void fileDataCreated(FileEvent fe) {
                    this.refresh(false);
                }

                public void fileDeleted(FileEvent fe) {
                    this.refresh(false);
                }
            };
            this.prefChangeListener = evt -> {
                if ("gradleUserHome".equals(evt.getKey())) {
                    this.refresh(false);
                }
            };
        }

        protected Node createNodeForKey(Pair<FileObject, GradleFiles.Kind> key) {
            boolean isRoot = this.project.getGradleProject().getBaseProject().isRoot();
            FileObject fo = (FileObject)key.first();
            switch ((GradleFiles.Kind)((Object)key.second())) {
                case ROOT_SCRIPT: 
                case ROOT_PROPERTIES: {
                    return isRoot ? null : ProjectFilesChildren.createBuildFileNode(fo, Bundle.LBL_RootSuffix());
                }
                case BUILD_SCRIPT: 
                case PROJECT_PROPERTIES: {
                    return ProjectFilesChildren.createBuildFileNode(fo, isRoot ? null : Bundle.LBL_ProjectSuffixt());
                }
                case USER_PROPERTIES: {
                    return ProjectFilesChildren.createBuildFileNode(fo, Bundle.LBL_UserSuffix());
                }
                case SETTINGS_SCRIPT: 
                case VERSION_CATALOG: {
                    return ProjectFilesChildren.createBuildFileNode(fo, null);
                }
                case BUILD_SRC: {
                    return ProjectFilesChildren.createSubProjectNode(fo);
                }
            }
            return null;
        }

        private static Node createSubProjectNode(FileObject fo) {
            try {
                Project prj = ProjectManager.getDefault().findProject(fo);
                if (prj != null) {
                    return SubProjectsNode.createSubProjectNode(prj);
                }
                LOG.log(Level.WARNING, "It seems {0} was not identified as a buildSrc project.", fo.getPath());
            }
            catch (IOException | IllegalArgumentException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return null;
        }

        private static Node createBuildFileNode(FileObject fo, String nameSuffix) {
            Node ret = null;
            try {
                ret = DataObject.find((FileObject)fo).getNodeDelegate().cloneNode();
                if (nameSuffix != null) {
                    ret.setDisplayName(fo.getNameExt() + " [" + nameSuffix + "]");
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
            return ret;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("ProjectInfo".equals(evt.getPropertyName())) {
                this.refresh(false);
            }
        }

        protected void addNotify() {
            NbGradleProject.addPropertyChangeListener(this.project, this);
            this.project.getProjectDirectory().addFileChangeListener((FileChangeListener)this.fileChangeListener);
            GradleSettings.getDefault().getPreferences().addPreferenceChangeListener(this.prefChangeListener);
        }

        protected void removeNotify() {
            NbGradleProject.removePropertyChangeListener(this.project, this);
            this.project.getProjectDirectory().removeFileChangeListener((FileChangeListener)this.fileChangeListener);
            GradleSettings.getDefault().getPreferences().removePreferenceChangeListener(this.prefChangeListener);
        }

        protected boolean createKeys(List<Pair<FileObject, GradleFiles.Kind>> keys) {
            GradleFiles gf = this.project.getGradleFiles();
            for (GradleFiles.Kind kind : SCRIPTS) {
                File f = gf.getFile(kind);
                if (f == null || !f.exists()) continue;
                keys.add((Pair<FileObject, GradleFiles.Kind>)Pair.of((Object)FileUtil.toFileObject((File)f), (Object)((Object)kind)));
            }
            return true;
        }
    }

    private static class Finder
    implements PathFinder {
        final Project project;

        public Finder(Project project) {
            this.project = project;
        }

        public Node findPath(Node node, Object target) {
            if (target instanceof FileObject) {
                Node[] nodes;
                FileObject fo = (FileObject)target;
                if (this.project != FileOwnerQuery.getOwner((FileObject)fo)) {
                    return null;
                }
                for (Node n : nodes = node.getChildren().getNodes(true)) {
                    FileObject nf = (FileObject)n.getLookup().lookup(FileObject.class);
                    if (nf == null || !nf.equals(fo)) continue;
                    return n;
                }
            }
            return null;
        }
    }
}

