/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.lsp;

import java.util.List;
import java.util.Set;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.lsp.Range;
import org.netbeans.modules.lsp.StructureElementAccessor;
import org.openide.filesystems.FileObject;

public final class StructureElement {
    private final FileObject file;
    private final String name;
    private final String detail;
    private final Range selectionRange;
    private final Range expandedRange;
    private final Kind kind;
    private final Set<Tag> tags;
    private final List<StructureElement> children;

    private StructureElement(FileObject file, @NonNull String name, String detail, int selectionStartOffset, int selectionEndOffset, int expandedStartOffset, int expandedEndOffset, @NonNull Kind kind, Set<Tag> tags, List<StructureElement> children) {
        this.file = file;
        this.name = name;
        this.detail = detail;
        this.selectionRange = new Range(selectionStartOffset, selectionEndOffset);
        this.expandedRange = new Range(expandedStartOffset, expandedEndOffset);
        this.kind = kind;
        this.tags = tags;
        this.children = children;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public int getSelectionStartOffset() {
        return this.selectionRange.getStartOffset();
    }

    public int getSelectionEndOffset() {
        return this.selectionRange.getEndOffset();
    }

    public int getExpandedStartOffset() {
        return this.expandedRange.getStartOffset();
    }

    public int getExpandedEndOffset() {
        return this.expandedRange.getEndOffset();
    }

    public Range getSelectionRange() {
        return this.selectionRange;
    }

    public Range getExpandedRange() {
        return this.expandedRange;
    }

    public Kind getKind() {
        return this.kind;
    }

    public Set<Tag> getTags() {
        return this.tags;
    }

    public String getDetail() {
        return this.detail;
    }

    public List<StructureElement> getChildren() {
        return this.children;
    }

    @CheckForNull
    public FileObject getFile() {
        return this.file;
    }

    static {
        StructureElementAccessor.setDefault(new StructureElementAccessor(){

            @Override
            public StructureElement createStructureElement(FileObject file, String name, String detail, int selectionStartOffset, int selectionEndOffset, int expandedStartOffset, int expandedEndOffset, Kind kind, Set<Tag> tags, List<StructureElement> children) {
                return new StructureElement(file, name, detail, selectionStartOffset, selectionEndOffset, expandedStartOffset, expandedEndOffset, kind, tags, children);
            }
        });
    }

    public static enum Kind {
        File,
        Module,
        Namespace,
        Package,
        Class,
        Method,
        Property,
        Field,
        Constructor,
        Enum,
        Interface,
        Function,
        Variable,
        Constant,
        String,
        Number,
        Boolean,
        Array,
        Object,
        Key,
        Null,
        EnumMember,
        Struct,
        Event,
        Operator,
        TypeParameter;

    }

    public static enum Tag {
        Deprecated;

    }
}

