/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class FileHelpers {
    private FileHelpers() {
    }

    public static FileObject ensureConfigWritable(String pathInRoot) throws IOException {
        FileObject target = FileUtil.getConfigFile((String)pathInRoot);
        if (target == null) {
            return FileUtil.getConfigRoot().createFolder(pathInRoot);
        }
        File rf = FileUtil.toFile((FileObject)FileUtil.getConfigRoot());
        if (rf == null || !rf.exists() || !rf.isDirectory()) {
            throw new FileNotFoundException("Could not create configuration folder");
        }
        Path targetPath = rf.toPath().resolve(Paths.get(pathInRoot, new String[0]));
        if (!Files.exists(targetPath, new LinkOption[0])) {
            targetPath = Files.createDirectories(targetPath, new FileAttribute[0]);
        }
        File nf = targetPath.toFile();
        FileObject ret = null;
        int count = 0;
        do {
            if (count > 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            FileUtil.getConfigRoot().refresh();
        } while ((ret = FileUtil.toFileObject((File)nf)) == null && ++count < 5);
        return ret;
    }
}

