/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.util;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import jdk.graal.compiler.graphio.parsing.model.ChangedListener;
import org.graalvm.visualizer.util.RangeSliderModel;

public class RangeSlider
extends JComponent
implements ChangedListener<RangeSliderModel>,
MouseListener,
MouseMotionListener,
Scrollable {
    public static final float BAR_HEIGHT = 22.0f;
    public static final float BAR_SELECTION_ENDING_HEIGHT = 16.0f;
    public static final float BAR_SELECTION_HEIGHT = 10.0f;
    public static final float BAR_THICKNESS = 2.0f;
    public static final float BAR_CIRCLE_SIZE = 9.0f;
    public static final float BAR_CIRCLE_CONNECTOR_SIZE = 6.0f;
    public static final int MOUSE_ENDING_OFFSET = 3;
    public static final Color BACKGROUND_COLOR = Color.white;
    public static final Color BAR_COLOR = Color.black;
    public static final Color BAR_INACTIVE_COLOR = Color.lightGray;
    public static final Color BAR_SELECTION_COLOR = new Color(255, 0, 0, 120);
    public static final Color BAR_SELECTION_COLOR_ROLLOVER = new Color(255, 0, 255, 120);
    public static final Color BAR_SELECTION_COLOR_DRAG = new Color(0, 0, 255, 120);
    public static final int HEIGHT = 22;
    private RangeSliderModel model;
    private State state;
    private Point startPoint;
    private RangeSliderModel tempModel;
    private boolean isOverBar;
    private Color basicBarColor = BAR_COLOR;
    private boolean showGaps;
    private int origStartX = -1;
    private int origEndX = -1;

    public RangeSlider() {
        this.state = State.Initial;
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    public Color getBasicBarColor() {
        return this.basicBarColor;
    }

    public void setBasicBarColor(Color basicBarColor) {
        this.basicBarColor = basicBarColor;
    }

    public void setModel(RangeSliderModel newModel) {
        if (this.model != null) {
            this.model.getChangedEvent().removeListener((Object)this);
            this.model.getColorChangedEvent().removeListener((Object)this);
        }
        if (newModel != null) {
            newModel.getChangedEvent().addListener((Object)this);
            newModel.getColorChangedEvent().addListener((Object)this);
        }
        this.model = newModel;
        this.update();
    }

    private RangeSliderModel getPaintingModel() {
        if (this.tempModel != null) {
            return this.tempModel;
        }
        return this.model;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            return 1;
        }
        return 15;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return orientation == 1 ? visibleRect.height / 2 : visibleRect.width / 2;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return true;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        d.height = 22;
        d.width = Math.max(d.width, (int)(12.0f + (float)this.getPaintingModel().getPositionCount(this.isShowGaps()) * 15.0f));
        return d;
    }

    public void changed(RangeSliderModel source) {
        this.refresh();
    }

    private void refresh() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.refreshInAWT();
        } else {
            SwingUtilities.invokeLater(this::refreshInAWT);
        }
    }

    private void refreshInAWT() {
        this.revalidate();
        float barStartY = this.getBarStartY();
        int circleCenterY = (int)(barStartY + 11.0f);
        int startX = (int)this.getStartXPosition(this.model.getFirstPosition());
        int endX = (int)this.getEndXPosition(this.model.getSecondPosition());
        if (startX != this.origStartX || endX != this.origEndX) {
            this.origStartX = startX;
            this.origEndX = endX;
            Rectangle r = new Rectangle(startX, circleCenterY, endX - startX, 1);
            this.scrollRectToVisible(r);
        }
        this.update();
    }

    private void update() {
        this.repaint();
    }

    private float getSlotXPosition(int index) {
        return this.getXPosition(this.showGaps ? this.getPaintingModel().getSlot(index) : index);
    }

    private float getXPosition(int index) {
        assert (index >= 0 && index < this.getPaintingModel().getPositionCount(true));
        return this.getXOffset() * (float)(index + 1);
    }

    private int getSlots() {
        RangeSliderModel m = this.getPaintingModel();
        return m == null ? 0 : m.getPositionCount(this.showGaps);
    }

    private float getXOffset() {
        int size = this.getSlots();
        float width = this.getPreferredSize().width;
        return width / (float)(size + 1);
    }

    private float getEndXPosition(int index) {
        return this.getSlotXPosition(index) + this.getXOffset() / 2.0f;
    }

    private float getStartXPosition(int index) {
        return this.getSlotXPosition(index) - this.getXOffset() / 2.0f;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int width = this.getWidth();
        int height = this.getHeight();
        g2.setColor(BACKGROUND_COLOR);
        g2.fill(new Rectangle2D.Float(0.0f, 0.0f, width, height));
        if (this.getSlots() == 0) {
            return;
        }
        int firstPos = this.getPaintingModel().getFirstPosition();
        int secondPos = this.getPaintingModel().getSecondPosition();
        this.paintSelected(g2, firstPos, secondPos);
        this.paintBar(g2);
    }

    private float getBarStartY() {
        return (float)(this.getHeight() / 2) - 11.0f;
    }

    private Color lighten(Color color) {
        if (color == null || Color.black.equals(this.basicBarColor)) {
            return color;
        }
        float amount = 0.5f;
        int red = (int)(((float)color.getRed() * (1.0f - amount) / 255.0f + amount) * 255.0f);
        int green = (int)(((float)color.getGreen() * (1.0f - amount) / 255.0f + amount) * 255.0f);
        int blue = (int)(((float)color.getBlue() * (1.0f - amount) / 255.0f + amount) * 255.0f);
        int alpha = color.getAlpha();
        return new Color(red, green, blue, alpha);
    }

    private static TexturePaint makeHatch(Color one, Color two) {
        int size = 4;
        BufferedImage hatchImage = new BufferedImage(size, size, 2);
        Graphics2D g2 = (Graphics2D)hatchImage.getGraphics();
        g2.setColor(one);
        g2.fillRect(0, 0, size, size);
        g2.setColor(two);
        g2.drawLine(0, 0, size, size);
        g2.dispose();
        return new TexturePaint(hatchImage, new Rectangle2D.Double(0.0, 0.0, size, size));
    }

    private void paintBar(Graphics2D g) {
        List<String> list = this.getPaintingModel().getPositions();
        float barStartY = this.getBarStartY();
        g.setColor(this.basicBarColor);
        g.fill(new Rectangle2D.Float(this.getSlotXPosition(0), barStartY + 11.0f - 1.0f, this.getSlotXPosition(list.size() - 1) - this.getSlotXPosition(0), 2.0f));
        float circleCenterY = barStartY + 11.0f;
        List<Color> colors = this.getPaintingModel().getColors();
        List<Color> hatches = this.getPaintingModel().getHatchColors();
        if (list.size() != colors.size()) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            float curX = this.getSlotXPosition(i);
            Color hatch = i < hatches.size() ? this.lighten(hatches.get(i)) : null;
            Color color = this.lighten(colors.get(i));
            if (hatch == null) {
                g.setColor(color);
            } else {
                g.setPaint(RangeSlider.makeHatch(color, hatch));
            }
            Ellipse2D.Float e = new Ellipse2D.Float(curX - 4.5f, circleCenterY - 4.5f, 9.0f, 9.0f);
            g.fill(e);
            g.setColor(this.basicBarColor);
            g.draw(e);
            String curS = list.get(i);
            if (curS == null || curS.length() <= 0) continue;
            float startX = this.getStartXPosition(i);
            float endX = this.getEndXPosition(i);
            FontMetrics metrics = g.getFontMetrics();
            Rectangle bounds = metrics.getStringBounds(curS, g).getBounds();
            if (!((float)bounds.width < endX - startX) || !((float)bounds.height < barStartY)) continue;
            g.setColor(this.basicBarColor);
            g.drawString(curS, startX + (endX - startX) / 2.0f - (float)(bounds.width / 2), barStartY / 2.0f + (float)(bounds.height / 2));
        }
    }

    private void paintSelected(Graphics2D g, int start, int end) {
        float startX = this.getStartXPosition(start);
        float endX = this.getEndXPosition(end);
        float barStartY = this.getBarStartY();
        float barSelectionEndingStartY = barStartY + 11.0f - 8.0f;
        this.paintSelectedEnding(g, startX, barSelectionEndingStartY);
        this.paintSelectedEnding(g, endX, barSelectionEndingStartY);
        g.setColor(BAR_SELECTION_COLOR);
        if (this.state == State.DragBar) {
            g.setColor(BAR_SELECTION_COLOR_DRAG);
        } else if (this.isOverBar) {
            g.setColor(BAR_SELECTION_COLOR_ROLLOVER);
        }
        g.fill(new Rectangle2D.Float(startX, barStartY + 11.0f - 5.0f, endX - startX, 10.0f));
    }

    private void paintSelectedEnding(Graphics2D g, float x, float y) {
        g.setColor(this.basicBarColor);
        g.fill(new Rectangle2D.Float(x - 1.0f, y, 2.0f, 16.0f));
    }

    private boolean isOverSecondPosition(Point p) {
        if ((float)p.y >= this.getBarStartY()) {
            float destX = this.getEndXPosition(this.getPaintingModel().getSecondPosition());
            float off = Math.abs(destX - (float)p.x);
            return off <= 3.0f;
        }
        return false;
    }

    private boolean isOverFirstPosition(Point p) {
        if ((float)p.y >= this.getBarStartY()) {
            float destX = this.getStartXPosition(this.getPaintingModel().getFirstPosition());
            float off = Math.abs(destX - (float)p.x);
            return off <= 3.0f;
        }
        return false;
    }

    private boolean isOverSelection(Point p) {
        if ((float)p.y >= this.getBarStartY() && !this.isOverFirstPosition(p) && !this.isOverSecondPosition(p)) {
            return (float)p.x > this.getStartXPosition(this.getPaintingModel().getFirstPosition()) && (float)p.x < this.getEndXPosition(this.getPaintingModel().getSecondPosition());
        }
        return false;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Rectangle r = new Rectangle(e.getX(), e.getY(), 1, 1);
        this.scrollRectToVisible(r);
        if (this.state == State.DragBar) {
            int delta;
            float firstX = this.getStartXPosition(this.model.getFirstPosition());
            float newFirstX = firstX + (float)e.getPoint().x - (float)this.startPoint.x;
            int newIndex = this.getIndexFromPosition(newFirstX) + 1;
            if (newIndex + (delta = this.model.getSecondPosition() - this.model.getFirstPosition()) >= this.model.getPositions().size()) {
                newIndex = this.model.getPositions().size() - delta - 1;
            }
            int secondPosition = newIndex + delta;
            this.tempModel.setPositions(newIndex, secondPosition);
            this.update();
        } else if (this.state == State.DragFirstPosition) {
            int secondPosition;
            int firstPosition = this.getIndexFromPosition(e.getPoint().x) + 1;
            if (firstPosition > (secondPosition = this.model.getSecondPosition())) {
                firstPosition = secondPosition;
            }
            this.tempModel.setPositions(firstPosition, secondPosition);
            this.update();
        } else if (this.state == State.DragSecondPosition) {
            int firstPosition = this.model.getFirstPosition();
            int secondPosition = this.getIndexFromPosition(e.getPoint().x);
            if (secondPosition < firstPosition) {
                secondPosition = firstPosition;
            }
            this.tempModel.setPositions(firstPosition, secondPosition);
            this.update();
        }
    }

    private int getIndexFromPosition(float x) {
        if (x < this.getSlotXPosition(0)) {
            return -1;
        }
        int maxP = this.getPaintingModel().getPositionCount(false) - 1;
        for (int i = 0; i < maxP; ++i) {
            float startX = this.getSlotXPosition(i);
            float endX = this.getSlotXPosition(i + 1);
            if (!(x >= startX) || !(x <= endX)) continue;
            return i;
        }
        return maxP;
    }

    private int getCircleIndexFromPosition(int x) {
        int result = 0;
        for (int i = 1; i < this.getPaintingModel().getPositions().size(); ++i) {
            if (!((float)x > this.getStartXPosition(i))) continue;
            result = i;
        }
        return result;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.isOverBar = false;
        if (this.model == null) {
            return;
        }
        Point p = e.getPoint();
        if (this.isOverFirstPosition(p) || this.isOverSecondPosition(p)) {
            this.setCursor(Cursor.getPredefinedCursor(11));
        } else if (this.isOverSelection(p)) {
            this.isOverBar = true;
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
        if ((float)p.y >= this.getBarStartY()) {
            int pos = this.getIndexFromPosition(e.getPoint().x);
            if (pos > -1) {
                this.setToolTipText(this.getPaintingModel().getPositions().get(pos));
            } else {
                this.setToolTipText(null);
            }
        }
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1) {
            int index = this.getCircleIndexFromPosition(e.getPoint().x);
            this.model.setPositions(index, index);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.model == null) {
            return;
        }
        Point p = e.getPoint();
        if (this.isOverFirstPosition(p)) {
            this.state = State.DragFirstPosition;
        } else if (this.isOverSecondPosition(p)) {
            this.state = State.DragSecondPosition;
        } else if (this.isOverSelection(p)) {
            this.state = State.DragBar;
        } else {
            return;
        }
        this.startPoint = e.getPoint();
        this.tempModel = this.model.copy();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.model == null || this.tempModel == null) {
            return;
        }
        this.state = State.Initial;
        this.model.setPositions(this.tempModel.getFirstPosition(), this.tempModel.getSecondPosition());
        this.tempModel = null;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.isOverBar = false;
        this.repaint();
    }

    public boolean isShowGaps() {
        return this.showGaps;
    }

    public void setShowGaps(boolean showGaps) {
        this.showGaps = showGaps;
    }

    public RangeSliderModel getModel() {
        return this.model;
    }

    private static enum State {
        Initial,
        DragBar,
        DragFirstPosition,
        DragSecondPosition;

    }
}

