/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.filterwindow;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.graalvm.visualizer.filter.Filter;
import org.graalvm.visualizer.filter.profiles.FilterProfile;
import org.graalvm.visualizer.filter.profiles.mgmt.ProfileService;
import org.graalvm.visualizer.filter.profiles.mgmt.ProfileStorage;
import org.graalvm.visualizer.filterwindow.Bundle;
import org.graalvm.visualizer.filterwindow.CheckListView;
import org.graalvm.visualizer.filterwindow.actions.NewFilterAction;
import org.graalvm.visualizer.filterwindow.impl.FilterNode;
import org.graalvm.visualizer.filterwindow.impl.FilterProfileNode;
import org.netbeans.api.actions.Openable;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Actions;
import org.openide.awt.Toolbar;
import org.openide.awt.ToolbarPool;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.ChoiceView;
import org.openide.explorer.view.Visualizer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class FilterTopComponent
extends TopComponent
implements ExplorerManager.Provider {
    private static FilterTopComponent instance;
    public static final String FOLDER_ID = "Filters";
    public static final String PREFERRED_ID = "FilterTopComponent";
    private final CheckListView view;
    private final ExplorerManager manager;
    private final ExplorerManager profileEM;
    private final JPanel northPanel;
    private final InstanceContent lookupContent;
    private final ChangeListener muxListener;
    private final ChoiceView profileView;
    private ProfileService rootFilterManager;
    private FilterProfile curProfile;

    private void updateSelection() {
        Node[] nodes = this.getExplorerManager().getSelectedNodes();
        int[] arr = new int[nodes.length];
        List seq = this.rootFilterManager.getSelectedProfile().getProfileFilters();
        for (int i = 0; i < nodes.length; ++i) {
            int index;
            arr[i] = index = seq.indexOf(((FilterNode)nodes[i]).getFilter());
        }
        this.view.showSelection(arr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshContentLookup() {
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(this.rootFilterManager);
        for (Node n : this.manager.getSelectedNodes()) {
            Filter f = (Filter)n.getLookup().lookup(Filter.class);
            if (f == null) continue;
            l.add(f);
        }
        Node[] sel = this.profileEM.getSelectedNodes();
        if (sel.length > 0) {
            FilterProfile p = (FilterProfile)sel[0].getLookup().lookup(FilterProfile.class);
            if (p != null) {
                l.add(p);
            }
            FilterTopComponent filterTopComponent = this;
            synchronized (filterTopComponent) {
                this.curProfile = p;
            }
        }
        this.lookupContent.set(l, null);
    }

    private FilterTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(FilterTopComponent.class, (String)"CTL_FilterTopComponent"));
        this.setToolTipText(NbBundle.getMessage(FilterTopComponent.class, (String)"HINT_FilterTopComponent"));
        this.lookupContent = new InstanceContent();
        this.rootFilterManager = (ProfileService)Lookup.getDefault().lookup(ProfileService.class);
        this.curProfile = this.rootFilterManager.getDefaultProfile();
        this.manager = new ExplorerManager();
        this.profileEM = new ExplorerManager();
        this.profileEM.setRootContext(FilterProfileNode.createProfileParent());
        Node n = this.findProfileNode(this.rootFilterManager.getSelectedProfile());
        if (n != null) {
            try {
                this.profileEM.setSelectedNodes(new Node[]{n});
            }
            catch (PropertyVetoException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.manager.setRootContext(n);
        }
        this.associateLookup((Lookup)new ProxyLookup(new Lookup[]{ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)this.getActionMap()), new AbstractLookup((AbstractLookup.Content)this.lookupContent)}));
        this.muxListener = new ChangeListener();
        this.manager.addPropertyChangeListener((PropertyChangeListener)this.muxListener);
        this.rootFilterManager.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.muxListener, (Object)this.rootFilterManager));
        this.view = new CheckListView();
        this.profileView = new ChoiceView();
        this.profileView.addActionListener((ActionListener)this.muxListener);
        this.northPanel = new PanelWithEM();
        this.northPanel.setLayout(new BorderLayout());
        this.add(this.northPanel, "North");
        ToolbarPool.getDefault().setPreferredIconSize(16);
        Toolbar toolBar = new Toolbar();
        Border b = (Border)UIManager.get("Nb.Editor.Toolbar.border");
        toolBar.setBorder(b);
        toolBar.add((Component)this.profileView);
        this.northPanel.add((Component)toolBar, "Center");
        this.addToolbarAction(toolBar, Actions.forID((String)FOLDER_ID, (String)"org.graalvm.visualizer.filterwindow.actions.ManageProfileAction"));
        toolBar.addSeparator();
        this.addToolbarAction(toolBar, Actions.forID((String)FOLDER_ID, (String)"org.graalvm.visualizer.filterwindow.actions.LinkExistingFilter"));
        toolBar.add((Action)NewFilterAction.get(NewFilterAction.class));
        this.addToolbarAction(toolBar, Actions.forID((String)FOLDER_ID, (String)"org.graalvm.visualizer.filterwindow.actions.RemoveFilterAction"));
        this.addToolbarAction(toolBar, Actions.forID((String)FOLDER_ID, (String)"org.graalvm.visualizer.filterwindow.actions.MoveDown"));
        this.addToolbarAction(toolBar, Actions.forID((String)FOLDER_ID, (String)"org.graalvm.visualizer.filterwindow.actions.MoveUp"));
        this.add((Component)((Object)this.view), "Center");
        this.refreshContentLookup();
        this.view.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                FilterTopComponent.this.updateSelection();
            }
        });
    }

    private Action addToolbarAction(Toolbar toolbar, Action orig) {
        Action a = orig;
        if (a instanceof ContextAwareAction) {
            a = ((ContextAwareAction)orig).createContextAwareInstance(this.getLookup());
        }
        if (a instanceof Presenter.Toolbar) {
            toolbar.add(((Presenter.Toolbar)a).getToolbarPresenter());
        } else {
            toolbar.add(a);
        }
        return a;
    }

    private FilterProfile getSelectedProfile() {
        return this.curProfile;
    }

    public void newFilter() throws IOException {
        DataFolder fld;
        NotifyDescriptor.InputLine nameInput = new NotifyDescriptor.InputLine(Bundle.LABEL_NewFilterName(), Bundle.TITLE_CreateNewFilter(), 2, 3);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nameInput) != DialogDescriptor.OK_OPTION) {
            return;
        }
        FileObject templateFile = FileUtil.getConfigFile((String)"Templates/Filters/empty.js");
        DataObject template = DataObject.find((FileObject)templateFile);
        DataObject target = template.createFromTemplate(fld = DataFolder.findFolder((FileObject)FileUtil.getConfigFile((String)FOLDER_ID)), nameInput.getInputText());
        if (target != null) {
            FileObject storage = target.getPrimaryFile();
            FilterProfile prof = this.getSelectedProfile();
            Filter f = ((ProfileStorage)this.rootFilterManager.getLookup().lookup(ProfileStorage.class)).createFilter(storage, prof);
            if (f == null) {
                return;
            }
            final AtomicReference<Filter> linkedFilter = new AtomicReference<Filter>();
            this.manager.getExploredContext().addNodeListener((NodeListener)new NodeAdapter(){

                public void childrenAdded(NodeMemberEvent ev) {
                    SwingUtilities.invokeLater(() -> {
                        for (Node n : FilterTopComponent.this.manager.getExploredContext().getChildren().getNodes()) {
                            Filter select;
                            Filter check = (Filter)n.getLookup().lookup(Filter.class);
                            if (check != (select = (Filter)linkedFilter.get())) continue;
                            SwingUtilities.invokeLater(new DelayedSelector(select));
                        }
                        ((Node)ev.getSource()).removeNodeListener((NodeListener)this);
                    });
                }
            });
            Filter newFilter = prof.addSharedFilter(f);
            linkedFilter.set(newFilter);
            Openable cake = (Openable)newFilter.getLookup().lookup(Openable.class);
            if (cake != null) {
                cake.open();
            }
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public static synchronized FilterTopComponent getDefault() {
        if (instance == null) {
            instance = new FilterTopComponent();
        }
        return instance;
    }

    public static synchronized FilterTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            ErrorManager.getDefault().log(16, "Cannot find Filter component. It will not be located properly in the window system.");
            return FilterTopComponent.getDefault();
        }
        if (win instanceof FilterTopComponent) {
            return (FilterTopComponent)win;
        }
        ErrorManager.getDefault().log(16, "There seem to be multiple components with the 'FilterTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return FilterTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public boolean requestFocus(boolean temporary) {
        this.view.requestFocus();
        return super.requestFocus(temporary);
    }

    protected boolean requestFocusInWindow(boolean temporary) {
        this.view.requestFocus();
        return super.requestFocusInWindow(temporary);
    }

    public void requestActive() {
        super.requestActive();
        this.view.requestFocus();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
    }

    private Node findProfileNode(FilterProfile p) {
        Node[] nodes;
        for (Node n : nodes = this.profileEM.getExploredContext().getChildren().getNodes()) {
            if (n.getLookup().lookup(FilterProfile.class) != p) continue;
            return n;
        }
        return nodes[0];
    }

    private class ChangeListener
    implements PropertyChangeListener,
    ActionListener {
        private ChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() == FilterTopComponent.this.manager && "selectedNodes".equals(evt.getPropertyName())) {
                FilterTopComponent.this.setActivatedNodes(FilterTopComponent.this.manager.getSelectedNodes());
                FilterTopComponent.this.refreshContentLookup();
            }
            if (evt.getSource() == FilterTopComponent.this.profileEM) {
                // empty if block
            }
            if (evt.getSource() == FilterTopComponent.this.rootFilterManager && "selectedProfile".equals(evt.getPropertyName())) {
                Node pn = FilterTopComponent.this.findProfileNode(FilterTopComponent.this.rootFilterManager.getSelectedProfile());
                try {
                    if (pn != null) {
                        FilterTopComponent.this.profileEM.setSelectedNodes(new Node[]{pn});
                        FilterTopComponent.this.manager.setRootContext(pn);
                        FilterTopComponent.this.refreshContentLookup();
                    }
                }
                catch (PropertyVetoException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == FilterTopComponent.this.profileView) {
                Node[] sel = FilterTopComponent.this.profileEM.getSelectedNodes();
                if (sel.length != 1) {
                    return;
                }
                FilterProfile choice = (FilterProfile)sel[0].getLookup().lookup(FilterProfile.class);
                FilterTopComponent.this.rootFilterManager.setSelectedProfile(choice);
            }
        }
    }

    private class PanelWithEM
    extends JPanel
    implements ExplorerManager.Provider {
        public PanelWithEM() {
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
        }

        public ExplorerManager getExplorerManager() {
            return FilterTopComponent.this.profileEM;
        }
    }

    private static class PL
    extends ProxyLookup {
        public void setLoookups(Lookup ... lkps) {
            super.setLookups(lkps);
        }
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return FilterTopComponent.getDefault();
        }
    }

    class DelayedSelector
    implements Runnable {
        private final Filter selectFilter;
        private int attempts;

        public DelayedSelector(Filter selectFilter) {
            this.selectFilter = selectFilter;
        }

        @Override
        public void run() {
            int size = FilterTopComponent.this.view.getModel().getSize();
            for (int i = 0; i < size; ++i) {
                Node n = Visualizer.findNode((Object)FilterTopComponent.this.view.getModel().getElementAt(i));
                Filter f = (Filter)n.getLookup().lookup(Filter.class);
                if (f != this.selectFilter) continue;
                try {
                    FilterTopComponent.this.manager.setSelectedNodes(new Node[]{n});
                    return;
                }
                catch (PropertyVetoException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            ++this.attempts;
            if (this.attempts < 5) {
                SwingUtilities.invokeLater(this);
            }
        }
    }
}

