/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.filterwindow.actions;

import java.io.IOException;
import org.graalvm.visualizer.filterwindow.FilterTopComponent;
import org.graalvm.visualizer.filterwindow.actions.Bundle;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;

public final class NewFilterAction
extends CallableSystemAction {
    public static final String CATEGORY = "Filters";
    public static final String ID = "org.graalvm.visualizer.filterwindow.actions.NewFilterAction";

    public NewFilterAction() {
        this.putValue("ShortDescription", "Create new filter");
    }

    public void performAction() {
        try {
            FilterTopComponent.findInstance().newFilter();
        }
        catch (IOException ex) {
            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)Bundle.MSG_FilterCreateFailed(ex.toString()), 0);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)msg);
        }
    }

    public String getName() {
        return NbBundle.getMessage(NewFilterAction.class, (String)"CTL_NewFilterAction");
    }

    protected void initialize() {
        super.initialize();
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected String iconResource() {
        return "org/graalvm/visualizer/filterwindow/images/plus.png";
    }
}

