/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.filterwindow.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import org.graalvm.visualizer.filter.profiles.FilterProfile;
import org.graalvm.visualizer.filter.profiles.mgmt.ProfileService;
import org.graalvm.visualizer.filter.profiles.mgmt.ProfileStorage;
import org.graalvm.visualizer.filterwindow.actions.Bundle;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public class NewProfileAction
extends AbstractAction {
    private final ProfileService profileService;
    private final ProfileStorage storageService;
    public static final String CATEGORY = "Filters";
    public static final String ID = "org.graalvm.visualizer.filterwindow.actions.NewProfileAction";

    public NewProfileAction() {
        this(Lookup.getDefault());
    }

    public NewProfileAction(Lookup lkp) {
        this.profileService = (ProfileService)lkp.lookup(ProfileService.class);
        this.storageService = (ProfileStorage)this.profileService.getLookup().lookup(ProfileStorage.class);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FilterProfile p;
        NotifyDescriptor.InputLine l = new NotifyDescriptor.InputLine(Bundle.LBL_NewProfileName(), Bundle.TITLE_NewProfile());
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)l) != NotifyDescriptor.OK_OPTION) {
            return;
        }
        String name = l.getInputText();
        FileObject parent = this.storageService.getProfileFolder(this.profileService.getDefaultProfile());
        String fn = FileUtil.findFreeFileName((FileObject)parent, (String)name, (String)"");
        for (FilterProfile p2 : this.profileService.getProfiles()) {
            if (!p2.getName().equalsIgnoreCase(name)) continue;
            NotifyDescriptor.Message conf = new NotifyDescriptor.Message((Object)Bundle.ERR_FilterProfileExists(name), 1);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)conf);
            name = fn;
            break;
        }
        try {
            p = this.profileService.createProfile(name, this.profileService.getSelectedProfile());
        }
        catch (IOException ex) {
            NotifyDescriptor.Message err = new NotifyDescriptor.Message((Object)Bundle.ERR_CannotCreateProfile(ex.toString()), 2);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)err);
            return;
        }
        this.profileService.setSelectedProfile(p);
    }
}

